/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataModel;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.sources.ListContentProvider;
import org.eclipse.incquery.viewers.runtime.sources.QueryLabelProvider;
import org.eclipse.incquery.viewers.runtime.sources.TreeContentProvider;
import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;

public class IncQueryViewerSupport {
    public static void bind(AbstractListViewer viewer, ViewerDataModel model) {
        IncQueryViewerSupport.bind(viewer, model, ViewerDataFilter.UNFILTERED);
    }

    public static void bind(AbstractListViewer viewer, ViewerDataModel model, ViewerDataFilter filter) {
        if (!(viewer.getContentProvider() instanceof ListContentProvider)) {
            viewer.setContentProvider((IContentProvider)new ListContentProvider());
        }
        if (!(viewer.getLabelProvider() instanceof QueryLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new QueryLabelProvider());
        }
        viewer.setInput((Object)new ViewerState(model, filter, (Collection<ViewerState.ViewerStateFeature>)ImmutableSet.of((Object)((Object)ViewerState.ViewerStateFeature.CONTAINMENT))));
        viewer.refresh();
    }

    public static void bind(AbstractTreeViewer viewer, ViewerDataModel model) {
        IncQueryViewerSupport.bind(viewer, model, ViewerDataFilter.UNFILTERED);
    }

    public static void bind(AbstractTreeViewer viewer, ViewerDataModel model, ViewerDataFilter filter) {
        if (!(viewer.getContentProvider() instanceof TreeContentProvider)) {
            viewer.setContentProvider((IContentProvider)new TreeContentProvider());
        }
        if (!(viewer.getLabelProvider() instanceof QueryLabelProvider)) {
            viewer.setLabelProvider((IBaseLabelProvider)new QueryLabelProvider());
        }
        viewer.setInput((Object)new ViewerState(model, filter, (Collection<ViewerState.ViewerStateFeature>)ImmutableSet.of((Object)((Object)ViewerState.ViewerStateFeature.CONTAINMENT))));
        viewer.refresh();
    }
}

