/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.incquery.runtime.api.GenericPatternMatch;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.EventFilterBuilder;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.NotationPackage;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.specifications.ContainmentQuerySpecificationDescriptor;
import org.eclipse.incquery.viewmodel.core.ViewModelManager;
import org.eclipse.incquery.viewmodel.core.ViewModelRule;
import org.eclipse.incquery.viewmodel.core.util.ViewModelUtil;
import org.eclipse.incquery.viewmodel.traceablilty.generic.AbstractQuerySpecificationDescriptor;

public class ContainmentRule
extends ViewModelRule {
    private final ContainmentQuerySpecificationDescriptor descriptor;
    private final ViewerState state;
    private ViewerDataFilter filter;

    public ContainmentRule(ContainmentQuerySpecificationDescriptor descriptor, ViewerState state, ViewerDataFilter filter) {
        super((AbstractQuerySpecificationDescriptor)descriptor);
        this.descriptor = descriptor;
        this.state = state;
        this.filter = filter;
    }

    public static ContainmentRule initiate(IQuerySpecification<?> specification, PAnnotation annotation, ViewerState state, ViewerDataFilter filter) throws QueryInitializationException {
        ContainmentQuerySpecificationDescriptor descriptor = new ContainmentQuerySpecificationDescriptor(specification, annotation);
        return new ContainmentRule(descriptor, state, filter);
    }

    private EventFilter<IPatternMatch> createFilter(ViewerDataFilter baseFilter) {
        if (!baseFilter.isFiltered(this.getBaseSpecification())) {
            return null;
        }
        ViewerFilterDefinition filterDefinition = baseFilter.getFilter(this.getBaseSpecification());
        return EventFilterBuilder.createEventFilter(filterDefinition, this.getReferencedSpecification());
    }

    public Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, (IMatchProcessor)new IMatchProcessor<GenericPatternMatch>(){

            public void process(GenericPatternMatch match) {
                String sourceParam = "trace<" + ContainmentRule.this.descriptor.getContainer() + ">";
                String targetParam = "trace<" + ContainmentRule.this.descriptor.getItem() + ">";
                Item source = (Item)match.get(sourceParam);
                Item target = (Item)match.get(targetParam);
                EObject eObject = ViewModelUtil.create((EClass)NotationPackage.eINSTANCE.getContainment(), (EObject)ContainmentRule.this.state.getNotationModel(), (EReference)NotationPackage.eINSTANCE.getNotationModel_Containments());
                ViewModelUtil.trace((ViewModelManager)ContainmentRule.this.state.getManager(), (String)ContainmentRule.this.getBaseSpecification().getFullyQualifiedName(), Collections.singleton(eObject), (Object[])new Object[]{match.get(ContainmentRule.this.descriptor.getContainer()), match.get(ContainmentRule.this.descriptor.getItem())});
                Containment edge = (Containment)eObject;
                target.setParent(source);
                edge.setSource(source);
                edge.setTarget(target);
                ContainmentRule.this.state.containmentAppeared(edge);
                ContainmentRule.this.logger.debug((Object)("Containment appeared: <" + ContainmentRule.this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
            }
        }));
    }

    public Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, (IMatchProcessor)new IMatchProcessor<GenericPatternMatch>(){

            public void process(GenericPatternMatch match) {
                if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Containment) {
                    Collection edges = ViewModelUtil.delete((GenericPatternMatch)match);
                    for (EObject edge : edges) {
                        ContainmentRule.this.state.containmentDisappeared((Containment)edge);
                        ContainmentRule.this.logger.debug((Object)("Containment disappeared: <" + ContainmentRule.this.getTracedSpecification().getFullyQualifiedName() + ">" + edge.toString()));
                    }
                }
            }
        }));
    }

    protected EventFilter<IPatternMatch> prepareFilter() {
        return this.createFilter(this.filter);
    }
}

