/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.zest.sources;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.gef4.zest.core.viewers.GraphViewer;
import org.eclipse.gef4.zest.core.viewers.IGraphEntityRelationshipContentProvider;
import org.eclipse.incquery.viewers.runtime.model.Edge;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.model.listeners.AbstractViewerStateListener;
import org.eclipse.incquery.viewers.runtime.model.listeners.IViewerStateListener;
import org.eclipse.jface.viewers.Viewer;

public class ZestContentProvider
extends AbstractViewerStateListener
implements IGraphEntityRelationshipContentProvider {
    GraphViewer viewer;
    ViewerState state;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof GraphViewer));
        this.viewer = (GraphViewer)viewer;
        if (oldInput instanceof ViewerState) {
            ((ViewerState)oldInput).removeStateListener((IViewerStateListener)this);
        }
        if (newInput == null) {
            this.state = null;
        }
        if (newInput instanceof ViewerState) {
            this.state = (ViewerState)newInput;
            this.state.addStateListener((IViewerStateListener)this);
        } else if (newInput != null) {
            throw new IllegalArgumentException(String.format("Invalid input type %s for Zest Viewer.", newInput.getClass().getName()));
        }
    }

    public Object[] getElements(Object inputElement) {
        if (this.state != null) {
            return Iterables.toArray((Iterable)this.state.getItemList(), Item.class);
        }
        return new Object[0];
    }

    public Object[] getRelationships(final Object source, final Object dest) {
        if (this.state != null) {
            return Iterables.toArray((Iterable)Iterables.filter((Iterable)this.state.getEdgeList(), (Predicate)new Predicate<Edge>(){

                public boolean apply(Edge edge) {
                    return edge.getSource().equals(source) && edge.getTarget().equals(dest);
                }
            }), Edge.class);
        }
        return new Object[0];
    }

    public void itemAppeared(Item item) {
        this.viewer.addNode((Object)item);
    }

    public void itemDisappeared(Item item) {
        this.viewer.removeNode((Object)item);
    }

    public void edgeAppeared(Edge edge) {
        this.viewer.addRelationship((Object)edge, (Object)edge.getSource(), (Object)edge.getTarget());
    }

    public void edgeDisappeared(Edge edge) {
        this.viewer.removeRelationship((Object)edge);
    }

    public void dispose() {
        if (this.state != null) {
            this.state.removeStateListener((IViewerStateListener)this);
        }
    }
}

