/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.boundary.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.index.MemoryIdentityIndexer;
import org.eclipse.incquery.runtime.rete.index.MemoryNullIndexer;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;
import org.eclipse.incquery.runtime.rete.tuple.TupleMemory;

public class PredicateEvaluatorNode
extends SingleInputNode {
    protected ReteEngine<?> engine;
    protected ReteBoundary<?> boundary;
    protected Integer rhsIndex;
    protected int[] affectedIndices;
    protected Set<Tuple> outgoing;
    protected MemoryNullIndexer memoryNullIndexer;
    protected MemoryIdentityIndexer memoryIdentityIndexer;
    protected Map<Object, Collection<Tuple>> elementOccurences;
    protected Map<Tuple, Set<Tuple>> invoker2traces;
    protected Map<Tuple, Set<Tuple>> trace2invokers;
    protected AbstractEvaluator evaluator;
    private final int tupleWidth;
    private final TupleMask nullMask;
    private final TupleMask identityMask;

    public PredicateEvaluatorNode(ReteEngine<?> engine, ReteContainer container, Integer rhsIndex, int[] affectedIndices, int tupleWidth, AbstractEvaluator evaluator) {
        super(container);
        this.engine = engine;
        this.boundary = engine.getBoundary();
        this.rhsIndex = rhsIndex;
        this.affectedIndices = affectedIndices;
        this.tupleWidth = tupleWidth;
        this.evaluator = evaluator;
        this.elementOccurences = CollectionsFactory.getMap();
        this.outgoing = CollectionsFactory.getSet();
        this.invoker2traces = CollectionsFactory.getMap();
        this.trace2invokers = CollectionsFactory.getMap();
        this.nullMask = TupleMask.linear(0, tupleWidth);
        this.identityMask = TupleMask.identity(tupleWidth);
    }

    @Override
    public ProjectionIndexer constructIndex(TupleMask mask) {
        if (this.nullMask.equals(mask)) {
            return this.getNullIndexer();
        }
        if (this.identityMask.equals(mask)) {
            return this.getIdentityIndexer();
        }
        return super.constructIndex(mask);
    }

    @Override
    public void pullInto(Collection<Tuple> collector) {
        for (Tuple ps : this.outgoing) {
            collector.add(this.boundary.wrapTuple(ps));
        }
    }

    @Override
    public void update(Direction direction, Tuple wrappers) {
        Tuple updateElement = this.boundary.unwrapTuple(wrappers);
        this.updateOccurences(direction, updateElement);
        if (direction == Direction.REVOKE) {
            if (this.outgoing.remove(updateElement)) {
                this.clearTraces(updateElement);
                this.propagateUpdate(Direction.REVOKE, wrappers);
            }
        } else {
            this.check(updateElement);
        }
    }

    protected void notifyASMFunctionValueChanged(Tuple trace) {
        Set<Tuple> invokers = this.trace2invokers.get(trace);
        if (invokers != null) {
            LinkedList<Tuple> copy = new LinkedList<Tuple>(invokers);
            for (Tuple ps : copy) {
                this.check(ps);
            }
        }
    }

    protected void notifyElementChange(Object element) {
        for (Tuple ps : this.elementOccurences.get(element)) {
            this.check(ps);
        }
    }

    protected void updateOccurences(Direction direction, Tuple ps) {
        int[] nArray = this.affectedIndices;
        int n = this.affectedIndices.length;
        int n2 = 0;
        while (n2 < n) {
            Integer i = nArray[n2];
            Object element = ps.get(i);
            this.updateElementOccurence(direction, ps, element);
            ++n2;
        }
    }

    protected void updateElementOccurence(Direction direction, Tuple ps, Object element) {
        if (direction == Direction.INSERT) {
            boolean change;
            TupleMemory occurences = this.elementOccurences.get(element);
            boolean bl = change = occurences == null;
            if (change) {
                occurences = new TupleMemory();
                this.elementOccurences.put(element, occurences);
                this.engine.getManipulationListener().registerSensitiveTerm(element, this);
            }
            occurences.add((Tuple)ps);
        } else {
            Collection<Tuple> occurences = this.elementOccurences.get(element);
            occurences.remove(ps);
            boolean change = occurences.isEmpty();
            if (change) {
                this.elementOccurences.remove(element);
                this.engine.getManipulationListener().unregisterSensitiveTerm(element, this);
            }
        }
    }

    protected void check(Tuple ps) {
        boolean result = this.evaluateExpression(ps);
        if (result) {
            if (this.outgoing.add(ps)) {
                this.propagateUpdate(Direction.INSERT, this.boundary.wrapTuple(ps));
            }
        } else if (this.outgoing.remove(ps)) {
            this.propagateUpdate(Direction.REVOKE, this.boundary.wrapTuple(ps));
        }
    }

    protected boolean evaluateExpression(Tuple ps) {
        Object termResult = this.evaluateTerm(ps);
        if (this.rhsIndex != null) {
            Object rightHandSide = ps.get(this.rhsIndex);
            return rightHandSide.equals(termResult);
        }
        if (Boolean.FALSE.equals(termResult)) {
            return false;
        }
        if (Boolean.TRUE.equals(termResult)) {
            return true;
        }
        this.engine.getContext().logWarning(String.format("The incremental pattern matcher encountered a type compatibility problem during check() evaluation for pattern(s) %s over variables %s: expression evaluated to type %s instead of java.lang.Boolean. (Developer note: result was %s in %s)", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), termResult == null ? null : termResult.getClass().getName(), termResult, this));
        return false;
    }

    public Object evaluateTerm(Tuple ps) {
        this.clearTraces(ps);
        Object result = null;
        try {
            result = this.evaluator.evaluate(ps);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            this.engine.getContext().logWarning(String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.rhsIndex == null ? "check()" : "eval()", this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this), e);
            result = Boolean.FALSE;
        }
        this.saveTraces(ps, this.evaluator.getTraces());
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    protected void clearTraces(Tuple invoker) {
        Set<Tuple> traces = this.invoker2traces.get(invoker);
        if (traces != null) {
            this.invoker2traces.remove(invoker);
            for (Tuple trace : traces) {
                Set<Tuple> invokers = this.trace2invokers.get(trace);
                invokers.remove(invoker);
                if (!invokers.isEmpty()) continue;
                this.trace2invokers.remove(trace);
                this.engine.geTraceListener().unregisterSensitiveTrace(trace, this);
            }
        }
    }

    protected void saveTraces(Tuple invoker, Set<Tuple> traces) {
        if (traces != null && !traces.isEmpty()) {
            this.invoker2traces.put(invoker, traces);
            for (Tuple trace : traces) {
                Set<Tuple> invokers = this.trace2invokers.get(trace);
                if (invokers == null) {
                    invokers = CollectionsFactory.getSet();
                    this.trace2invokers.put(trace, invokers);
                    this.engine.geTraceListener().registerSensitiveTrace(trace, this);
                }
                invokers.add(invoker);
            }
        }
    }

    @Override
    protected void propagateUpdate(Direction direction, Tuple updateElement) {
        super.propagateUpdate(direction, updateElement);
        if (this.memoryIdentityIndexer != null) {
            this.memoryIdentityIndexer.propagate(direction, updateElement);
        }
        if (this.memoryNullIndexer != null) {
            this.memoryNullIndexer.propagate(direction, updateElement);
        }
    }

    public ReteEngine<?> getEngine() {
        return this.engine;
    }

    public MemoryNullIndexer getNullIndexer() {
        if (this.memoryNullIndexer == null) {
            this.memoryNullIndexer = new MemoryNullIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryNullIndexer;
    }

    public MemoryIdentityIndexer getIdentityIndexer() {
        if (this.memoryIdentityIndexer == null) {
            this.memoryIdentityIndexer = new MemoryIdentityIndexer(this.reteContainer, this.tupleWidth, this.outgoing, this, this);
        }
        return this.memoryIdentityIndexer;
    }
}

