/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.localsearch.plan;

import org.eclipse.incquery.runtime.localsearch.MatchingFrame;
import org.eclipse.incquery.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.incquery.runtime.localsearch.operations.ISearchOperation;

public class SearchPlan {
    private int currentOperation;
    private ISearchOperation[] operations;

    public SearchPlan(ISearchOperation[] operations) {
        this.operations = operations;
        this.currentOperation = -1;
    }

    private void init(MatchingFrame frame) throws LocalSearchException {
        if (this.currentOperation == -1) {
            ++this.currentOperation;
            this.operations[this.currentOperation].onInitialize(frame);
        } else if (this.currentOperation == this.operations.length) {
            --this.currentOperation;
        } else {
            throw new LocalSearchException("Error while executing search plan");
        }
    }

    public double cost() {
        return 0.0;
    }

    public boolean execute(MatchingFrame frame) throws LocalSearchException {
        int upperBound = this.operations.length - 1;
        this.init(frame);
        while (this.currentOperation >= 0 && this.currentOperation <= upperBound) {
            if (this.operations[this.currentOperation].execute(frame)) {
                ++this.currentOperation;
                if (this.currentOperation > upperBound) continue;
                this.operations[this.currentOperation].onInitialize(frame);
                continue;
            }
            this.operations[this.currentOperation].onBacktrack(frame);
            --this.currentOperation;
        }
        return this.currentOperation > upperBound;
    }

    public void resetPlan() {
        this.currentOperation = -1;
    }

    public void printDebugInformation() {
        int i = 0;
        while (i < this.operations.length) {
            System.out.println("[" + i + "]\t" + this.operations[i].toString());
            ++i;
        }
    }
}

