/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model.converters;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.StaleEvent;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetDiff;

public abstract class FixedComputedSet
extends AbstractObservableSet {
    private Set cachedSet = new HashSet();
    private boolean dirty = true;
    private boolean stale = false;
    private IObservable[] dependencies = new IObservable[0];
    private PrivateInterface privateInterface = new PrivateInterface();
    private Object elementType;

    public FixedComputedSet() {
        this(Realm.getDefault(), null);
    }

    public FixedComputedSet(Object elementType) {
        this(Realm.getDefault(), elementType);
    }

    public FixedComputedSet(Realm realm) {
        this(realm, null);
    }

    public FixedComputedSet(Realm realm, Object elementType) {
        super(realm);
        this.elementType = elementType;
    }

    protected int doGetSize() {
        return this.doGetSet().size();
    }

    private final Set getSet() {
        this.getterCalled();
        return this.doGetSet();
    }

    protected Set getWrappedSet() {
        return this.doGetSet();
    }

    final Set doGetSet() {
        if (this.dirty) {
            IObservable[] newDependencies = ObservableTracker.runAndMonitor((Runnable)this.privateInterface, (IChangeListener)this.privateInterface, null);
            this.stale = false;
            int i = 0;
            while (i < newDependencies.length) {
                if (newDependencies[i].isStale()) {
                    this.makeStale();
                    break;
                }
                ++i;
            }
            if (!this.stale) {
                i = 0;
                while (i < newDependencies.length) {
                    newDependencies[i].addStaleListener((IStaleListener)this.privateInterface);
                    ++i;
                }
            }
            this.dependencies = newDependencies;
            this.dirty = false;
        }
        return this.cachedSet;
    }

    protected abstract Set calculate();

    private void makeDirty() {
        if (!this.dirty) {
            this.dirty = true;
            final HashSet oldSet = new HashSet(this.cachedSet);
            this.makeStale();
            this.stopListening();
            this.fireSetChange(new SetDiff(){
                SetDiff delegate;

                private SetDiff getDelegate() {
                    if (this.delegate == null) {
                        this.delegate = Diffs.computeSetDiff((Set)oldSet, (Set)FixedComputedSet.this.getSet());
                    }
                    return this.delegate;
                }

                public Set getAdditions() {
                    return this.getDelegate().getAdditions();
                }

                public Set getRemovals() {
                    return this.getDelegate().getRemovals();
                }
            });
        }
    }

    private void stopListening() {
        if (this.dependencies != null) {
            int i = 0;
            while (i < this.dependencies.length) {
                IObservable observable = this.dependencies[i];
                observable.removeChangeListener((IChangeListener)this.privateInterface);
                observable.removeStaleListener((IStaleListener)this.privateInterface);
                ++i;
            }
            this.dependencies = null;
        }
    }

    private void makeStale() {
        if (!this.stale) {
            this.stale = true;
            this.fireStale();
        }
    }

    public boolean isStale() {
        this.getSet();
        return this.stale;
    }

    public Object getElementType() {
        return this.elementType;
    }

    public synchronized void addChangeListener(IChangeListener listener) {
        super.addChangeListener(listener);
        this.computeSetForListeners();
    }

    public synchronized void addSetChangeListener(ISetChangeListener listener) {
        super.addSetChangeListener(listener);
        this.computeSetForListeners();
    }

    private void computeSetForListeners() {
        this.getRealm().exec(new Runnable(){

            @Override
            public void run() {
                if (FixedComputedSet.this.dependencies == null) {
                    FixedComputedSet.this.getSet();
                }
            }
        });
    }

    public synchronized void dispose() {
        this.stopListening();
        super.dispose();
    }

    private class PrivateInterface
    implements Runnable,
    IChangeListener,
    IStaleListener {
        private PrivateInterface() {
        }

        @Override
        public void run() {
            FixedComputedSet.this.cachedSet = FixedComputedSet.this.calculate();
            if (FixedComputedSet.this.cachedSet == null) {
                FixedComputedSet.this.cachedSet = Collections.EMPTY_SET;
            }
        }

        public void handleStale(StaleEvent event) {
            if (!FixedComputedSet.this.dirty) {
                FixedComputedSet.this.makeStale();
            }
        }

        public void handleChange(ChangeEvent event) {
            FixedComputedSet.this.makeDirty();
        }
    }
}

