/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem;

import java.util.Set;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.helpers.BuildHelper;
import org.eclipse.incquery.runtime.rete.construction.psystem.BasePConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;

public abstract class EnumerablePConstraint<PatternDescription, StubHandle>
extends BasePConstraint<PatternDescription, StubHandle> {
    protected Tuple variablesTuple;
    private Stub<StubHandle> stub;

    protected EnumerablePConstraint(PSystem<PatternDescription, StubHandle, ?> pSystem, Tuple variablesTuple) {
        super(pSystem, variablesTuple.getDistinctElements());
        this.variablesTuple = variablesTuple;
    }

    public Stub<StubHandle> getStub() throws RetePatternBuildException {
        if (this.stub == null) {
            this.stub = this.doCreateStub();
            this.stub.addConstraint(this);
            this.stub = BuildHelper.enforceVariableCoincidences(this.buildable, this.stub);
        }
        return this.stub;
    }

    public abstract Stub<StubHandle> doCreateStub() throws RetePatternBuildException;

    @Override
    public void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        this.variablesTuple = this.variablesTuple.replaceAll(obsolete, replacement);
    }

    @Override
    protected String toStringRest() {
        String stringRestRest = this.toStringRestRest();
        String tupleString = "@" + this.variablesTuple.toString();
        return stringRestRest == null ? tupleString : ":" + stringRestRest + tupleString;
    }

    protected String toStringRestRest() {
        return null;
    }

    public Tuple getVariablesTuple() {
        return this.variablesTuple;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        return this.getAffectedVariables();
    }
}

