/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.xcore.editor;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.incquery.patternlanguage.emf.specification.SpecificationBuilder;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegateFactory;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.xcore.editor.DummyDiagnosticDecorator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class CustomizedEcoreEditor
extends EcoreEditor {
    @Inject
    IResourceSetProvider provider;
    private Set<String> specs = new HashSet<String>();
    private final ISelectionListener revealSelectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (!part.equals((Object)CustomizedEcoreEditor.this) && selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                ArrayList<EObject> eSel = new ArrayList<EObject>();
                Object[] objectArray = sel.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object _o = objectArray[n2];
                    System.out.println("\t" + _o);
                    if (_o instanceof EObject) {
                        eSel.add((EObject)_o);
                    }
                    ++n2;
                }
                CustomizedEcoreEditor.this.setSelectionToViewer(eSel);
            }
        }
    };

    private void log(String msg) {
        EcoreEditorPlugin.INSTANCE.log((Object)msg);
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        super.init(site, editorInput);
        site.getPage().addSelectionListener(this.revealSelectionListener);
    }

    private void initializeRegistryFromSeparateResourceSet_MainResourceTraversal(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            ResourceSet resourceSet = this.provider.get(((IFileEditorInput)input).getFile().getProject());
            for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
                Resource patternResource;
                if (!resource.getURI().toString().endsWith(".eiq") || (patternResource = resourceSet.getResource(resource.getURI(), true)) == null) continue;
                this.initReg(patternResource);
            }
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        final HashMap<String, String> saveOptions = new HashMap<String, String>();
        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
        saveOptions.put("LINE_DELIMITER", "");
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                boolean first = true;
                HashSet<Resource> processedResources = new HashSet<Resource>();
                while (processedResources.size() != CustomizedEcoreEditor.this.editingDomain.getResourceSet().getResources().size()) {
                    HashSet resources = new HashSet(CustomizedEcoreEditor.this.editingDomain.getResourceSet().getResources());
                    resources.removeAll(processedResources);
                    for (Resource resource : resources) {
                        if ((first || !resource.getContents().isEmpty() || CustomizedEcoreEditor.this.isPersisted(resource)) && !CustomizedEcoreEditor.this.editingDomain.isReadOnly(resource)) {
                            try {
                                long timeStamp = resource.getTimeStamp();
                                resource.save(saveOptions);
                                if (resource.getTimeStamp() != timeStamp) {
                                    CustomizedEcoreEditor.this.savedResources.add(resource);
                                }
                            }
                            catch (Exception exception) {
                                CustomizedEcoreEditor.this.resourceToDiagnosticMap.put(resource, CustomizedEcoreEditor.this.analyzeResourceProblems(resource, exception));
                            }
                            first = false;
                        }
                        processedResources.add(resource);
                    }
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)operation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.firePropertyChange(257);
        }
        catch (Exception exception) {
            EcoreEditorPlugin.INSTANCE.log((Object)exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    private void initReg(Resource patternResource) {
        block8: {
            block7: {
                if (patternResource.getErrors().size() != 0 || patternResource.getContents().size() < 1) break block7;
                this.log("Registering derived feature patterns from " + patternResource.getURI());
                SpecificationBuilder builder = new SpecificationBuilder((Collection)QuerySpecificationRegistry.getContributedQuerySpecifications());
                EObject topElement = (EObject)patternResource.getContents().get(0);
                if (!(topElement instanceof PatternModel)) break block8;
                for (Pattern pattern : ((PatternModel)topElement).getPatterns()) {
                    String fqn = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                    if (!this.specs.contains(fqn)) {
                        IQuerySpecification spec;
                        try {
                            spec = builder.getOrCreateSpecification(pattern);
                        }
                        catch (IncQueryException e) {
                            e.printStackTrace();
                            return;
                        }
                        QueryBasedFeatureSettingDelegateFactory f = (QueryBasedFeatureSettingDelegateFactory)EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.get((Object)"org.eclipse.incquery.querybasedfeature");
                        if (f != null) {
                            f.getSpecificationMap().put(fqn, spec);
                            this.log("Registered derived feature pattern directly through QBFSDF " + fqn);
                        } else {
                            QuerySpecificationRegistry.registerQuerySpecification((IQuerySpecification)spec);
                            this.log("Registered derived feature pattern indirectly through QSR " + fqn);
                        }
                        this.specs.add(fqn);
                        continue;
                    }
                    this.log("Skipped the duplicate registration of derived feature pattern " + fqn);
                }
                break block8;
            }
            this.log("Skipping derived feature pattern registration from " + patternResource.getURI() + " due to the number of errors: " + patternResource.getErrors().size());
            for (Resource.Diagnostic d : patternResource.getErrors()) {
                this.log("\t" + d.getMessage());
            }
        }
    }

    public void dispose() {
        this.getSite().getPage().removeSelectionListener(this.revealSelectionListener);
        super.dispose();
        for (String spec : this.specs) {
            QueryBasedFeatureSettingDelegateFactory f = (QueryBasedFeatureSettingDelegateFactory)EStructuralFeature.Internal.SettingDelegate.Factory.Registry.INSTANCE.get((Object)"org.eclipse.incquery.querybasedfeature");
            if (f != null) {
                f.getSpecificationMap().remove(spec);
            } else {
                QuerySpecificationRegistry.unregisterQuerySpecification((String)spec);
            }
            this.log("Unregistered " + spec);
        }
    }

    public void createPages() {
        this.createModel();
        this.initializeRegistryFromSeparateResourceSet_MainResourceTraversal(this.getEditorInput());
        if (!this.getEditingDomain().getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(this.getContainer(), 2);
            this.selectionViewer = new TreeViewer(tree);
            this.setCurrentViewer((Viewer)this.selectionViewer);
            this.selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
            this.selectionViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory), (ILabelDecorator)new DummyDiagnosticDecorator((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer, EcoreEditorPlugin.getPlugin().getDialogSettings())));
            this.selectionViewer.setInput((Object)this.editingDomain.getResourceSet());
            this.selectionViewer.setSelection((ISelection)new StructuredSelection(this.editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(this.selectionViewer.getTree(), (AdapterFactory)this.adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)this.editingDomain, (StructuredViewer)this.selectionViewer));
            this.createContextMenuFor((StructuredViewer)this.selectionViewer);
            int pageIndex = this.addPage((Control)tree);
            this.setPageText(pageIndex, "TODO");
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CustomizedEcoreEditor.this.setActivePage(0);
                }
            });
        }
        this.getContainer().addControlListener((ControlListener)new ControlAdapter(){
            boolean guard = false;

            public void controlResized(ControlEvent event) {
                if (!this.guard) {
                    this.guard = true;
                    CustomizedEcoreEditor.this.hideTabs();
                    this.guard = false;
                }
            }
        });
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                CustomizedEcoreEditor.this.updateProblemIndication();
            }
        });
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.contentOutlinePage == null) {
            class MyContentOutlinePage
            extends ContentOutlinePage {
                MyContentOutlinePage() {
                }

                public void createControl(Composite parent) {
                    super.createControl(parent);
                    CustomizedEcoreEditor.this.contentOutlineViewer = this.getTreeViewer();
                    CustomizedEcoreEditor.this.contentOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    CustomizedEcoreEditor.this.contentOutlineViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)CustomizedEcoreEditor.this.adapterFactory));
                    CustomizedEcoreEditor.this.contentOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)CustomizedEcoreEditor.this.adapterFactory), (ILabelDecorator)new DummyDiagnosticDecorator((EditingDomain)CustomizedEcoreEditor.this.editingDomain, (StructuredViewer)CustomizedEcoreEditor.this.contentOutlineViewer, EcoreEditorPlugin.getPlugin().getDialogSettings())));
                    CustomizedEcoreEditor.this.contentOutlineViewer.setInput((Object)CustomizedEcoreEditor.this.editingDomain.getResourceSet());
                    new ColumnViewerInformationControlToolTipSupport((ColumnViewer)CustomizedEcoreEditor.this.contentOutlineViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener((EditingDomain)CustomizedEcoreEditor.this.editingDomain, (StructuredViewer)CustomizedEcoreEditor.this.contentOutlineViewer));
                    CustomizedEcoreEditor.this.createContextMenuFor((StructuredViewer)CustomizedEcoreEditor.this.contentOutlineViewer);
                    if (!CustomizedEcoreEditor.this.editingDomain.getResourceSet().getResources().isEmpty()) {
                        CustomizedEcoreEditor.this.contentOutlineViewer.setSelection((ISelection)new StructuredSelection(CustomizedEcoreEditor.this.editingDomain.getResourceSet().getResources().get(0)), true);
                    }
                }

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                    CustomizedEcoreEditor.this.contentOutlineStatusLineManager = statusLineManager;
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    CustomizedEcoreEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
                }
            }
            this.contentOutlinePage = new MyContentOutlinePage();
            this.contentOutlinePage.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    CustomizedEcoreEditor.this.handleContentOutlineSelection(event.getSelection());
                }
            });
        }
        return this.contentOutlinePage;
    }

    public IPropertySheetPage getPropertySheetPage() {
        ExtendedPropertySheetPage propertySheetPage = new ExtendedPropertySheetPage(this.editingDomain, ExtendedPropertySheetPage.Decoration.NONE, EcoreEditorPlugin.getPlugin().getDialogSettings()){

            public void setSelectionToViewer(List<?> selection) {
                CustomizedEcoreEditor.this.setSelectionToViewer(selection);
                CustomizedEcoreEditor.this.setFocus();
            }

            public void setActionBars(IActionBars actionBars) {
                super.setActionBars(actionBars);
                CustomizedEcoreEditor.this.getActionBarContributor().shareGlobalActions((IPage)this, actionBars);
            }
        };
        propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.propertySheetPages.add(propertySheetPage);
        return propertySheetPage;
    }
}

