/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.incquery.runtime.api.GenericPatternMatch;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.viewers.runtime.model.EventFilterBuilder;
import org.eclipse.incquery.viewers.runtime.model.FormatSpecification;
import org.eclipse.incquery.viewers.runtime.model.Item;
import org.eclipse.incquery.viewers.runtime.model.NotationPackage;
import org.eclipse.incquery.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.incquery.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.incquery.viewers.runtime.model.ViewerState;
import org.eclipse.incquery.viewers.runtime.specifications.ItemQuerySpecificationDescriptor;
import org.eclipse.incquery.viewers.runtime.util.FormatParser;
import org.eclipse.incquery.viewers.runtime.util.LabelParser;
import org.eclipse.incquery.viewmodel.core.ViewModelManager;
import org.eclipse.incquery.viewmodel.core.ViewModelRule;
import org.eclipse.incquery.viewmodel.core.util.ViewModelUtil;
import org.eclipse.incquery.viewmodel.traceablilty.generic.AbstractQuerySpecificationDescriptor;

public class ItemRule
extends ViewModelRule {
    private final ItemQuerySpecificationDescriptor descriptor;
    private final ViewerState state;
    private ViewerDataFilter baseFilter;

    private ItemRule(ItemQuerySpecificationDescriptor descriptor, ViewerState state, ViewerDataFilter filter) throws QueryInitializationException {
        super((AbstractQuerySpecificationDescriptor)descriptor);
        this.state = state;
        this.descriptor = descriptor;
        this.baseFilter = filter;
    }

    public static ItemRule initiate(IQuerySpecification<?> specification, PAnnotation annotation, ViewerState state, ViewerDataFilter filter) throws QueryInitializationException {
        ItemQuerySpecificationDescriptor descriptor = new ItemQuerySpecificationDescriptor(specification, annotation);
        return new ItemRule(descriptor, state, filter);
    }

    private EventFilter<IPatternMatch> createFilter(ViewerDataFilter baseFilter) {
        if (!baseFilter.isFiltered(this.getBaseSpecification())) {
            return null;
        }
        ViewerFilterDefinition filterDefinition = baseFilter.getFilter(this.getBaseSpecification());
        return EventFilterBuilder.createEventFilter(filterDefinition, this.getReferencedSpecification());
    }

    public Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, (IMatchProcessor)new IMatchProcessor<GenericPatternMatch>(){

            public void process(GenericPatternMatch match) {
                Object param = match.get(ItemRule.this.descriptor.getSource());
                EObject eObject = ViewModelUtil.create((EClass)NotationPackage.eINSTANCE.getItem(), (EObject)ItemRule.this.state.getNotationModel(), (EReference)NotationPackage.eINSTANCE.getNotationModel_Items());
                ViewModelUtil.trace((ViewModelManager)ItemRule.this.state.getManager(), (String)ItemRule.this.getBaseSpecification().getFullyQualifiedName(), Collections.singleton(eObject), (Object[])new Object[]{param});
                Item item = (Item)eObject;
                if (param instanceof EObject) {
                    item.setParamEObject((EObject)param);
                } else {
                    item.setParamObject(param);
                }
                item.setPolicy(ItemRule.this.descriptor.getPolicy());
                item.setLabel(LabelParser.calculateLabel(match, ItemRule.this.descriptor.getLabel()));
                if (ItemRule.this.descriptor.isFormatted()) {
                    FormatSpecification formatSpecification = FormatParser.parseFormatAnnotation(ItemRule.this.descriptor.getFormatAnnotation());
                    item.setFormat(formatSpecification);
                }
                ItemRule.this.state.itemAppeared(item);
                ItemRule.this.logger.debug((Object)("Item appeared: <" + ItemRule.this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
            }
        }));
    }

    public Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, (IMatchProcessor)new IMatchProcessor<GenericPatternMatch>(){

            public void process(GenericPatternMatch match) {
                if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Item) {
                    Collection deletedItems = ViewModelUtil.delete((GenericPatternMatch)match);
                    for (EObject item : deletedItems) {
                        ItemRule.this.state.itemDisappeared((Item)item);
                        ItemRule.this.logger.debug((Object)("Item disappeared: <" + ItemRule.this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
                    }
                }
            }
        }));
    }

    public Job<GenericPatternMatch> getUpdatedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.UPDATED, (IMatchProcessor)new IMatchProcessor<GenericPatternMatch>(){

            public void process(GenericPatternMatch match) {
                String newLabel;
                Item item;
                String oldLabel;
                if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Item && !(oldLabel = (item = (Item)ViewModelUtil.target((GenericPatternMatch)match)).getLabel()).equals(newLabel = LabelParser.calculateLabel(match, ItemRule.this.descriptor.getLabel()))) {
                    item.setLabel(newLabel);
                    ItemRule.this.state.labelUpdated(item, newLabel);
                    ItemRule.this.logger.debug((Object)("Item updated: <" + ItemRule.this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
                }
            }
        }));
    }

    protected EventFilter<IPatternMatch> prepareFilter() {
        return this.createFilter(this.baseFilter);
    }
}

