package org.eclipse.incquery.viewers.runtime.model.patterns.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.viewers.runtime.model.Containment;
import org.eclipse.incquery.viewers.runtime.model.patterns.Param2containmentMatch;
import org.eclipse.incquery.viewmodel.traceability.Trace;

/**
 * A match processor tailored for the org.eclipse.incquery.viewers.runtime.model.patterns.param2containment pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class Param2containmentProcessor implements IMatchProcessor<Param2containmentMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * @param pTrace the value of pattern parameter trace in the currently processed match
   * @param pContainment the value of pattern parameter containment in the currently processed match
   * 
   */
  public abstract void process(final Object pSource, final Object pTarget, final Trace pTrace, final Containment pContainment);
  
  @Override
  public void process(final Param2containmentMatch match) {
    process(match.getSource(), match.getTarget(), match.getTrace(), match.getContainment());
  }
}
