package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.DirectedRelationshipTargetMatch;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.directedRelationshipTarget pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class DirectedRelationshipTargetProcessor implements IMatchProcessor<DirectedRelationshipTargetMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final DirectedRelationship pSource, final Element pTarget);
  
  @Override
  public void process(final DirectedRelationshipTargetMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
