/**
 * Copyright (c) 2010-2013, Bergmann Gabor, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Bergmann Gabor - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.jvmmodel;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.tooling.core.generator.jvmmodel.JavadocInferrer;
import org.eclipse.incquery.tooling.core.generator.util.EMFJvmTypesBuilder;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * @author Bergmann Gabor
 * 
 * TODO: add Javadoc to generated class and methods.
 */
@SuppressWarnings("all")
public class GroupMatchersClassInferrer {
  @Inject
  @Extension
  private EMFJvmTypesBuilder _eMFJvmTypesBuilder;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  @Extension
  private IJvmModelAssociations _iJvmModelAssociations;
  
  @Inject
  @Extension
  private TypeReferences types;
  
  @Inject
  @Extension
  private JavadocInferrer _javadocInferrer;
  
  public JvmGenericType inferGroupMatchers(final PatternModel model) {
    JvmGenericType _xblockexpression = null;
    {
      EList<Pattern> _patterns = model.getPatterns();
      int _size = _patterns.size();
      boolean _equals = (_size == 0);
      if (_equals) {
        return null;
      }
      String _groupMatchersClassName = this._eMFPatternLanguageJvmModelInferrerUtil.groupMatchersClassName(model);
      final Procedure1<JvmGenericType> _function = new Procedure1<JvmGenericType>() {
        public void apply(final JvmGenericType it) {
          String _packageName = model.getPackageName();
          it.setPackageName(_packageName);
          it.setFinal(true);
        }
      };
      final JvmGenericType matchersClass = this._eMFJvmTypesBuilder.toClass(model, _groupMatchersClassName, _function);
      EList<JvmMember> _members = matchersClass.getMembers();
      JvmTypeReference _newTypeRef = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryEngine.class);
      JvmField _field = this._eMFJvmTypesBuilder.toField(model, "engine", _newTypeRef);
      this._eMFJvmTypesBuilder.<JvmField>operator_add(_members, _field);
      EList<JvmMember> _members_1 = matchersClass.getMembers();
      JvmConstructor _inferConstructor = this.inferConstructor(model);
      this._eMFJvmTypesBuilder.<JvmConstructor>operator_add(_members_1, _inferConstructor);
      HashSet<JvmGenericType> _gatherMatchers = this.gatherMatchers(model);
      for (final JvmGenericType matcherRef : _gatherMatchers) {
        EList<JvmMember> _members_2 = matchersClass.getMembers();
        JvmOperation _inferMatcherGetter = this.inferMatcherGetter(model, matcherRef);
        this._eMFJvmTypesBuilder.<JvmOperation>operator_add(_members_2, _inferMatcherGetter);
      }
      _xblockexpression = (matchersClass);
    }
    return _xblockexpression;
  }
  
  public JvmOperation inferMatcherGetter(final PatternModel model, final JvmGenericType matcherClass) {
    JvmOperation _xblockexpression = null;
    {
      final JvmTypeReference incQueryException = this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryException.class);
      String _simpleName = matcherClass.getSimpleName();
      String _plus = ("get" + _simpleName);
      JvmParameterizedTypeReference _createTypeRef = this.types.createTypeRef(matcherClass);
      final Procedure1<JvmOperation> _function = new Procedure1<JvmOperation>() {
        public void apply(final JvmOperation it) {
          it.setVisibility(JvmVisibility.PUBLIC);
          EList<JvmTypeReference> _exceptions = it.getExceptions();
          GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.<JvmTypeReference>operator_add(_exceptions, incQueryException);
          final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
            public void apply(final ITreeAppendable it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("return ");
              it.append(_builder);
              JvmParameterizedTypeReference _createTypeRef = GroupMatchersClassInferrer.this.types.createTypeRef(matcherClass);
              GroupMatchersClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.serialize(it, _createTypeRef, model);
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append(".on(engine);");
              it.append(_builder_1);
            }
          };
          GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
        }
      };
      JvmOperation _method = this._eMFJvmTypesBuilder.toMethod(model, _plus, _createTypeRef, _function);
      _xblockexpression = (_method);
    }
    return _xblockexpression;
  }
  
  public JvmConstructor inferConstructor(final PatternModel model) {
    final Procedure1<JvmConstructor> _function = new Procedure1<JvmConstructor>() {
      public void apply(final JvmConstructor it) {
        it.setVisibility(JvmVisibility.PUBLIC);
        String _groupMatchersClassName = GroupMatchersClassInferrer.this._eMFPatternLanguageJvmModelInferrerUtil.groupMatchersClassName(model);
        it.setSimpleName(_groupMatchersClassName);
        EList<JvmFormalParameter> _parameters = it.getParameters();
        JvmTypeReference _newTypeRef = GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.newTypeRef(model, IncQueryEngine.class);
        JvmFormalParameter _parameter = GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.toParameter(model, "engine", _newTypeRef);
        GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.<JvmFormalParameter>operator_add(_parameters, _parameter);
        final Procedure1<ITreeAppendable> _function = new Procedure1<ITreeAppendable>() {
          public void apply(final ITreeAppendable it) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this.engine = engine;");
            _builder.newLine();
            it.append(_builder);
          }
        };
        GroupMatchersClassInferrer.this._eMFJvmTypesBuilder.setBody(it, _function);
      }
    };
    JvmConstructor _constructor = this._eMFJvmTypesBuilder.toConstructor(model, _function);
    return _constructor;
  }
  
  public HashSet<JvmGenericType> gatherMatchers(final PatternModel model) {
    HashSet<JvmGenericType> _xblockexpression = null;
    {
      HashSet<JvmGenericType> _hashSet = new HashSet<JvmGenericType>();
      final HashSet<JvmGenericType> result = _hashSet;
      EList<Pattern> _patterns = model.getPatterns();
      for (final Pattern pattern : _patterns) {
        boolean _isPrivate = CorePatternLanguageHelper.isPrivate(pattern);
        boolean _not = (!_isPrivate);
        if (_not) {
          final Set<EObject> jvmElements = this._iJvmModelAssociations.getJvmElements(pattern);
          final Function1<EObject,Boolean> _function = new Function1<EObject,Boolean>() {
            public Boolean apply(final EObject e) {
              return Boolean.valueOf((e instanceof JvmGenericType));
            }
          };
          final EObject matcherClass = IterableExtensions.<EObject>findFirst(jvmElements, _function);
          if ((matcherClass instanceof JvmGenericType)) {
            result.add(((JvmGenericType) matcherClass));
          }
        }
      }
      _xblockexpression = (result);
    }
    return _xblockexpression;
  }
}
