/**
 * Copyright (c) 2010-2013, Tamas Szabo, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Tamas Szabo (itemis AG) - initial API and implementation
 */
package org.eclipse.incquery.xcore.generator;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class WellBehavingFeatureDefinitionGenerator {
  private final static String EXTENSION_POINT = "org.eclipse.incquery.runtime.base.wellbehaving.derived.features";
  
  private final static String EXTENSION_ELEMENT = "wellbehaving-derived-feature";
  
  public static IPluginExtension generateExtension(final EStructuralFeature feature, final ExtensionGenerator exGen) {
    String _name = feature.getName();
    String _plus = ("extension.derived." + _name);
    final Procedure1<IPluginExtension> _function = new Procedure1<IPluginExtension>() {
      public void apply(final IPluginExtension it) {
        final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
          public void apply(final IPluginElement it) {
            EClass _eContainingClass = feature.getEContainingClass();
            EPackage _ePackage = _eContainingClass.getEPackage();
            String _nsURI = _ePackage.getNsURI();
            exGen.contribAttribute(it, "package-nsUri", _nsURI);
            EClass _eContainingClass_1 = feature.getEContainingClass();
            String _name = _eContainingClass_1.getName();
            exGen.contribAttribute(it, "classifier-name", _name);
            String _name_1 = feature.getName();
            exGen.contribAttribute(it, "feature-name", _name_1);
          }
        };
        exGen.contribElement(it, WellBehavingFeatureDefinitionGenerator.EXTENSION_ELEMENT, _function);
      }
    };
    IPluginExtension _contribExtension = exGen.contribExtension(_plus, WellBehavingFeatureDefinitionGenerator.EXTENSION_POINT, _function);
    return _contribExtension;
  }
  
  public static ArrayList<Pair<String,String>> getRemovableExtensionIdentifiers() {
    Pair<String,String> _of = Pair.<String, String>of("", WellBehavingFeatureDefinitionGenerator.EXTENSION_POINT);
    ArrayList<Pair<String,String>> _newArrayList = CollectionLiterals.<Pair<String,String>>newArrayList(_of);
    return _newArrayList;
  }
}
