/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.AbstractObservableSet;
import org.eclipse.core.databinding.observable.set.SetDiff;
import org.eclipse.core.runtime.Assert;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionHelper;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryFilterSemantics;

public class ObservablePatternMatchSet<Match extends IPatternMatch>
extends AbstractObservableSet {
    private final Set<Match> cache = Collections.synchronizedSet(new HashSet());
    private final SetCollectionUpdate updater = new SetCollectionUpdate();
    private RuleSpecification<Match> specification;

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, null);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Match filter) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, filter);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, IncQueryEngine engine, Collection<Match> multifilters, IncQueryFilterSemantics semantics) {
        this((Matcher)querySpecification);
        ObservableCollectionHelper.prepareRuleEngine(engine, this.specification, multifilters, semantics);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, RuleEngine engine) {
        this((Matcher)querySpecification);
        engine.addRule(this.specification);
        ObservableCollectionHelper.fireActivations(engine, this.specification, this.specification.createEmptyFilter());
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Match filter) {
        this((Matcher)querySpecification);
        EventFilter matchFilter = Rules.newSingleMatchFilter(filter);
        engine.addRule(this.specification, matchFilter);
        ObservableCollectionHelper.fireActivations(engine, this.specification, matchFilter);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification, RuleEngine engine, Collection<Match> multifilters, IncQueryFilterSemantics semantics) {
        this((Matcher)querySpecification);
        EventFilter matchFilter = Rules.newMultiMatchFilter(multifilters, (IncQueryFilterSemantics)semantics);
        engine.addRule(this.specification, matchFilter);
        ObservableCollectionHelper.fireActivations(engine, this.specification, matchFilter);
    }

    protected <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(IQuerySpecification<Matcher> querySpecification) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, querySpecification);
    }

    public <Matcher extends IncQueryMatcher<Match>> ObservablePatternMatchSet(Matcher matcher) {
        this.specification = ObservableCollectionHelper.createRuleSpecification(this.updater, matcher);
        ObservableCollectionHelper.prepareRuleEngine(matcher.getEngine(), this.specification, null);
    }

    public Object getElementType() {
        return IPatternMatch.class;
    }

    protected Set<Match> getWrappedSet() {
        return this.cache;
    }

    public RuleSpecification<Match> getSpecification() {
        return this.specification;
    }

    public class SetCollectionUpdate
    implements IObservablePatternMatchCollectionUpdate<Match> {
        @Override
        public void addMatch(Match match) {
            ObservablePatternMatchSet.this.cache.add(match);
            final SetDiff diff = Diffs.createSetDiff((Set)Sets.newHashSet((Object[])new IPatternMatch[]{match}), (Set)Collections.EMPTY_SET);
            Realm realm = ObservablePatternMatchSet.this.getRealm();
            Assert.isNotNull((Object)realm, (String)"Data binding Realm must not be null");
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchSet.this.isDisposed()) {
                        ObservablePatternMatchSet.this.fireSetChange(diff);
                    }
                }
            });
        }

        @Override
        public void removeMatch(Match match) {
            ObservablePatternMatchSet.this.cache.remove(match);
            final SetDiff diff = Diffs.createSetDiff((Set)Collections.EMPTY_SET, (Set)Sets.newHashSet((Object[])new IPatternMatch[]{match}));
            Realm realm = ObservablePatternMatchSet.this.getRealm();
            Assert.isNotNull((Object)realm, (String)"Data binding Realm must not be null");
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchSet.this.isDisposed()) {
                        ObservablePatternMatchSet.this.fireSetChange(diff);
                    }
                }
            });
        }
    }
}

