/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class EcoreGenmodelRegistry {
    private static final String EPACKAGE_EXTENSION_ID = "org.eclipse.emf.ecore.generated_package";
    private static final String GENMODEL_ATTRIBUTE = "genModel";
    private static final String URI_ATTRIBUTE = "uri";
    private Map<String, String> genmodelUriMap = Maps.newHashMap();
    private Map<String, GenPackage> genpackageMap = Maps.newHashMap();
    private Logger logger;

    public EcoreGenmodelRegistry(Logger logger) {
        IConfigurationElement[] packages;
        this.logger = logger;
        if (Platform.getExtensionRegistry() == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = packages = Platform.getExtensionRegistry().getConfigurationElementsFor(EPACKAGE_EXTENSION_ID);
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String genmodelUri;
            IConfigurationElement packageExtension = iConfigurationElementArray[n2];
            if (packageExtension.isValid() && (genmodelUri = packageExtension.getAttribute(GENMODEL_ATTRIBUTE)) != null && !genmodelUri.isEmpty()) {
                String uri = packageExtension.getAttribute(URI_ATTRIBUTE);
                if (URI.createURI((String)genmodelUri).isRelative()) {
                    this.genmodelUriMap.put(uri, String.format("platform:/plugin/%s/%s", packageExtension.getContributor().getName(), genmodelUri));
                } else {
                    this.genmodelUriMap.put(uri, genmodelUri);
                }
            }
            ++n2;
        }
    }

    public GenPackage findGenPackage(String nsURI, ResourceSet set) {
        if (!this.genpackageMap.containsKey(nsURI)) {
            if (!this.genmodelUriMap.containsKey(nsURI)) {
                return null;
            }
            GenPackage genPackage = this.loadGenPackage(nsURI, this.genmodelUriMap.get(nsURI), set);
            if (genPackage != null) {
                this.genpackageMap.put(nsURI, genPackage);
            }
            return genPackage;
        }
        return this.genpackageMap.get(nsURI);
    }

    private GenPackage loadGenPackage(String nsURI, String genmodelUri, ResourceSet set) {
        try {
            URI uri = URI.createURI((String)genmodelUri);
            if (uri.isRelative()) {
                uri = URI.createPlatformPluginURI((String)genmodelUri, (boolean)true);
            }
            Resource resource = set.getResource(uri, true);
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject object = (EObject)it.next();
                if (!(object instanceof GenPackage)) continue;
                if (((GenPackage)object).getNSURI().equals(nsURI)) {
                    return (GenPackage)object;
                }
                if (!(object instanceof GenModel)) continue;
                it.prune();
            }
        }
        catch (RuntimeException ex) {
            this.logger.error((Object)("Error while retrieving genmodel of EPackage " + nsURI + " from location: " + genmodelUri), (Throwable)ex);
        }
        return null;
    }
}

