/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.types;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EClassifierConstraint;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.types.EMFPatternTypeUtil;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.ComputationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.EntityType;
import org.eclipse.incquery.patternlanguage.patternLanguage.LiteralValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.ParameterRef;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.typing.XbaseTypeProvider;

@Singleton
public class EMFPatternTypeProvider
extends XbaseTypeProvider
implements IEMFTypeProvider {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;
    private static final int RECURSION_CALLING_LEVEL_LIMIT = 5;

    protected JvmTypeReference typeForIdentifiable(JvmIdentifiableElement identifiable, boolean rawType) {
        if (identifiable instanceof Variable) {
            Variable variable = (Variable)identifiable;
            return this.getVariableType(variable);
        }
        return super.typeForIdentifiable(identifiable, rawType);
    }

    @Override
    public JvmTypeReference getVariableType(Variable variable) {
        EClassifier classifier = this.getClassifierForVariable(variable);
        JvmTypeReference typeReference = null;
        if (classifier != null) {
            typeReference = this.getTypeReferenceForVariableWithEClassifier(classifier, variable);
        }
        if (typeReference == null) {
            typeReference = this.typeReferences.getTypeForName(Object.class, (Notifier)variable, new JvmTypeReference[0]);
        }
        return typeReference;
    }

    protected JvmTypeReference getTypeReferenceForVariableWithEClassifier(EClassifier classifier, Variable variable) {
        if (classifier != null && classifier.getInstanceClass() != null) {
            JvmTypeReference typeReference = this.typeReferences.getTypeForName(classifier.getInstanceClass(), (Notifier)variable, new JvmTypeReference[0]);
            return this.primitives.asWrapperTypeIfPrimitive(typeReference);
        }
        return null;
    }

    @Override
    public EClassifier getClassifierForVariable(Variable variable) {
        EcoreUtil2.resolveAll((EObject)variable);
        EObject container = variable.eContainer();
        if (container instanceof Pattern) {
            return this.getClassifierForVariableWithPattern((Pattern)container, variable, 0);
        }
        if (container instanceof PatternBody) {
            return this.getClassifierForVariableWithPatternBody((PatternBody)container, variable, 0, null);
        }
        return null;
    }

    private Set<EClassifier> minimizeClassifiersList(Set<EClassifier> classifierList) {
        HashSet<EClassifier> resultList = new HashSet<EClassifier>(classifierList);
        if (resultList.size() > 1) {
            for (EClassifier classifier : classifierList) {
                if ("EObject".equals(classifier.getName())) {
                    resultList.remove(classifier);
                    continue;
                }
                if (!(classifier instanceof EClass)) continue;
                for (EClass eClass : ((EClass)classifier).getEAllSuperTypes()) {
                    if (!resultList.contains(eClass)) continue;
                    resultList.remove(eClass);
                }
            }
        }
        return resultList;
    }

    private EClassifier getClassifierForVariableWithPattern(Pattern pattern, Variable variable, int recursionCallingLevel) {
        HashSet<EClassifier> intermediateResultList = new HashSet<EClassifier>();
        for (PatternBody body : pattern.getBodies()) {
            EClassifier classifier = this.getClassifierForVariableWithPatternBody(body, variable, recursionCallingLevel, null);
            if (classifier == null) continue;
            intermediateResultList.add(classifier);
        }
        if (!intermediateResultList.isEmpty()) {
            if (intermediateResultList.size() == 1) {
                return (EClassifier)intermediateResultList.toArray()[0];
            }
            LinkedHashSet<EClassifier> resultSuperTypes = null;
            for (EClassifier classifier : intermediateResultList) {
                if (classifier instanceof EClass) {
                    if (resultSuperTypes == null) {
                        resultSuperTypes = new LinkedHashSet<EClassifier>();
                        resultSuperTypes.addAll((Collection<EClassifier>)((EClass)classifier).getEAllSuperTypes());
                        resultSuperTypes.add(classifier);
                        continue;
                    }
                    LinkedHashSet<EClassifier> nextSet = new LinkedHashSet<EClassifier>();
                    nextSet.addAll((Collection<EClassifier>)((EClass)classifier).getEAllSuperTypes());
                    nextSet.add(classifier);
                    resultSuperTypes.retainAll(nextSet);
                    continue;
                }
                return null;
            }
            if (!resultSuperTypes.isEmpty()) {
                Object[] result = resultSuperTypes.toArray();
                return (EClassifier)result[result.length - 1];
            }
        }
        return null;
    }

    @Override
    public Set<EClassifier> getPossibleClassifiersForVariableInBody(PatternBody patternBody, Variable variable) {
        Set<EClassifier> possibleClassifiersList = this.getClassifiersForVariableWithPatternBody(patternBody, variable, 0, null);
        if (possibleClassifiersList.size() <= 1) {
            return possibleClassifiersList;
        }
        return this.minimizeClassifiersList(possibleClassifiersList);
    }

    @Override
    public EClassifier getClassifierForPatternParameterVariable(Variable variable) {
        if (variable instanceof ParameterRef) {
            Variable referredParameter = ((ParameterRef)variable).getReferredParam();
            return this.getClassifierForType(referredParameter.getType());
        }
        return this.getClassifierForType(variable.getType());
    }

    private EClassifier getClassifierForVariableWithPatternBody(PatternBody patternBody, Variable variable, int recursionCallingLevel, Variable injectiveVariablePair) {
        Set<EClassifier> possibleClassifiersList = this.getClassifiersForVariableWithPatternBody(patternBody, variable, recursionCallingLevel, injectiveVariablePair);
        if (possibleClassifiersList.isEmpty()) {
            return null;
        }
        if (possibleClassifiersList.size() == 1) {
            return (EClassifier)possibleClassifiersList.toArray()[0];
        }
        possibleClassifiersList = this.minimizeClassifiersList(possibleClassifiersList);
        EClassifier classifier = this.getClassifierForPatternParameterVariable(variable);
        if (classifier != null && possibleClassifiersList.contains(classifier)) {
            return classifier;
        }
        return (EClassifier)possibleClassifiersList.toArray()[0];
    }

    private Set<EClassifier> getClassifiersForVariableWithPatternBody(PatternBody patternBody, Variable variable, int recursionCallingLevel, Variable injectiveVariablePair) {
        HashSet<EClassifier> possibleClassifiersList = new HashSet<EClassifier>();
        EClassifier classifier = null;
        classifier = this.getClassifierForPatternParameterVariable(variable);
        if (classifier != null) {
            possibleClassifiersList.add(classifier);
        }
        for (Constraint constraint : patternBody.getConstraints()) {
            PatternCompositionConstraint patternCompositionConstraint;
            boolean isNegative;
            if (constraint instanceof EClassifierConstraint) {
                EntityType type;
                EClassifierConstraint eClassifierConstraint = (EClassifierConstraint)constraint;
                if (!EMFPatternTypeProvider.isEqualVariables(variable, eClassifierConstraint.getVar()) || (classifier = this.getClassifierForType((Type)(type = eClassifierConstraint.getType()))) == null) continue;
                possibleClassifiersList.add(classifier);
                continue;
            }
            if (constraint instanceof PathExpressionConstraint) {
                Type type;
                VariableReference secondVariableReference;
                ValueReference valueReference;
                Type type2;
                PathExpressionHead pathExpressionHead = ((PathExpressionConstraint)constraint).getHead();
                VariableReference firstvariableReference = pathExpressionHead.getSrc();
                if (EMFPatternTypeProvider.isEqualVariables(variable, firstvariableReference) && (classifier = this.getClassifierForType(type2 = pathExpressionHead.getType())) != null) {
                    possibleClassifiersList.add(classifier);
                }
                if (!((valueReference = pathExpressionHead.getDst()) instanceof VariableValue) || !EMFPatternTypeProvider.isEqualVariables(variable, secondVariableReference = ((VariableValue)valueReference).getValue()) || (classifier = this.getClassifierForType(type = EMFPatternTypeUtil.getTypeFromPathExpressionTail(pathExpressionHead.getTail()))) == null) continue;
                possibleClassifiersList.add(classifier);
                continue;
            }
            if (constraint instanceof CompareConstraint) {
                VariableValue rightVariableValue;
                VariableValue leftVariableValue;
                CompareConstraint compareConstraint = (CompareConstraint)constraint;
                if (!CompareFeature.EQUALITY.equals((Object)compareConstraint.getFeature())) continue;
                ValueReference leftValueReference = compareConstraint.getLeftOperand();
                ValueReference rightValueReference = compareConstraint.getRightOperand();
                if (leftValueReference instanceof VariableValue && EMFPatternTypeProvider.isEqualVariables(variable, (leftVariableValue = (VariableValue)leftValueReference).getValue()) && (classifier = this.getClassifierForValueReference(rightValueReference, patternBody, variable, recursionCallingLevel, injectiveVariablePair)) != null) {
                    possibleClassifiersList.add(classifier);
                }
                if (!(rightValueReference instanceof VariableValue) || !EMFPatternTypeProvider.isEqualVariables(variable, (rightVariableValue = (VariableValue)rightValueReference).getValue()) || (classifier = this.getClassifierForValueReference(leftValueReference, patternBody, variable, recursionCallingLevel, injectiveVariablePair)) == null) continue;
                possibleClassifiersList.add(classifier);
                continue;
            }
            if (!(constraint instanceof PatternCompositionConstraint) || recursionCallingLevel >= 5 || (isNegative = (patternCompositionConstraint = (PatternCompositionConstraint)constraint).isNegative())) continue;
            PatternCall patternCall = patternCompositionConstraint.getCall();
            int parameterIndex = 0;
            for (ValueReference valueReference : patternCall.getParameters()) {
                Variable variableInCalledPattern;
                EClassifier variableClassifier;
                Pattern pattern;
                EList parameters;
                VariableValue variableValue;
                VariableReference variableReference;
                if (valueReference instanceof VariableValue && EMFPatternTypeProvider.isEqualVariables(variable, variableReference = (variableValue = (VariableValue)valueReference).getValue()) && (parameters = (pattern = patternCall.getPatternRef()).getParameters()).size() > parameterIndex && (variableClassifier = this.getClassifierForVariableWithPattern(pattern, variableInCalledPattern = (Variable)parameters.get(parameterIndex), recursionCallingLevel + 1)) != null) {
                    possibleClassifiersList.add(variableClassifier);
                }
                ++parameterIndex;
            }
        }
        return possibleClassifiersList;
    }

    private EClassifier getClassifierForValueReference(ValueReference valueReference, PatternBody patternBody, Variable variable, int recursionCallingLevel, Variable injectiveVariablePair) {
        VariableValue variableValue;
        Variable newPossibleInjectPair;
        if (valueReference instanceof LiteralValueReference || valueReference instanceof ComputationValue || valueReference instanceof EnumValue) {
            return EMFPatternTypeUtil.getClassifierForLiteralComputationEnumValueReference(valueReference);
        }
        if (valueReference instanceof VariableValue && !(newPossibleInjectPair = (variableValue = (VariableValue)valueReference).getValue().getVariable()).equals(injectiveVariablePair)) {
            return this.getClassifierForVariableWithPatternBody(patternBody, newPossibleInjectPair, recursionCallingLevel, variable);
        }
        return null;
    }

    @Override
    public EClassifier getClassifierForType(Type type) {
        return EMFPatternTypeUtil.getClassifierForType(type);
    }

    private static boolean isEqualVariables(Variable variable, VariableReference variableReference) {
        Variable variableReferenceVariable;
        return variable != null && variableReference != null && (Objects.equal((Object)variable, (Object)(variableReferenceVariable = variableReference.getVariable())) || Objects.equal((Object)variable.getName(), (Object)variableReferenceVariable.getName()));
    }
}

