/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.validation;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.EMFPatternLanguageScopeHelper;
import org.eclipse.incquery.patternlanguage.emf.ResolutionException;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EnumValue;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ReferenceType;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.emf.scoping.IMetamodelProvider;
import org.eclipse.incquery.patternlanguage.emf.types.EMFPatternTypeUtil;
import org.eclipse.incquery.patternlanguage.emf.types.IEMFTypeProvider;
import org.eclipse.incquery.patternlanguage.emf.validation.AbstractEMFPatternLanguageJavaValidator;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.ComputationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.LiteralValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionHead;
import org.eclipse.incquery.patternlanguage.patternLanguage.PathExpressionTail;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.patternlanguage.validation.UnionFindForVariables;
import org.eclipse.incquery.runtime.base.comprehension.EMFModelComprehension;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;

public class EMFPatternLanguageJavaValidator
extends AbstractEMFPatternLanguageJavaValidator {
    @Inject
    private IMetamodelProvider metamodelProvider;
    @Inject
    private IEMFTypeProvider emfTypeProvider;
    @Inject
    private IJvmModelAssociations associations;

    @Override
    protected List<EPackage> getEPackages() {
        List<EPackage> result = super.getEPackages();
        result.add((EPackage)PatternLanguagePackage.eINSTANCE);
        return result;
    }

    @Check
    public void checkDuplicatePackageImports(PatternModel patternModel) {
        List<PackageImport> importPackages = EMFPatternLanguageHelper.getAllPackageImports(patternModel);
        int i = 0;
        while (i < importPackages.size()) {
            EPackage leftPackage = importPackages.get(i).getEPackage();
            int j = i + 1;
            while (j < importPackages.size()) {
                EPackage rightPackage = importPackages.get(j).getEPackage();
                if (leftPackage.equals(rightPackage)) {
                    this.warning("Duplicate import of " + leftPackage.getNsURI(), (EStructuralFeature)EMFPatternLanguagePackage.Literals.PATTERN_MODEL__IMPORT_PACKAGES, i, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.duplicate_import", new String[0]);
                    this.warning("Duplicate import of " + rightPackage.getNsURI(), (EStructuralFeature)EMFPatternLanguagePackage.Literals.PATTERN_MODEL__IMPORT_PACKAGES, j, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.duplicate_import", new String[0]);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkPackageImportGeneratedCode(PackageImport packageImport) {
        if (packageImport.getEPackage() != null && packageImport.getEPackage().getNsURI() != null && !this.metamodelProvider.isGeneratedCodeAvailable(packageImport.getEPackage(), packageImport.eResource().getResourceSet())) {
            this.warning(String.format("The generated code of the Ecore model %s cannot be found. Check the org.eclipse.emf.ecore.generated_package extension in the model project or consider setting up a generator model for the generated code to work.", packageImport.getEPackage().getNsURI()), (EStructuralFeature)EMFPatternLanguagePackage.Literals.PACKAGE_IMPORT__EPACKAGE, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_imported_code", new String[0]);
        }
    }

    @Check
    public void checkParametersNamed(Pattern pattern) {
        for (Variable var : pattern.getParameters()) {
            if (!var.getName().startsWith("_")) continue;
            this.error("Parameter name must not start with _", (EObject)var, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__NAME, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.singleuse_parameter", new String[0]);
        }
    }

    @Check
    public void checkEnumValues(EnumValue value) {
        if (value.eContainer() instanceof PathExpressionHead) {
            EEnum enumType = value.getEnumeration();
            if (enumType == null && value.getLiteral() != null) {
                enumType = value.getLiteral().getEEnum();
            }
            PathExpressionHead expression = (PathExpressionHead)value.eContainer();
            try {
                EEnum expectedType = EMFPatternLanguageScopeHelper.calculateEnumerationType(expression);
                if (enumType != null && !expectedType.equals(enumType)) {
                    this.error(String.format("Inconsistent enumeration types: found %s but expected %s", enumType.getName(), expectedType.getName()), (EObject)value, (EStructuralFeature)EMFPatternLanguagePackage.Literals.ENUM_VALUE__ENUMERATION, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.invalid_enum", new String[0]);
                }
            }
            catch (ResolutionException resolutionException) {
                this.error(String.format("Invalid enumeration constant %s", enumType.getName()), (EObject)value, (EStructuralFeature)EMFPatternLanguagePackage.Literals.ENUM_VALUE__ENUMERATION, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.invalid_enum", new String[0]);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkPatternParametersType(Pattern pattern) {
        for (Variable variable : pattern.getParameters()) {
            EClassifier classifierCorrect = this.emfTypeProvider.getClassifierForVariable(variable);
            EClassifier classifierDefined = this.emfTypeProvider.getClassifierForType(variable.getType());
            if (classifierCorrect == null || classifierDefined == null || classifierDefined.equals(classifierCorrect)) {
                return;
            }
            if (classifierCorrect instanceof EClass && classifierDefined instanceof EClass && ((EClass)classifierDefined).getEAllSuperTypes().contains((Object)classifierCorrect)) {
                return;
            }
            this.warning(String.format("Inconsistent parameter type definition, should be %s based on the pattern definition", classifierCorrect.getName()), (EObject)variable, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.parameter_type_invalid", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkPatternVariablesType(Pattern pattern) {
        for (PatternBody patternBody : pattern.getBodies()) {
            for (Variable variable : patternBody.getVariables()) {
                EClassifier classifier2;
                Set<EClassifier> possibleClassifiers = this.emfTypeProvider.getPossibleClassifiersForVariableInBody(patternBody, variable);
                if (possibleClassifiers.size() <= 1) continue;
                HashSet<String> classifierNamesSet = new HashSet<String>();
                HashSet<String> classifierPackagesSet = new HashSet<String>();
                for (EClassifier classifier2 : possibleClassifiers) {
                    classifierNamesSet.add(classifier2.getName());
                    if (classifier2.getEPackage() == null) continue;
                    classifierPackagesSet.add(classifier2.getEPackage().getName());
                }
                if (classifierNamesSet.size() == 1 && classifierPackagesSet.size() <= 1) {
                    this.error("Variable has a type which has multiple definitions: " + classifierNamesSet, (EObject)variable.getReferences().get(0), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.variable_type_multiple_declaration", new String[0]);
                    continue;
                }
                classifier2 = this.emfTypeProvider.getClassifierForPatternParameterVariable(variable);
                PatternModel patternModel = (PatternModel)patternBody.eContainer().eContainer();
                if (classifier2 != null && possibleClassifiers.contains(classifier2) && this.hasCommonSubType(patternModel, possibleClassifiers)) {
                    this.warning("Ambiguous variable type defintions: " + classifierNamesSet + ", the parameter type (" + classifier2.getName() + ") is used now.", (EObject)variable.getReferences().get(0), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.variable_type_invalid_warning", new String[0]);
                    continue;
                }
                boolean isParameter = false;
                for (Variable parameter : pattern.getParameters()) {
                    if (!parameter.getName().equals(variable.getName())) continue;
                    isParameter = true;
                }
                if (isParameter) {
                    this.error("Ambiguous variable type defintions: " + classifierNamesSet + ", type cannot be selected. Please specify the one to be used as the parameter type" + " by adding it to the parameter definition.", (EObject)variable.getReferences().get(0), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.variable_type_invalid_error", new String[0]);
                    continue;
                }
                this.error("Inconsistent variable type defintions: " + classifierNamesSet + ", type cannot be selected.", (EObject)variable.getReferences().get(0), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.variable_type_invalid_error", new String[0]);
            }
        }
    }

    private boolean hasCommonSubType(PatternModel patternModel, Set<EClassifier> classifiers) {
        HashSet<EClass> realSubTypes = new HashSet<EClass>();
        HashSet<EClassifier> probableSubTypes = new HashSet<EClassifier>();
        for (PackageImport packageImport : EMFPatternLanguageHelper.getPackageImportsIterable(patternModel)) {
            probableSubTypes.addAll(EMFPatternLanguageJavaValidator.getAllEClassifiers(packageImport.getEPackage()));
        }
        for (EClassifier classifier : probableSubTypes) {
            EClass eClass;
            if (!(classifier instanceof EClass) || !(eClass = (EClass)classifier).getEAllSuperTypes().containsAll(classifiers)) continue;
            realSubTypes.add(eClass);
        }
        return !realSubTypes.isEmpty();
    }

    private static Set<EClassifier> getAllEClassifiers(EPackage ePackage) {
        HashSet<EClassifier> resultSet = new HashSet<EClassifier>();
        resultSet.addAll((Collection<EClassifier>)ePackage.getEClassifiers());
        for (EPackage subEPackage : ePackage.getESubpackages()) {
            resultSet.addAll((Collection<EClassifier>)subEPackage.getEClassifiers());
        }
        return resultSet;
    }

    @Check(value=CheckType.NORMAL)
    public void checkForCartesianProduct(PatternBody patternBody) {
        ValueReference valueReference;
        HashSet<Variable> positiveVariables;
        EList variables = patternBody.getVariables();
        variables.removeAll(CorePatternLanguageHelper.getUnnamedRunningVariables((PatternBody)patternBody));
        UnionFindForVariables justPositiveUnionFindForVariables = new UnionFindForVariables((List)variables);
        UnionFindForVariables generalUnionFindForVariables = new UnionFindForVariables((List)variables);
        boolean isSecondRunNeeded = false;
        for (Constraint constraint : patternBody.getConstraints()) {
            positiveVariables = new HashSet<Variable>();
            HashSet<Variable> generalVariables = new HashSet<Variable>();
            if (constraint instanceof CompareConstraint) {
                CompareConstraint compareConstraint = (CompareConstraint)constraint;
                ValueReference leftValueReference = compareConstraint.getLeftOperand();
                ValueReference rightValueReference = compareConstraint.getRightOperand();
                Set leftVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)leftValueReference);
                Set rightVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)rightValueReference);
                if (CompareFeature.EQUALITY.equals((Object)compareConstraint.getFeature())) {
                    if (!EMFPatternLanguageJavaValidator.isValueReferenceComputed(leftValueReference) && !EMFPatternLanguageJavaValidator.isValueReferenceComputed(rightValueReference)) {
                        positiveVariables.addAll(leftVariables);
                        positiveVariables.addAll(rightVariables);
                        generalVariables.addAll(leftVariables);
                        generalVariables.addAll(rightVariables);
                    } else {
                        isSecondRunNeeded = true;
                        generalVariables.addAll(leftVariables);
                        generalVariables.addAll(rightVariables);
                    }
                } else if (CompareFeature.INEQUALITY.equals((Object)compareConstraint.getFeature())) {
                    generalVariables.addAll(leftVariables);
                    generalVariables.addAll(rightVariables);
                }
            } else if (constraint instanceof PatternCompositionConstraint) {
                PatternCompositionConstraint patternCompositionConstraint = (PatternCompositionConstraint)constraint;
                if (!patternCompositionConstraint.isNegative()) {
                    for (ValueReference valueReference2 : patternCompositionConstraint.getCall().getParameters()) {
                        if (!EMFPatternLanguageJavaValidator.isValueReferenceComputed(valueReference2)) {
                            positiveVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference2));
                            generalVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference2));
                            continue;
                        }
                        isSecondRunNeeded = true;
                        generalVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference2));
                    }
                } else {
                    for (ValueReference valueReference2 : patternCompositionConstraint.getCall().getParameters()) {
                        generalVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference2));
                    }
                }
            } else if (constraint instanceof PathExpressionConstraint) {
                PathExpressionConstraint pathExpressionConstraint = (PathExpressionConstraint)constraint;
                PathExpressionHead pathExpressionHead = pathExpressionConstraint.getHead();
                valueReference = pathExpressionHead.getDst();
                Variable pathExpressionHeadSourceVariable = null;
                if (pathExpressionHead.getSrc() != null) {
                    pathExpressionHeadSourceVariable = pathExpressionHead.getSrc().getVariable();
                }
                if (!EMFPatternLanguageJavaValidator.isValueReferenceComputed(valueReference)) {
                    positiveVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference));
                    positiveVariables.add(pathExpressionHeadSourceVariable);
                    generalVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference));
                    generalVariables.add(pathExpressionHeadSourceVariable);
                } else {
                    isSecondRunNeeded = true;
                    generalVariables.addAll(CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference));
                    generalVariables.add(pathExpressionHeadSourceVariable);
                }
            } else if (constraint instanceof CheckConstraint) {
                CheckConstraint checkConstraint = (CheckConstraint)constraint;
                generalVariables.addAll(CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression((XExpression)checkConstraint.getExpression(), (IJvmModelAssociations)this.associations));
            }
            justPositiveUnionFindForVariables.unite(positiveVariables);
            generalUnionFindForVariables.unite(generalVariables);
        }
        if (isSecondRunNeeded) {
            for (Constraint constraint : patternBody.getConstraints()) {
                positiveVariables = new HashSet();
                if (constraint instanceof CompareConstraint) {
                    CompareConstraint compareConstraint = (CompareConstraint)constraint;
                    if (CompareFeature.EQUALITY.equals((Object)compareConstraint.getFeature())) {
                        ValueReference leftValueReference = compareConstraint.getLeftOperand();
                        ValueReference rightValueReference = compareConstraint.getRightOperand();
                        if (EMFPatternLanguageJavaValidator.isValueReferenceComputed(leftValueReference) || EMFPatternLanguageJavaValidator.isValueReferenceComputed(rightValueReference)) {
                            Set leftVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)leftValueReference);
                            Set rightVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)rightValueReference);
                            if (justPositiveUnionFindForVariables.isSameUnion(leftVariables)) {
                                positiveVariables.addAll(leftVariables);
                            }
                            if (justPositiveUnionFindForVariables.isSameUnion(rightVariables)) {
                                positiveVariables.addAll(rightVariables);
                            }
                        }
                    }
                } else if (constraint instanceof PatternCompositionConstraint) {
                    PatternCompositionConstraint patternCompositionConstraint = (PatternCompositionConstraint)constraint;
                    if (!patternCompositionConstraint.isNegative()) {
                        for (ValueReference valueReference3 : patternCompositionConstraint.getCall().getParameters()) {
                            Set actualVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference3);
                            if (!justPositiveUnionFindForVariables.isSameUnion(actualVariables)) continue;
                            positiveVariables.addAll(actualVariables);
                        }
                    }
                } else if (constraint instanceof PathExpressionConstraint) {
                    PathExpressionConstraint pathExpressionConstraint = (PathExpressionConstraint)constraint;
                    PathExpressionHead pathExpressionHead = pathExpressionConstraint.getHead();
                    Variable pathExpressionHeadSourceVariable = null;
                    if (pathExpressionHead.getSrc() != null) {
                        pathExpressionHeadSourceVariable = pathExpressionHead.getSrc().getVariable();
                    }
                    positiveVariables.add(pathExpressionHeadSourceVariable);
                    valueReference = pathExpressionHead.getDst();
                    Set actualVariables = CorePatternLanguageHelper.getVariablesFromValueReference((ValueReference)valueReference);
                    if (justPositiveUnionFindForVariables.isSameUnion(actualVariables)) {
                        positiveVariables.addAll(actualVariables);
                    }
                }
                justPositiveUnionFindForVariables.unite(positiveVariables);
            }
        }
        for (Constraint constraint : patternBody.getConstraints()) {
            Variable variableToRemove;
            VariableValue variableValue;
            CompareConstraint compareConstraint;
            if (!(constraint instanceof CompareConstraint) || !CompareFeature.EQUALITY.equals((Object)(compareConstraint = (CompareConstraint)constraint).getFeature())) continue;
            ValueReference leftValueReference = compareConstraint.getLeftOperand();
            ValueReference rightValueReference = compareConstraint.getRightOperand();
            if ((leftValueReference instanceof LiteralValueReference || leftValueReference instanceof EnumValue) && rightValueReference instanceof VariableValue) {
                variableValue = (VariableValue)rightValueReference;
                variableToRemove = variableValue.getValue().getVariable();
                generalUnionFindForVariables.removeVariable(variableToRemove);
                justPositiveUnionFindForVariables.removeVariable(variableToRemove);
                continue;
            }
            if (!(leftValueReference instanceof VariableValue) || !(rightValueReference instanceof LiteralValueReference) && !(rightValueReference instanceof EnumValue)) continue;
            variableValue = (VariableValue)leftValueReference;
            variableToRemove = variableValue.getValue().getVariable();
            generalUnionFindForVariables.removeVariable(variableToRemove);
            justPositiveUnionFindForVariables.removeVariable(variableToRemove);
        }
        if (generalUnionFindForVariables.isMoreThanOneUnion()) {
            this.warning("The pattern body contains isolated constraints (\"cartesian products\") that can lead to severe performance and memory footprint issues. The independent partitions are: " + generalUnionFindForVariables.getCurrentPartitionsFormatted() + ".", (EObject)patternBody, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.cartesian_strict_warning", new String[0]);
        } else if (justPositiveUnionFindForVariables.isMoreThanOneUnion()) {
            this.warning("The pattern body contains constraints which are only loosely connected. This may negatively impact performance. The weakly dependent partitions are: " + justPositiveUnionFindForVariables.getCurrentPartitionsFormatted(), (EObject)patternBody, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.cartesian_soft_warning", new String[0]);
        }
    }

    private static boolean isValueReferenceAggregated(ValueReference valueReference) {
        return valueReference instanceof AggregatedValue;
    }

    private static boolean isValueReferenceComputed(ValueReference valueReference) {
        return valueReference instanceof ComputationValue;
    }

    @Check
    public void checkForWrongLiteralAndComputationValuesInCompareConstraints(CompareConstraint compareConstraint) {
        EClassifier rightClassifier;
        EClassifier leftClassifier;
        ValueReference leftValueReference = compareConstraint.getLeftOperand();
        ValueReference rightValueReference = compareConstraint.getRightOperand();
        if ((leftValueReference instanceof LiteralValueReference || leftValueReference instanceof ComputationValue || rightValueReference instanceof LiteralValueReference || rightValueReference instanceof ComputationValue) && !(leftValueReference instanceof VariableValue) && !(rightValueReference instanceof VariableValue) && !EMFPatternLanguageJavaValidator.isCompatibleClassifiers(leftClassifier = EMFPatternTypeUtil.getClassifierForLiteralComputationEnumValueReference(leftValueReference), rightClassifier = EMFPatternTypeUtil.getClassifierForLiteralComputationEnumValueReference(rightValueReference))) {
            this.error("The types of the literal/computational values are different: " + leftClassifier.getInstanceClassName() + ", " + rightClassifier.getInstanceClassName() + ".", (EObject)compareConstraint, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.literal_and_computation_type_mismatch_in_compare", new String[0]);
        }
    }

    @Check
    public void checkForWrongLiteralAndComputationValuesInPathExpressionConstraints(PathExpressionConstraint pathExpressionConstraint) {
        PathExpressionHead pathExpressionHead = pathExpressionConstraint.getHead();
        ValueReference valueReference = pathExpressionHead.getDst();
        if (valueReference instanceof LiteralValueReference || valueReference instanceof ComputationValue) {
            EClassifier inputClassifier = EMFPatternTypeUtil.getClassifierForLiteralComputationEnumValueReference(valueReference);
            EClassifier typeClassifier = EMFPatternTypeUtil.getClassifierForType(EMFPatternTypeUtil.getTypeFromPathExpressionTail(pathExpressionHead.getTail()));
            if (!EMFPatternLanguageJavaValidator.isCompatibleClassifiers(typeClassifier, inputClassifier)) {
                String name = typeClassifier == null ? "<unknown>" : typeClassifier.getInstanceClassName();
                this.error("The type infered from the path expression (" + name + ") is different from the input literal/computational value (" + inputClassifier.getInstanceClassName() + ").", (EObject)pathExpressionConstraint, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.literal_or_computation_type_mismatch_in_path_expression", new String[0]);
            }
        }
    }

    @Check
    public void checkForWrongLiteralAndComputationValuesInPatternCalls(PatternCall patternCall) {
        if (patternCall.getParameters().size() != patternCall.getPatternRef().getParameters().size()) {
            return;
        }
        for (ValueReference valueReference : patternCall.getParameters()) {
            EClassifier inputClassifier;
            Pattern pattern;
            Variable variable;
            EClassifier typeClassifier;
            if (!(valueReference instanceof LiteralValueReference) && !(valueReference instanceof ComputationValue) || EMFPatternLanguageJavaValidator.isCompatibleClassifiers(typeClassifier = this.emfTypeProvider.getClassifierForVariable(variable = (Variable)(pattern = patternCall.getPatternRef()).getParameters().get(patternCall.getParameters().indexOf((Object)valueReference))), inputClassifier = EMFPatternTypeUtil.getClassifierForLiteralComputationEnumValueReference(valueReference))) continue;
            this.error("The type infered from the called pattern (" + typeClassifier.getInstanceClassName() + ") is different from the input literal/computational value (" + inputClassifier.getInstanceClassName() + ").", (EObject)patternCall, null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.literal_or_computation_type_mismatch_in_pattern_call", new String[0]);
        }
    }

    private static boolean isCompatibleClassifiers(EClassifier classifierFirst, EClassifier classifierSecond) {
        if (classifierFirst != null && classifierSecond != null) {
            Class<?> secondWrapperClass;
            Class<?> firstWrapperClass;
            Class secondInstanceClass;
            Class firstInstanceClass = classifierFirst.getInstanceClass();
            if (firstInstanceClass.equals(secondInstanceClass = classifierSecond.getInstanceClass())) {
                return true;
            }
            if ((firstInstanceClass.isPrimitive() || secondInstanceClass.isPrimitive()) && (firstWrapperClass = EMFPatternLanguageJavaValidator.getWrapperClassForType(firstInstanceClass)).equals(secondWrapperClass = EMFPatternLanguageJavaValidator.getWrapperClassForType(secondInstanceClass))) {
                return true;
            }
        }
        return false;
    }

    private static Class<?> getWrapperClassForType(Class<?> typeClass) {
        if (typeClass != null && typeClass.isPrimitive()) {
            if (typeClass == Boolean.TYPE) {
                return Boolean.class;
            }
            if (typeClass == Byte.TYPE) {
                return Byte.class;
            }
            if (typeClass == Character.TYPE) {
                return Character.class;
            }
            if (typeClass == Double.TYPE) {
                return Double.class;
            }
            if (typeClass == Float.TYPE) {
                return Float.class;
            }
            if (typeClass == Integer.TYPE) {
                return Integer.class;
            }
            if (typeClass == Long.TYPE) {
                return Long.class;
            }
            if (typeClass == Short.TYPE) {
                return Short.class;
            }
        }
        return typeClass;
    }

    @Check
    public void checkForWrongVariablesInXExpressions(CheckConstraint checkConstraint) {
        this.checkForWrongVariablesInXExpressionsInternal(checkConstraint.getExpression());
    }

    @Check
    public void checkForWrongVariablesInXExpressions(FunctionEvaluationValue eval) {
        this.checkForWrongVariablesInXExpressionsInternal(eval.getExpression());
    }

    private void checkForWrongVariablesInXExpressionsInternal(XExpression expression) {
        for (Variable variable : CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression((XExpression)expression, (IJvmModelAssociations)this.associations)) {
            EClassifier classifier = this.emfTypeProvider.getClassifierForVariable(variable);
            if (classifier == null || classifier instanceof EDataType) continue;
            this.error("Only simple EDataTypes are allowed in check() and eval() expressions. The variable " + variable.getName() + " has a type of " + classifier.getName() + ".", expression.eContainer(), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.check_constraint_scalar_variable_error", new String[0]);
        }
    }

    @Check
    public void checkForNotWellbehavingDerivedFeatureInPathExpressions(PathExpressionConstraint pathExpressionConstraint) {
        PathExpressionHead pathExpressionHead = pathExpressionConstraint.getHead();
        Map<PathExpressionTail, EStructuralFeature> tailFeatureMap = EMFPatternTypeUtil.getAllFeaturesFromPathExpressionTail(pathExpressionHead.getTail());
        for (Map.Entry<PathExpressionTail, EStructuralFeature> tail : tailFeatureMap.entrySet()) {
            EStructuralFeature feature = tail.getValue();
            if (EMFModelComprehension.representable((EStructuralFeature)feature)) continue;
            this.warning("The derived/volatile feature " + feature.getName() + " of class " + feature.getEContainingClass().getName() + " used in the path expression is not representable in EMF-IncQuery." + " For details, consult the documentation on well-behaving features.", (EObject)tail.getKey().getType(), null, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.feature_not_representable", new String[0]);
        }
    }

    @Check
    public void checkReferredPackages(ReferenceType type) {
        PatternModel model;
        EClass referredType = type.getRefname().getEContainingClass();
        EPackage referredPackage = referredType.getEPackage();
        String nsUri = Strings.emptyIfNull((String)referredPackage.getNsURI());
        EObject rootContainer = EcoreUtil2.getRootContainer((EObject)type);
        if (rootContainer instanceof PatternModel && (model = (PatternModel)rootContainer).getImportPackages() != null && !Iterables.any(model.getImportPackages().getPackageImport(), (Predicate)new SamePackageUri(nsUri))) {
            this.error(String.format("Reference to an EClass %s that is not imported from EPackage %s.", referredType.getName(), nsUri), (EObject)type, (EStructuralFeature)EMFPatternLanguagePackage.Literals.REFERENCE_TYPE__REFNAME, "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.missing_import", new String[]{nsUri});
        }
    }

    private static final class SamePackageUri
    implements Predicate<PackageImport> {
        private final String nsUri;

        private SamePackageUri(String nsUri) {
            this.nsUri = nsUri;
        }

        public boolean apply(PackageImport importDecl) {
            return this.nsUri.equals(importDecl.getEPackage().getNsURI());
        }
    }
}

