/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.emf.validation;

import com.google.inject.Inject;
import org.antlr.runtime.MismatchedTokenException;
import org.eclipse.incquery.patternlanguage.emf.services.EMFPatternLanguageGrammarAccess;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.antlr.ISyntaxErrorMessageProvider;
import org.eclipse.xtext.parser.antlr.SyntaxErrorMessageProvider;

public class EMFPatternLanguageSyntaxErrorMessageProvider
extends SyntaxErrorMessageProvider {
    private static final String RULE_PREFIX = "RULE_";
    @Inject
    EMFPatternLanguageGrammarAccess grammar;

    public SyntaxErrorMessage getSyntaxErrorMessage(ISyntaxErrorMessageProvider.IParserErrorContext context) {
        if (context.getRecognitionException() instanceof MismatchedTokenException) {
            MismatchedTokenException exception = (MismatchedTokenException)context.getRecognitionException();
            if (exception.expecting >= 0 && exception.getUnexpectedType() >= 0) {
                String expectingTokenTypeName = context.getTokenNames()[exception.expecting];
                String unexpectedTokenTypeName = context.getTokenNames()[exception.getUnexpectedType()];
                if ("RULE_ID".equals(expectingTokenTypeName)) {
                    if (!unexpectedTokenTypeName.startsWith(RULE_PREFIX) && Character.isJavaIdentifierStart(unexpectedTokenTypeName.replace("'", "").charAt(0))) {
                        return new SyntaxErrorMessage("Keywords of the query language are to be prefixed with the ^ character when used as an identifier", "org.eclipse.incquery.patternlanguage.emf.validation.IssueCodes.identifier_as_keyword");
                    }
                    if (unexpectedTokenTypeName.startsWith(RULE_PREFIX)) {
                        return new SyntaxErrorMessage(String.format("Mismatched input: %s '%s' found instead of the expected identifier", unexpectedTokenTypeName.substring(RULE_PREFIX.length()).toLowerCase(), exception.token.getText()), "org.eclipse.xtext.diagnostics.Diagnostic.Syntax");
                    }
                }
            }
        }
        return super.getSyntaxErrorMessage(context);
    }
}

