/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction;

import org.eclipse.incquery.runtime.rete.boundary.ReteBoundary;
import org.eclipse.incquery.runtime.rete.construction.Buildable;
import org.eclipse.incquery.runtime.rete.construction.NodeToPatternTraceInfo;
import org.eclipse.incquery.runtime.rete.construction.NodeToStubTraceInfo;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.eval.CachedFunctionEvaluatorNode;
import org.eclipse.incquery.runtime.rete.eval.PredicateEvaluatorNode;
import org.eclipse.incquery.runtime.rete.index.ExistenceNode;
import org.eclipse.incquery.runtime.rete.index.Indexer;
import org.eclipse.incquery.runtime.rete.index.JoinNode;
import org.eclipse.incquery.runtime.rete.index.ProjectionIndexer;
import org.eclipse.incquery.runtime.rete.matcher.IPatternMatcherContext;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.Library;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.network.StandardNode;
import org.eclipse.incquery.runtime.rete.network.Supplier;
import org.eclipse.incquery.runtime.rete.remote.Address;
import org.eclipse.incquery.runtime.rete.single.EqualityFilterNode;
import org.eclipse.incquery.runtime.rete.single.InequalityFilterNode;
import org.eclipse.incquery.runtime.rete.single.TransitiveClosureNode;
import org.eclipse.incquery.runtime.rete.single.TrimmerNode;
import org.eclipse.incquery.runtime.rete.single.ValueBinderFilterNode;
import org.eclipse.incquery.runtime.rete.tuple.FlatTuple;
import org.eclipse.incquery.runtime.rete.tuple.LeftInheritanceTuple;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.tuple.TupleMask;

public class ReteContainerBuildable<PatternDescription>
implements Buildable<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>>,
Cloneable {
    protected Library library;
    protected ReteContainer targetContainer;
    protected Network reteNet;
    protected ReteBoundary<PatternDescription> boundary;
    protected ReteEngine<PatternDescription> engine;
    protected boolean headAttached = false;
    protected PatternDescription pattern = null;
    protected IPatternMatcherContext<PatternDescription> context = null;

    public ReteContainerBuildable(ReteEngine<PatternDescription> engine, ReteContainer targetContainer) {
        this.engine = engine;
        this.reteNet = engine.getReteNet();
        this.boundary = engine.getBoundary();
        this.targetContainer = targetContainer;
        this.library = targetContainer.getLibrary();
        this.headAttached = false;
    }

    public ReteContainerBuildable(ReteEngine<PatternDescription> engine) {
        this.engine = engine;
        this.reteNet = engine.getReteNet();
        this.boundary = engine.getBoundary();
        this.targetContainer = this.reteNet.getHeadContainer();
        this.library = this.targetContainer.getLibrary();
        this.headAttached = true;
    }

    @Override
    public void reinitialize() {
        this.reteNet = this.engine.getReteNet();
        this.boundary = this.engine.getBoundary();
        this.targetContainer = this.headAttached ? this.reteNet.getHeadContainer() : this.reteNet.getNextContainer();
        this.library = this.targetContainer.getLibrary();
    }

    @Override
    public void patternFinished(PatternDescription pattern, IPatternMatcherContext<PatternDescription> context, Address<? extends Receiver> collector) {
        NodeToPatternTraceInfo<PatternDescription> traceInfo = new NodeToPatternTraceInfo<PatternDescription>(pattern, context);
        collector.getContainer().resolveLocal(collector).assignTraceInfo(traceInfo);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildTrimmer(Stub<Address<? extends Supplier>> stub, TupleMask trimMask, boolean enforceUniqueness) {
        Address<TrimmerNode> trimmer = this.library.accessTrimmerNode(stub.getHandle(), trimMask);
        Tuple trimmedVariables = trimMask.transform(stub.getVariablesTuple());
        Address<StandardNode> resultNode = enforceUniqueness ? this.library.accessUniquenessEnforcerNode(trimmer, trimmedVariables.getSize()) : trimmer;
        return this.trace(new Stub<Address<? extends Supplier>>(stub, trimmedVariables, resultNode));
    }

    @Override
    public void buildConnection(Stub<Address<? extends Supplier>> stub, Address<? extends Receiver> collector) {
        this.reteNet.connectRemoteNodes(stub.getHandle(), collector, true);
        this.boundary.registerParentStubForReceiver(collector, stub);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildStartStub(Object[] constantValues, Object[] constantNames) {
        return this.trace(new Stub<Address<? extends Supplier>>(new FlatTuple(constantNames), this.library.accessConstantNode(this.boundary.wrapTuple(new FlatTuple(constantValues)))));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildEqualityChecker(Stub<Address<? extends Supplier>> stub, int[] indices) {
        Address<EqualityFilterNode> checker = this.library.accessEqualityFilterNode(stub.getHandle(), indices);
        return this.trace(new Stub<Address<? extends Supplier>>(stub, checker));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildInjectivityChecker(Stub<Address<? extends Supplier>> stub, int subject, int[] inequalIndices) {
        Address<InequalityFilterNode> checker = this.library.accessInequalityFilterNode(stub.getHandle(), subject, new TupleMask(inequalIndices, stub.getVariablesTuple().getSize()));
        return this.trace(new Stub<Address<? extends Supplier>>(stub, checker));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildTransitiveClosure(Stub<Address<? extends Supplier>> stub) {
        Address<TransitiveClosureNode> checker = this.library.accessTransitiveClosureNode(stub.getHandle());
        return this.trace(new Stub<Address<? extends Supplier>>(stub, checker));
    }

    @Override
    public Stub<Address<? extends Supplier>> patternCallStub(Tuple nodes, PatternDescription supplierKey) throws RetePatternBuildException {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessProduction(supplierKey)));
    }

    @Override
    public Stub<Address<? extends Supplier>> instantiationTransitiveStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessInstantiationTransitiveRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> instantiationDirectStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessInstantiationRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> generalizationTransitiveStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessGeneralizationTransitiveRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> generalizationDirectStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessGeneralizationRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> containmentTransitiveStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessContainmentTransitiveRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> containmentDirectStub(Tuple nodes) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessContainmentRoot()));
    }

    @Override
    public Stub<Address<? extends Supplier>> binaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessBinaryEdgeRoot(supplierKey)));
    }

    @Override
    public Stub<Address<? extends Supplier>> ternaryEdgeTypeStub(Tuple nodes, Object supplierKey) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessTernaryEdgeRoot(supplierKey)));
    }

    @Override
    public Stub<Address<? extends Supplier>> unaryTypeStub(Tuple nodes, Object supplierKey) {
        return this.trace(new Stub<Address<? extends Supplier>>(nodes, this.boundary.accessUnaryRoot(supplierKey)));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask sideMask, TupleMask complementer, boolean negative) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer(primaryStub.getHandle(), primaryMask);
        Address<ProjectionIndexer> sideSlot = this.library.accessProjectionIndexer(sideStub.getHandle(), sideMask);
        if (negative) {
            Address<ExistenceNode> checker = this.library.accessExistenceNode(primarySlot, sideSlot, true);
            return this.trace(new Stub<Address<? extends Supplier>>(primaryStub, checker));
        }
        Address<JoinNode> checker = this.library.accessJoinNode(primarySlot, sideSlot, complementer);
        Tuple newCalibrationPattern = complementer.combine(primaryStub.getVariablesTuple(), sideStub.getVariablesTuple(), true, true);
        return this.trace(new Stub<Address<? extends Supplier>>(primaryStub, sideStub, newCalibrationPattern, checker));
    }

    @Override
    public Stub<Address<? extends Supplier>> buildCounterBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask originalSideMask, TupleMask complementer, Object aggregateResultCalibrationElement) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer(primaryStub.getHandle(), primaryMask);
        Address<? extends Indexer> sideSlot = this.library.accessCountOuterIndexer(sideStub.getHandle(), originalSideMask);
        Address<JoinNode> checker = this.library.accessJoinNode(primarySlot, sideSlot, TupleMask.selectSingle(originalSideMask.indices.length, originalSideMask.indices.length + 1));
        Object[] newCalibrationElement = new Object[]{aggregateResultCalibrationElement};
        LeftInheritanceTuple newCalibrationPattern = new LeftInheritanceTuple(primaryStub.getVariablesTuple(), newCalibrationElement);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(primaryStub, (Tuple)newCalibrationPattern, checker);
        return this.trace(result);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildCountCheckBetaNode(Stub<Address<? extends Supplier>> primaryStub, Stub<Address<? extends Supplier>> sideStub, TupleMask primaryMask, TupleMask originalSideMask, int resultPositionInSignature) {
        Address<ProjectionIndexer> primarySlot = this.library.accessProjectionIndexer(primaryStub.getHandle(), primaryMask);
        Address<? extends Indexer> sideSlot = this.library.accessCountOuterIdentityIndexer(sideStub.getHandle(), originalSideMask, resultPositionInSignature);
        Address<JoinNode> checker = this.library.accessJoinNode(primarySlot, sideSlot, TupleMask.empty(originalSideMask.indices.length + 1));
        Tuple newCalibrationPattern = primaryStub.getVariablesTuple();
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(primaryStub, newCalibrationPattern, checker);
        return this.trace(result);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildPredicateChecker(AbstractEvaluator evaluator, Integer rhsIndex, int[] affectedIndices, Stub<Address<? extends Supplier>> stub) {
        PredicateEvaluatorNode ten = new PredicateEvaluatorNode(this.engine, this.targetContainer, rhsIndex, affectedIndices, stub.getVariablesTuple().getSize(), evaluator);
        Address<PredicateEvaluatorNode> checker = Address.of(ten);
        this.reteNet.connectRemoteNodes(stub.getHandle(), checker, true);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(stub, checker);
        return this.trace(result);
    }

    @Override
    public Stub<Address<? extends Supplier>> buildFunctionEvaluator(AbstractEvaluator evaluator, Stub<Address<? extends Supplier>> stub, Object computedResultCalibrationElement) {
        CachedFunctionEvaluatorNode cfen = new CachedFunctionEvaluatorNode(this.targetContainer, this.engine, evaluator, stub.getVariablesTuple().getSize());
        Address<CachedFunctionEvaluatorNode> computer = Address.of(cfen);
        this.reteNet.connectRemoteNodes(stub.getHandle(), computer, true);
        Object[] newCalibrationElement = new Object[]{computedResultCalibrationElement};
        LeftInheritanceTuple newCalibrationPattern = new LeftInheritanceTuple(stub.getVariablesTuple(), newCalibrationElement);
        Stub<Address<? extends Supplier>> result = new Stub<Address<? extends Supplier>>(stub, (Tuple)newCalibrationPattern, computer);
        return this.trace(result);
    }

    @Override
    public Buildable<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> getNextContainer() {
        return new ReteContainerBuildable<PatternDescription>(this.engine, this.reteNet.getNextContainer());
    }

    @Override
    public Stub<Address<? extends Supplier>> buildScopeConstrainer(Stub<Address<? extends Supplier>> stub, boolean transitive, Object unwrappedContainer, int constrainedIndex) {
        Address<Supplier> root = transitive ? this.boundary.accessContainmentTransitiveRoot() : this.boundary.accessContainmentRoot();
        Address<ValueBinderFilterNode> filteredRoot = this.targetContainer.getLibrary().accessValueBinderFilterNode(root, 0, this.boundary.wrapElement(unwrappedContainer));
        int[] secondaryIndices = new int[]{1};
        Address<ProjectionIndexer> secondary = this.targetContainer.getLibrary().accessProjectionIndexer(filteredRoot, new TupleMask(secondaryIndices, 2));
        int[] primaryIndices = new int[]{constrainedIndex};
        TupleMask primaryMask = new TupleMask(primaryIndices, stub.getVariablesTuple().getSize());
        Address<ProjectionIndexer> primary = this.targetContainer.getLibrary().accessProjectionIndexer(stub.getHandle(), primaryMask);
        stub = new Stub<Address<ExistenceNode>>(stub, this.targetContainer.getLibrary().accessExistenceNode(primary, secondary, false));
        return this.trace(stub);
    }

    @Override
    public Address<? extends Receiver> patternCollector(PatternDescription pattern) throws RetePatternBuildException {
        return this.engine.getBoundary().createProductionInternal(pattern);
    }

    @Override
    public Buildable<PatternDescription, Address<? extends Supplier>, Address<? extends Receiver>> putOnTab(PatternDescription effort, IPatternMatcherContext<PatternDescription> effortContext) {
        ReteContainerBuildable patternSpecific;
        try {
            patternSpecific = (ReteContainerBuildable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
        patternSpecific.pattern = effort;
        patternSpecific.context = effortContext;
        return patternSpecific;
    }

    private Stub<Address<? extends Supplier>> trace(Stub<Address<? extends Supplier>> stub) {
        NodeToStubTraceInfo<PatternDescription> traceInfo = new NodeToStubTraceInfo<PatternDescription>(stub, this.pattern, this.context);
        Address<? extends Supplier> address = stub.getHandle();
        address.getContainer().resolveLocal(address).assignTraceInfo(traceInfo);
        return stub;
    }
}

