/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem;

import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.psystem.PConstraint;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;

public class PVariable {
    private PSystem<?, ?, ?> pSystem;
    private Object name;
    private boolean virtual;
    private Set<PConstraint> referringConstraints;
    private Boolean deducable;
    private PVariable unifiedInto;

    PVariable(PSystem<?, ?, ?> pSystem, Object name) {
        this(pSystem, name, false);
    }

    PVariable(PSystem<?, ?, ?> pSystem, Object name, boolean virtual) {
        this.pSystem = pSystem;
        this.name = name;
        this.virtual = virtual;
        this.referringConstraints = CollectionsFactory.getSet();
        this.unifiedInto = null;
        this.deducable = false;
    }

    public void unifyInto(PVariable replacement) {
        this.replacementCheck();
        replacement = replacement.getUnifiedIntoRoot();
        if (this.equals(replacement)) {
            return;
        }
        if (!this.isVirtual() && replacement.isVirtual()) {
            replacement.unifyInto(this);
        } else {
            replacement.virtual &= this.virtual;
            replacement.deducable = replacement.deducable != null && this.deducable != null ? Boolean.valueOf(replacement.deducable | this.deducable) : null;
            Set<PConstraint> snapshotConstraints = CollectionsFactory.getSet(this.referringConstraints);
            for (PConstraint constraint : snapshotConstraints) {
                constraint.replaceVariable(this, replacement);
            }
            this.unifiedInto = replacement;
            this.pSystem.noLongerUnique(this);
        }
    }

    public boolean isDeducable() {
        this.replacementCheck();
        if (this.deducable == null) {
            this.deducable = false;
            for (PConstraint pConstraint : this.getReferringConstraints()) {
                if (!pConstraint.getDeducedVariables().contains(this)) continue;
                this.deducable = true;
                break;
            }
        }
        return this.deducable;
    }

    public void refer(PConstraint constraint) {
        this.replacementCheck();
        this.deducable = null;
        this.referringConstraints.add(constraint);
    }

    public void unrefer(PConstraint constraint) {
        this.replacementCheck();
        this.deducable = null;
        this.referringConstraints.remove(constraint);
    }

    public Object getName() {
        this.replacementCheck();
        return this.name;
    }

    public boolean isVirtual() {
        this.replacementCheck();
        return this.virtual;
    }

    public Set<PConstraint> getReferringConstraints() {
        this.replacementCheck();
        return this.referringConstraints;
    }

    public <ConstraintType> Set<ConstraintType> getReferringConstraintsOfType(Class<ConstraintType> constraintClass) {
        this.replacementCheck();
        Set<PConstraint> result = CollectionsFactory.getSet();
        for (PConstraint pConstraint : this.referringConstraints) {
            if (!constraintClass.isInstance(pConstraint)) continue;
            result.add(pConstraint);
        }
        return result;
    }

    public String toString() {
        return this.name.toString();
    }

    public PVariable getDirectUnifiedInto() {
        return this.unifiedInto;
    }

    public PVariable getUnifiedIntoRoot() {
        PVariable nextUnified = this.unifiedInto;
        PVariable oldUnifiedInto = this;
        while (nextUnified != null) {
            oldUnifiedInto = nextUnified;
            nextUnified = oldUnifiedInto.getDirectUnifiedInto();
        }
        return oldUnifiedInto;
    }

    public boolean isUnique() {
        return this.unifiedInto == null;
    }

    private void replacementCheck() {
        if (this.unifiedInto != null) {
            throw new IllegalStateException("Illegal usage of variable " + this.name + " which has been replaced with " + this.unifiedInto.name);
        }
    }
}

