/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.psystem.basicdeferred;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.rete.collections.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.RetePatternBuildException;
import org.eclipse.incquery.runtime.rete.construction.Stub;
import org.eclipse.incquery.runtime.rete.construction.helpers.TypeHelper;
import org.eclipse.incquery.runtime.rete.construction.psystem.PSystem;
import org.eclipse.incquery.runtime.rete.construction.psystem.PVariable;
import org.eclipse.incquery.runtime.rete.construction.psystem.VariableDeferredPConstraint;

public abstract class BaseTypeSafeCheckOrEvalConstraint<PatternDescription, StubHandle>
extends VariableDeferredPConstraint<PatternDescription, StubHandle> {
    private Map<PVariable, Set<Object>> allTypeRestrictions;
    protected Set<PVariable> inputVariables;
    protected PVariable outputVariable;

    public BaseTypeSafeCheckOrEvalConstraint(PSystem<PatternDescription, StubHandle, ?> pSystem, Set<PVariable> inputVariables, PVariable outputVariable) {
        super(pSystem, (Set<PVariable>)(outputVariable == null ? inputVariables : new HashSet<PVariable>((Collection)inputVariables, outputVariable){
            {
                this.add(pVariable);
            }
        }));
        this.inputVariables = inputVariables;
        this.outputVariable = outputVariable;
    }

    @Override
    public Set<PVariable> getDeducedVariables() {
        if (this.outputVariable == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.outputVariable);
    }

    @Override
    protected Set<PVariable> getDeferringVariables() {
        return this.inputVariables;
    }

    @Override
    public boolean isReadyAt(Stub<StubHandle> stub) {
        if (super.isReadyAt(stub)) {
            return this.checkTypeSafety(stub) == null;
        }
        return false;
    }

    protected PVariable checkTypeSafety(Stub<StubHandle> stub) {
        for (PVariable pVariable : this.inputVariables) {
            Set<Object> checkedTypeRestrictions;
            Set<Object> allTypeRestrictionsForVariable = this.getAllTypeRestrictions().get(pVariable);
            Set<Object> uncheckedTypeRestrictions = TypeHelper.subsumeTypes(allTypeRestrictionsForVariable, checkedTypeRestrictions = TypeHelper.inferTypes(pVariable, stub.getAllEnforcedConstraints()), this.pSystem.getContext());
            if (uncheckedTypeRestrictions.isEmpty()) continue;
            return pVariable;
        }
        return null;
    }

    public Map<PVariable, Set<Object>> getAllTypeRestrictions() {
        if (this.allTypeRestrictions == null) {
            this.allTypeRestrictions = CollectionsFactory.getMap();
            for (PVariable pVariable : this.inputVariables) {
                this.allTypeRestrictions.put(pVariable, TypeHelper.inferTypes(pVariable, pVariable.getReferringConstraints()));
            }
        }
        return this.allTypeRestrictions;
    }

    @Override
    public void raiseForeverDeferredError(Stub<StubHandle> stub) throws RetePatternBuildException {
        if (super.isReadyAt(stub)) {
            String[] args = new String[]{this.toString(), this.checkTypeSafety(stub).toString()};
            String msg = "The checking of pattern constraint {1} cannot be deferred further, but variable {2} is still not type safe. HINT: the incremental matcher is not an equation solver, please make sure that all variable values are deducible.";
            String shortMsg = "Could not check all constraints due to undeducible type restrictions";
            throw new RetePatternBuildException(msg, args, shortMsg, null);
        }
        super.raiseForeverDeferredError(stub);
    }

    @Override
    protected void doReplaceVariable(PVariable obsolete, PVariable replacement) {
        if (this.inputVariables.remove(obsolete)) {
            this.inputVariables.add(replacement);
        }
        if (this.outputVariable == obsolete) {
            this.outputVariable = replacement;
        }
    }
}

