/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.eval;

import org.eclipse.incquery.runtime.rete.eval.AbstractEvaluator;
import org.eclipse.incquery.runtime.rete.matcher.ReteEngine;
import org.eclipse.incquery.runtime.rete.network.ReteContainer;
import org.eclipse.incquery.runtime.rete.single.SingleInputNode;
import org.eclipse.incquery.runtime.rete.tuple.Tuple;

public abstract class AbstractEvaluatorNode
extends SingleInputNode {
    protected ReteEngine<?> engine;
    protected AbstractEvaluator evaluator;
    int sourceTupleWidth;

    protected abstract Tuple tupleFromResult(Tuple var1, Object var2);

    protected abstract String logNodeName();

    public AbstractEvaluatorNode(ReteContainer reteContainer, ReteEngine<?> engine, AbstractEvaluator evaluator, int sourceTupleWidth) {
        super(reteContainer);
        this.engine = engine;
        this.evaluator = evaluator;
        this.sourceTupleWidth = sourceTupleWidth;
    }

    protected Object evaluateTerm(Tuple ps) {
        Object result = null;
        try {
            result = this.evaluator.evaluate(ps);
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            this.engine.getContext().logWarning(String.format("The incremental pattern matcher encountered an error during %s evaluation for pattern(s) %s over values %s. Error message: %s. (Developer note: %s in %s)", this.logNodeName(), this.getTraceInfoPatternsEnumerated(), this.prettyPrintTuple(ps), e.getMessage(), e.getClass().getSimpleName(), this), e);
            result = this.errorResult();
        }
        return result;
    }

    protected String prettyPrintTuple(Tuple ps) {
        return ps.toString();
    }

    protected Object errorResult() {
        return null;
    }
}

