/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.extensibility;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.incquery.runtime.internal.apiimpl.GenericQuerySpecification;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;

public final class QuerySpecificationRegistry {
    private static final Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> QUERY_SPECIFICATIONS = QuerySpecificationRegistry.createQuerySpecificationRegistry();

    private QuerySpecificationRegistry() {
    }

    private static Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> createQuerySpecificationRegistry() {
        HashMap<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications = new HashMap<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>();
        QuerySpecificationRegistry.initRegistry(specifications);
        return specifications;
    }

    private static void initRegistry(Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications) {
        specifications.clear();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg == null) {
            return;
        }
        IExtensionPoint poi = reg.getExtensionPoint("org.eclipse.incquery.runtime.queryspecification");
        if (poi != null) {
            IExtension[] exts = poi.getExtensions();
            HashSet<String> duplicates = new HashSet<String>();
            IExtension[] iExtensionArray = exts;
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] els;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = els = ext.getConfigurationElements();
                int n3 = els.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement el = iConfigurationElementArray[n4];
                    if (el.getName().equals("matcher")) {
                        QuerySpecificationRegistry.prepareQuerySpecification(specifications, duplicates, el);
                    } else {
                        IncQueryLoggingUtil.getDefaultLogger().error((Object)("[QuerySpecificationRegistry] Unknown configuration element " + el.getName() + " in plugin.xml of " + el.getDeclaringExtension().getUniqueIdentifier()));
                    }
                    ++n4;
                }
                ++n2;
            }
            if (!duplicates.isEmpty()) {
                StringBuilder duplicateSB = new StringBuilder("[QuerySpecificationRegistry] Trying to register patterns with the same FQN multiple times. Check your plug-in configuration!\n");
                duplicateSB.append("The following pattern FQNs appeared multiple times:\n");
                for (String fqn : duplicates) {
                    duplicateSB.append(String.format("\t%s%n", fqn));
                }
                IncQueryLoggingUtil.getDefaultLogger().warn((Object)duplicateSB.toString());
            }
        }
    }

    private static void prepareQuerySpecification(Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specifications, Set<String> duplicates, IConfigurationElement el) {
        block6: {
            String id = null;
            try {
                id = el.getAttribute("id");
                IQuerySpecificationProvider provider = (IQuerySpecificationProvider)el.createExecutableExtension("querySpecificationProvider");
                Object querySpecification = provider.get();
                String fullyQualifiedName = querySpecification.getPatternFullyQualifiedName();
                if (id.equals(fullyQualifiedName)) {
                    if (specifications.containsKey(fullyQualifiedName)) {
                        duplicates.add(fullyQualifiedName);
                    } else {
                        specifications.put(fullyQualifiedName, (IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>)querySpecification);
                    }
                    break block6;
                }
                throw new UnsupportedOperationException("Id attribute value " + id + " does not equal pattern FQN of query specification " + fullyQualifiedName + " in plugin.xml of " + el.getDeclaringExtension().getUniqueIdentifier());
            }
            catch (Exception e) {
                if (id == null) {
                    id = "undefined in plugin.xml";
                }
                IncQueryLoggingUtil.getDefaultLogger().error((Object)("[QuerySpecificationRegistry] Exception during query specification registry initialization when preparing ID: " + id + "! " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void registerQuerySpecification(IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> specification) {
        String qualifiedName = specification.getPatternFullyQualifiedName();
        if (!QUERY_SPECIFICATIONS.containsKey(qualifiedName)) {
            QUERY_SPECIFICATIONS.put(qualifiedName, specification);
        } else {
            IncQueryLoggingUtil.getDefaultLogger().warn((Object)String.format("[QuerySpecificationRegistry] Trying to register duplicate FQN (%s). Check your plug-in configuration!", qualifiedName));
        }
    }

    public static void unregisterQuerySpecification(String patternFQN) {
        QUERY_SPECIFICATIONS.remove(patternFQN);
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getContributedQuerySpecifications() {
        return new HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>(QUERY_SPECIFICATIONS.values());
    }

    public static IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> getQuerySpecification(String patternFQN) {
        if (QUERY_SPECIFICATIONS.containsKey(patternFQN)) {
            return QUERY_SPECIFICATIONS.get(patternFQN);
        }
        return null;
    }

    public static IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> getQuerySpecification(Pattern pattern) {
        String fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> contributedSpecification = QUERY_SPECIFICATIONS.get(fullyQualifiedName);
        if (contributedSpecification != null && pattern.equals(contributedSpecification.getPattern())) {
            return contributedSpecification;
        }
        return null;
    }

    public static IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> getOrCreateQuerySpecification(Pattern pattern) {
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> specification = QuerySpecificationRegistry.getQuerySpecification(pattern);
        if (specification != null) {
            return specification;
        }
        return new GenericQuerySpecification(pattern);
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternGroup(String packageFQN) {
        return QuerySpecificationRegistry.getPatternGroupOrSubTree(packageFQN, false);
    }

    public static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternSubTree(String packageFQN) {
        return QuerySpecificationRegistry.getPatternGroupOrSubTree(packageFQN, true);
    }

    private static Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getPatternGroupOrSubTree(String packageFQN, boolean includeSubPackages) {
        HashMap<String, HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>> map = new HashMap<String, HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>>();
        if (map.containsKey(packageFQN)) {
            return (Set)map.get(packageFQN);
        }
        HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> group = new HashSet<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>>();
        for (Map.Entry<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> entry : QUERY_SPECIFICATIONS.entrySet()) {
            QuerySpecificationRegistry.addPatternToGroup(packageFQN, group, entry.getKey(), entry.getValue(), includeSubPackages);
        }
        if (group.size() > 0) {
            map.put(packageFQN, group);
        }
        return group;
    }

    private static void addPatternToGroup(String packageFQN, Set<IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> group, String patternFQN, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> specification, boolean includeSubPackages) {
        if (packageFQN.length() + 1 < patternFQN.length()) {
            if (includeSubPackages) {
                if (patternFQN.startsWith(String.valueOf(packageFQN) + '.')) {
                    group.add(specification);
                }
            } else {
                String name = patternFQN.substring(patternFQN.lastIndexOf(46) + 1, patternFQN.length());
                if (patternFQN.equals(String.valueOf(packageFQN) + '.' + name)) {
                    group.add(specification);
                }
            }
        }
    }
}

