/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.core;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.snapshot.EIQSnapshot.BooleanSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.DateSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.DoubleSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.EIQSnapshotFactory;
import org.eclipse.incquery.snapshot.EIQSnapshot.EMFSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.EnumSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.FloatSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.InputSpecification;
import org.eclipse.incquery.snapshot.EIQSnapshot.IntSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.LongSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchRecord;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSubstitutionRecord;
import org.eclipse.incquery.snapshot.EIQSnapshot.MiscellaneousSubstitution;
import org.eclipse.incquery.snapshot.EIQSnapshot.StringSubstitution;
import org.eclipse.xtext.junit4.util.ParseHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SnapshotHelper {
    @Inject
    private ParseHelper parseHelper;

    public Notifier getEMFRootForSnapshot(IncQuerySnapshot snapshot) {
        EObject _xifexpression = null;
        InputSpecification _inputSpecification = snapshot.getInputSpecification();
        boolean _equals = Objects.equal((Object)_inputSpecification, (Object)InputSpecification.EOBJECT);
        if (_equals) {
            boolean _greaterThan;
            EObject _xifexpression_1 = null;
            EList _modelRoots = snapshot.getModelRoots();
            int _size = _modelRoots.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan) {
                EObject _get;
                EList _modelRoots_1 = snapshot.getModelRoots();
                _xifexpression_1 = _get = (EObject)_modelRoots_1.get(0);
            }
            _xifexpression = _xifexpression_1;
        } else {
            ResourceSet _xifexpression_2 = null;
            InputSpecification _inputSpecification_1 = snapshot.getInputSpecification();
            boolean _equals_1 = Objects.equal((Object)_inputSpecification_1, (Object)InputSpecification.RESOURCE);
            if (_equals_1) {
                boolean _greaterThan_1;
                ResourceSet _xifexpression_3 = null;
                EList _modelRoots_2 = snapshot.getModelRoots();
                int _size_1 = _modelRoots_2.size();
                boolean bl = _greaterThan_1 = _size_1 > 0;
                if (_greaterThan_1) {
                    EList _modelRoots_3 = snapshot.getModelRoots();
                    EObject _get_1 = (EObject)_modelRoots_3.get(0);
                    Resource _eResource = _get_1.eResource();
                    _xifexpression_3 = _eResource;
                }
                _xifexpression_2 = _xifexpression_3;
            } else {
                ResourceSet _xifexpression_4 = null;
                InputSpecification _inputSpecification_2 = snapshot.getInputSpecification();
                boolean _equals_2 = Objects.equal((Object)_inputSpecification_2, (Object)InputSpecification.RESOURCE_SET);
                if (_equals_2) {
                    ResourceSet _resourceSet;
                    Resource _eResource_1 = snapshot.eResource();
                    _xifexpression_4 = _resourceSet = _eResource_1.getResourceSet();
                }
                _xifexpression_2 = _xifexpression_4;
            }
            _xifexpression = _xifexpression_2;
        }
        return _xifexpression;
    }

    public ArrayList<EObject> getModelRootsForMatcher(IncQueryMatcher matcher) {
        ArrayList<EObject> _xblockexpression = null;
        IncQueryEngine _engine = matcher.getEngine();
        Notifier root = _engine.getScope();
        ArrayList<EObject> _xifexpression = null;
        if (root instanceof EObject) {
            return CollectionLiterals.newArrayList((Object[])new EObject[]{(EObject)root});
        }
        ArrayList<EObject> _xifexpression_1 = null;
        if (root instanceof Resource) {
            ArrayList<EObject> _arrayList;
            ArrayList<EObject> roots = _arrayList = new ArrayList<EObject>();
            EList _contents = ((Resource)root).getContents();
            roots.addAll((Collection<EObject>)_contents);
            return roots;
        }
        ArrayList<EObject> _xifexpression_2 = null;
        if (root instanceof ResourceSet) {
            ArrayList<EObject> _arrayList_1;
            final ArrayList<EObject> roots_1 = _arrayList_1 = new ArrayList<EObject>();
            EList _resources = ((ResourceSet)root).getResources();
            Procedures.Procedure1<Resource> _function = new Procedures.Procedure1<Resource>(){

                public void apply(Resource it) {
                    EList _contents = it.getContents();
                    roots_1.addAll(_contents);
                }
            };
            IterableExtensions.forEach((Iterable)_resources, (Procedures.Procedure1)_function);
            return roots_1;
        }
        _xblockexpression = _xifexpression = (_xifexpression_1 = _xifexpression_2);
        return _xblockexpression;
    }

    public InputSpecification getInputspecificationForMatcher(IncQueryMatcher matcher) {
        InputSpecification _xblockexpression = null;
        IncQueryEngine _engine = matcher.getEngine();
        Notifier root = _engine.getScope();
        InputSpecification _xifexpression = null;
        if (root instanceof EObject) {
            _xifexpression = InputSpecification.EOBJECT;
        } else {
            InputSpecification _xifexpression_1 = null;
            if (root instanceof Resource) {
                _xifexpression_1 = InputSpecification.RESOURCE;
            } else {
                InputSpecification _xifexpression_2 = null;
                if (root instanceof ResourceSet) {
                    _xifexpression_2 = InputSpecification.RESOURCE_SET;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public MatchSetRecord saveMatchesToSnapshot(IncQueryMatcher matcher, IPatternMatch partialMatch, IncQuerySnapshot snapshot) {
        String patternFQN = matcher.getPatternName();
        final MatchSetRecord actualRecord = EIQSnapshotFactory.eINSTANCE.createMatchSetRecord();
        actualRecord.setPatternQualifiedName(patternFQN);
        EList _matchSetRecords = snapshot.getMatchSetRecords();
        _matchSetRecords.add((Object)actualRecord);
        InputSpecification _inputSpecification = snapshot.getInputSpecification();
        boolean _equals = Objects.equal((Object)_inputSpecification, (Object)InputSpecification.UNSET);
        if (_equals) {
            EList _modelRoots = snapshot.getModelRoots();
            ArrayList<EObject> _modelRootsForMatcher = this.getModelRootsForMatcher(matcher);
            _modelRoots.addAll(_modelRootsForMatcher);
            EList _modelRoots_1 = snapshot.getModelRoots();
            _modelRoots_1.remove((Object)snapshot);
            InputSpecification _inputspecificationForMatcher = this.getInputspecificationForMatcher(matcher);
            snapshot.setInputSpecification(_inputspecificationForMatcher);
        }
        MatchRecord _createMatchRecordForMatch = this.createMatchRecordForMatch(partialMatch);
        actualRecord.setFilter(_createMatchRecordForMatch);
        IMatchProcessor<IPatternMatch> _function = new IMatchProcessor<IPatternMatch>(){

            public void process(IPatternMatch match) {
                EList _matches = actualRecord.getMatches();
                MatchRecord _createMatchRecordForMatch = SnapshotHelper.this.createMatchRecordForMatch(match);
                _matches.add((Object)_createMatchRecordForMatch);
            }
        };
        matcher.forEachMatch(partialMatch, (IMatchProcessor)_function);
        return actualRecord;
    }

    public MatchRecord createMatchRecordForMatch(final IPatternMatch match) {
        final MatchRecord matchRecord = EIQSnapshotFactory.eINSTANCE.createMatchRecord();
        List _parameterNames = match.parameterNames();
        Procedures.Procedure1<String> _function = new Procedures.Procedure1<String>(){

            public void apply(String param) {
                boolean _notEquals;
                Object _get = match.get(param);
                boolean bl = _notEquals = !Objects.equal((Object)_get, null);
                if (_notEquals) {
                    EList _substitutions = matchRecord.getSubstitutions();
                    Object _get_1 = match.get(param);
                    MatchSubstitutionRecord _createSubstitution = SnapshotHelper.this.createSubstitution(param, _get_1);
                    _substitutions.add((Object)_createSubstitution);
                }
            }
        };
        IterableExtensions.forEach((Iterable)_parameterNames, (Procedures.Procedure1)_function);
        return matchRecord;
    }

    public IPatternMatch createMatchForMachRecord(IncQueryMatcher matcher, MatchRecord matchRecord) {
        final IPatternMatch match = matcher.newEmptyMatch();
        EList _substitutions = matchRecord.getSubstitutions();
        Procedures.Procedure1<MatchSubstitutionRecord> _function = new Procedures.Procedure1<MatchSubstitutionRecord>(){

            public void apply(MatchSubstitutionRecord it) {
                Object target = it.getDerivedValue();
                String _parameterName = it.getParameterName();
                match.set(_parameterName, target);
            }
        };
        IterableExtensions.forEach((Iterable)_substitutions, (Procedures.Procedure1)_function);
        return match;
    }

    public MatchSetRecord saveMatchesToSnapshot(IncQueryMatcher matcher, IncQuerySnapshot snapshot) {
        IPatternMatch _newEmptyMatch = matcher.newEmptyMatch();
        MatchSetRecord _saveMatchesToSnapshot = this.saveMatchesToSnapshot(matcher, _newEmptyMatch, snapshot);
        return _saveMatchesToSnapshot;
    }

    public MatchSetRecord getMatchSetRecordForPattern(IncQuerySnapshot snapshot, final String patternFQN) {
        boolean _equals;
        MatchSetRecord _xblockexpression = null;
        EList _matchSetRecords = snapshot.getMatchSetRecords();
        Functions.Function1<MatchSetRecord, Boolean> _function = new Functions.Function1<MatchSetRecord, Boolean>(){

            public Boolean apply(MatchSetRecord it) {
                String _patternQualifiedName = it.getPatternQualifiedName();
                boolean _equals = _patternQualifiedName.equals(patternFQN);
                return _equals;
            }
        };
        Iterable matchsetrecord = IterableExtensions.filter((Iterable)_matchSetRecords, (Functions.Function1)_function);
        MatchSetRecord _xifexpression = null;
        int _size = IterableExtensions.size((Iterable)matchsetrecord);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            Iterator _iterator = matchsetrecord.iterator();
            return (MatchSetRecord)_iterator.next();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public ArrayList<MatchSetRecord> getMatchSetRecordsForPattern(IncQuerySnapshot snapshot, final String patternFQN) {
        ArrayList<MatchSetRecord> _arrayList;
        ArrayList<MatchSetRecord> matchSetRecords = _arrayList = new ArrayList<MatchSetRecord>();
        EList _matchSetRecords = snapshot.getMatchSetRecords();
        Functions.Function1<MatchSetRecord, Boolean> _function = new Functions.Function1<MatchSetRecord, Boolean>(){

            public Boolean apply(MatchSetRecord it) {
                String _patternQualifiedName = it.getPatternQualifiedName();
                boolean _equals = _patternQualifiedName.equals(patternFQN);
                return _equals;
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_matchSetRecords, (Functions.Function1)_function);
        Iterables.addAll(matchSetRecords, (Iterable)_filter);
        return matchSetRecords;
    }

    public MatchSubstitutionRecord createSubstitution(String parameterName, Object value) {
        if (value instanceof EObject) {
            EMFSubstitution sub = EIQSnapshotFactory.eINSTANCE.createEMFSubstitution();
            sub.setValue((EObject)value);
            sub.setParameterName(parameterName);
            return sub;
        }
        if (value instanceof Integer) {
            IntSubstitution sub_1 = EIQSnapshotFactory.eINSTANCE.createIntSubstitution();
            sub_1.setValue(((Integer)value).intValue());
            sub_1.setParameterName(parameterName);
            return sub_1;
        }
        if (value instanceof Long) {
            LongSubstitution sub_2 = EIQSnapshotFactory.eINSTANCE.createLongSubstitution();
            sub_2.setValue(((Long)value).longValue());
            sub_2.setParameterName(parameterName);
            return sub_2;
        }
        if (value instanceof Double) {
            DoubleSubstitution sub_3 = EIQSnapshotFactory.eINSTANCE.createDoubleSubstitution();
            sub_3.setValue(((Double)value).doubleValue());
            sub_3.setParameterName(parameterName);
            return sub_3;
        }
        if (value instanceof Float) {
            FloatSubstitution sub_4 = EIQSnapshotFactory.eINSTANCE.createFloatSubstitution();
            sub_4.setValue(((Float)value).floatValue());
            sub_4.setParameterName(parameterName);
            return sub_4;
        }
        if (value instanceof Boolean) {
            BooleanSubstitution sub_5 = EIQSnapshotFactory.eINSTANCE.createBooleanSubstitution();
            sub_5.setValue(((Boolean)value).booleanValue());
            sub_5.setParameterName(parameterName);
            return sub_5;
        }
        if (value instanceof String) {
            StringSubstitution sub_6 = EIQSnapshotFactory.eINSTANCE.createStringSubstitution();
            sub_6.setValue((String)value);
            sub_6.setParameterName(parameterName);
            return sub_6;
        }
        if (value instanceof Date) {
            DateSubstitution sub_7 = EIQSnapshotFactory.eINSTANCE.createDateSubstitution();
            sub_7.setValue((Date)value);
            sub_7.setParameterName(parameterName);
            return sub_7;
        }
        if (value instanceof EEnumLiteral) {
            EnumSubstitution sub_8 = EIQSnapshotFactory.eINSTANCE.createEnumSubstitution();
            String _literal = ((EEnumLiteral)value).getLiteral();
            sub_8.setValueLiteral(_literal);
            EEnum _eEnum = ((EEnumLiteral)value).getEEnum();
            sub_8.setEnumType(_eEnum);
            sub_8.setParameterName(parameterName);
            return sub_8;
        }
        MiscellaneousSubstitution sub_9 = EIQSnapshotFactory.eINSTANCE.createMiscellaneousSubstitution();
        sub_9.setValue(value);
        sub_9.setParameterName(parameterName);
        return sub_9;
    }

    public void prepareSnapshotMatcherFactories() {
        try {
            EObject _parse = this.parseHelper.parse((CharSequence)"\n\t\t\tpackage org.eclipse.viatra2.emf.incquery.testing.queries\n\n\t\t\timport \"http://www.eclipse.org/viatra2/emf/incquery/snapshot\"\n\t\t\timport \"http://www.eclipse.org/emf/2002/Ecore\"\n\t\t\t\n\t\t\tpattern RecordRoleValue(\n\t\t\t\tRecord : MatchRecord,\n\t\t\t\tRole\n\t\t\t) = {\n\t\t\t\tMatchSetRecord.filter(MS,Record);\n\t\t\t\tRecordRole::Filter == Role;\n\t\t\t} or {\n\t\t\t\tMatchSetRecord.matches(MS,Record);\n\t\t\t\tRecordRole::Match == Role;\n\t\t\t}\n\t\t\t\n\t\t\tpattern SubstitutionValue(\n\t\t\t\tSubstitution : MatchSubstitutionRecord,\n\t\t\t\tValue\n\t\t\t) = {\n\t\t\t\tMiscellaneousSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tEMFSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tIntSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tLongSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tDoubleSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tFloatSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tBooleanSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tStringSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tDateSubstitution.value(Substitution,Value);\n\t\t\t} or {\n\t\t\t\tEnumSubstitution.valueLiteral(Substitution,Value);\n\t\t\t}\n\t\t");
            PatternModel patternModel = (PatternModel)_parse;
            EList _patterns = patternModel.getPatterns();
            Procedures.Procedure1<Pattern> _function = new Procedures.Procedure1<Pattern>(){

                public void apply(Pattern it) {
                    IQuerySpecification factory = QuerySpecificationRegistry.getOrCreateQuerySpecification((Pattern)it);
                    QuerySpecificationRegistry.registerQuerySpecification((IQuerySpecification)factory);
                }
            };
            IterableExtensions.forEach((Iterable)_patterns, (Procedures.Procedure1)_function);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

