/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.core;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchRecord;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSubstitutionRecord;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.testing.core.TestingLogAppender;
import org.eclipse.incquery.testing.queries.UnexpectedMatchRecordMatch;
import org.eclipse.incquery.testing.queries.UnexpectedMatchRecordMatcher;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.junit.Assert;

public class TestExecutor {
    public static final String CORRECTRESULTS = "Correct result set";
    public static final String CORRECT_SINGLE = "Correct single match for parameterless pattern";
    public static final String CORRECT_EMPTY = "Correct empty match set";
    public static final String UNEXPECTED_MATCH = "Unexpected match";
    public static final String EXPECTED_NOT_FOUND = "Expected match not found";
    public static final String MULTIPLE_FOR_EXPECTED = "Multiple matches found for expected match";
    public static final String MATCHSETRECORD_NOT_IN_SNAPSHOT = "Expected match set record is not part of snapshot";
    public static final String PATTERNNAME_DIFFERENT = "Expected pattern qualified name different from actual";
    @Inject
    @Extension
    private ModelLoadHelper _modelLoadHelper;
    @Inject
    @Extension
    private SnapshotHelper _snapshotHelper;

    public boolean validateMatcherBeforeCompare(IncQueryMatcher matcher, MatchSetRecord expected, Set diff) {
        boolean _equals_1;
        boolean _not;
        String _patternQualifiedName;
        String _patternName = matcher.getPatternName();
        boolean _equals = _patternName.equals(_patternQualifiedName = expected.getPatternQualifiedName());
        boolean bl = _not = !_equals;
        if (_not) {
            String _plus = "Expected pattern qualified name different from actual (";
            String _patternQualifiedName_1 = expected.getPatternQualifiedName();
            String _plus_1 = String.valueOf(_plus) + _patternQualifiedName_1;
            String _plus_2 = String.valueOf(_plus_1) + "!=";
            String _patternName_1 = matcher.getPatternName();
            String _plus_3 = String.valueOf(_plus_2) + _patternName_1;
            String _plus_4 = String.valueOf(_plus_3) + ")";
            diff.add(_plus_4);
            return false;
        }
        List _parameterNames = matcher.getParameterNames();
        int _size = _parameterNames.size();
        boolean bl2 = _equals_1 = _size == 0;
        if (_equals_1) {
            boolean _equals_2;
            EList _matches = expected.getMatches();
            int _size_1 = _matches.size();
            boolean bl3 = _equals_2 = _size_1 == 1;
            if (_equals_2) {
                boolean _equals_4;
                boolean _equals_3;
                int _countMatches = matcher.countMatches();
                boolean bl4 = _equals_3 = _countMatches == 1;
                if (_equals_3) {
                    diff.add(CORRECT_SINGLE);
                    return true;
                }
                int _countMatches_1 = matcher.countMatches();
                boolean bl5 = _equals_4 = _countMatches_1 == 0;
                if (_equals_4) {
                    diff.add(CORRECT_EMPTY);
                    return true;
                }
            }
        }
        return true;
    }

    public HashSet<String> compareResultSetsAsRecords(IncQueryMatcher matcher, MatchSetRecord expected) {
        try {
            boolean _not_1;
            boolean _not;
            final HashSet diff = CollectionLiterals.newHashSet((Object[])new String[0]);
            boolean correctResults = this.validateMatcherBeforeCompare(matcher, expected, diff);
            boolean bl = _not = !correctResults;
            if (_not) {
                return diff;
            }
            EObject _eContainer = expected.eContainer();
            boolean bl2 = _not_1 = !(_eContainer instanceof IncQuerySnapshot);
            if (_not_1) {
                diff.add(MATCHSETRECORD_NOT_IN_SNAPSHOT);
                return diff;
            }
            EObject _eContainer_1 = expected.eContainer();
            IncQuerySnapshot snapshot = (IncQuerySnapshot)_eContainer_1;
            Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(snapshot);
            IncQueryEngine engine = IncQueryEngine.on((Notifier)_eMFRootForSnapshot);
            IQuerySpecification _querySpecification = UnexpectedMatchRecordMatcher.querySpecification();
            UnexpectedMatchRecordMatcher unexpectedMatcher = (UnexpectedMatchRecordMatcher)_querySpecification.getMatcher(engine);
            MatchRecord _filter = expected.getFilter();
            IPatternMatch partialMatch = this._snapshotHelper.createMatchForMachRecord(matcher, _filter);
            MatchSetRecord actual = this._snapshotHelper.saveMatchesToSnapshot(matcher, partialMatch, snapshot);
            IMatchProcessor<UnexpectedMatchRecordMatch> _function = new IMatchProcessor<UnexpectedMatchRecordMatch>(){

                public void process(UnexpectedMatchRecordMatch it) {
                    String _plus = "Unexpected match (";
                    String _prettyPrint = it.prettyPrint();
                    String _plus_1 = String.valueOf(_plus) + _prettyPrint;
                    String _plus_2 = String.valueOf(_plus_1) + ")";
                    diff.add(_plus_2);
                }
            };
            unexpectedMatcher.forEachMatch(actual, expected, null, (IMatchProcessor)_function);
            IMatchProcessor<UnexpectedMatchRecordMatch> _function_1 = new IMatchProcessor<UnexpectedMatchRecordMatch>(){

                public void process(UnexpectedMatchRecordMatch it) {
                    String _plus = "Expected match not found (";
                    String _prettyPrint = it.prettyPrint();
                    String _plus_1 = String.valueOf(_plus) + _prettyPrint;
                    String _plus_2 = String.valueOf(_plus_1) + ")";
                    diff.add(_plus_2);
                }
            };
            unexpectedMatcher.forEachMatch(expected, actual, null, (IMatchProcessor)_function_1);
            return diff;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public HashSet<String> compareResultSets(IncQueryMatcher matcher, MatchSetRecord expected) {
        boolean _not;
        final HashSet diff = CollectionLiterals.newHashSet((Object[])new String[0]);
        boolean correctResults = this.validateMatcherBeforeCompare(matcher, expected, diff);
        boolean bl = _not = !correctResults;
        if (_not) {
            return diff;
        }
        final ArrayList foundMatches = CollectionLiterals.newArrayList((Object[])new IPatternMatch[0]);
        EList _matches = expected.getMatches();
        for (MatchRecord matchRecord : _matches) {
            boolean _equals_1;
            boolean _equals;
            IPatternMatch partialMatch = this._snapshotHelper.createMatchForMachRecord(matcher, matchRecord);
            int numMatches = matcher.countMatches(partialMatch);
            boolean bl2 = _equals = numMatches == 0;
            if (_equals) {
                String _plus = "Expected match not found (";
                StringBuilder _printMatchRecord = this.printMatchRecord(matchRecord);
                String _plus_1 = String.valueOf(_plus) + _printMatchRecord;
                String _plus_2 = String.valueOf(_plus_1) + ")";
                diff.add(_plus_2);
                correctResults = false;
                continue;
            }
            boolean bl3 = _equals_1 = numMatches == 1;
            if (_equals_1) {
                foundMatches.add(partialMatch);
                continue;
            }
            String _plus_3 = "Multiple matches found for expected match (";
            StringBuilder _printMatchRecord_1 = this.printMatchRecord(matchRecord);
            String _plus_4 = String.valueOf(_plus_3) + _printMatchRecord_1;
            String _plus_5 = String.valueOf(_plus_4) + ")";
            diff.add(_plus_5);
            correctResults = false;
        }
        MatchRecord _filter = expected.getFilter();
        IPatternMatch _createMatchForMachRecord = this._snapshotHelper.createMatchForMachRecord(matcher, _filter);
        IMatchProcessor<IPatternMatch> _function = new IMatchProcessor<IPatternMatch>(){

            public void process(IPatternMatch it) {
                boolean _not;
                boolean _contains = foundMatches.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    String _plus = "Unexpected match (";
                    String _prettyPrint = it.prettyPrint();
                    String _plus_1 = String.valueOf(_plus) + _prettyPrint;
                    String _plus_2 = String.valueOf(_plus_1) + ")";
                    diff.add(_plus_2);
                }
            }
        };
        matcher.forEachMatch(_createMatchForMachRecord, (IMatchProcessor)_function);
        return diff;
    }

    public StringBuilder printMatchRecord(MatchRecord record) {
        StringBuilder _append;
        StringBuilder _stringBuilder;
        StringBuilder _xblockexpression = null;
        final StringBuilder sb = _stringBuilder = new StringBuilder();
        EObject _eContainer = record.eContainer();
        MatchSetRecord matchSet = (MatchSetRecord)_eContainer;
        EList _substitutions = record.getSubstitutions();
        Procedures.Procedure1<MatchSubstitutionRecord> _function = new Procedures.Procedure1<MatchSubstitutionRecord>(){

            public void apply(MatchSubstitutionRecord it) {
                boolean _greaterThan;
                int _length = sb.length();
                boolean bl = _greaterThan = _length > 0;
                if (_greaterThan) {
                    sb.append(",");
                }
                String _parameterName = it.getParameterName();
                StringBuilder _append = sb.append(_parameterName);
                StringBuilder _append_1 = _append.append("=");
                Object _derivedValue = it.getDerivedValue();
                _append_1.append(_derivedValue);
            }
        };
        IterableExtensions.forEach((Iterable)_substitutions, (Procedures.Procedure1)_function);
        String _patternQualifiedName = matchSet.getPatternQualifiedName();
        String _plus = String.valueOf(_patternQualifiedName) + "(";
        sb.insert(0, _plus);
        _xblockexpression = _append = sb.append(")");
        return _xblockexpression;
    }

    public void assertMatchResults(final PatternModel patternModel, IncQuerySnapshot snapshot) {
        try {
            final HashSet diff = CollectionLiterals.newHashSet((Object[])new Object[0]);
            Notifier input = this._snapshotHelper.getEMFRootForSnapshot(snapshot);
            final IncQueryEngine engine = IncQueryEngine.on((Notifier)input);
            this.registerLogger(engine);
            EList _matchSetRecords = snapshot.getMatchSetRecords();
            Procedures.Procedure1<MatchSetRecord> _function = new Procedures.Procedure1<MatchSetRecord>(){

                public void apply(MatchSetRecord matchSet) {
                    boolean _notEquals;
                    String _patternQualifiedName = matchSet.getPatternQualifiedName();
                    IncQueryMatcher<? extends IPatternMatch> matcher = TestExecutor.this._modelLoadHelper.initializeMatcherFromModel(patternModel, engine, _patternQualifiedName);
                    boolean bl = _notEquals = !Objects.equal(matcher, null);
                    if (_notEquals) {
                        boolean _not;
                        HashSet<String> result = TestExecutor.this.compareResultSets(matcher, matchSet);
                        boolean _or = false;
                        boolean _or_1 = false;
                        boolean _equals = Objects.equal(result, null);
                        if (_equals) {
                            _or_1 = true;
                        } else {
                            HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new String[]{TestExecutor.CORRECT_EMPTY});
                            boolean _equals_1 = _newHashSet.equals(result);
                            boolean bl2 = _or_1 = _equals || _equals_1;
                        }
                        if (_or_1) {
                            _or = true;
                        } else {
                            HashSet _newHashSet_1 = CollectionLiterals.newHashSet((Object[])new String[]{TestExecutor.CORRECT_SINGLE});
                            boolean _equals_2 = _newHashSet_1.equals(result);
                            _or = _or_1 || _equals_2;
                        }
                        boolean bl3 = _not = !_or;
                        if (_not) {
                            diff.addAll(result);
                        }
                    }
                }
            };
            IterableExtensions.forEach((Iterable)_matchSetRecords, (Procedures.Procedure1)_function);
            String _logDifference = this.logDifference(diff, engine);
            boolean _isEmpty = diff.isEmpty();
            Assert.assertTrue((String)_logDifference, (boolean)_isEmpty);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void assertMatchResults(PatternModel patternModel, String snapshotUri) {
        IncQuerySnapshot snapshot = this._modelLoadHelper.loadExpectedResultsFromUri(snapshotUri);
        this.assertMatchResults(patternModel, snapshot);
    }

    public void assertMatchResults(String patternUri, String snapshotUri) {
        PatternModel patternModel = this._modelLoadHelper.loadPatternModelFromUri(patternUri);
        this.assertMatchResults(patternModel, snapshotUri);
    }

    public void registerLogger(IncQueryEngine engine) {
        Logger _logger = engine.getLogger();
        TestingLogAppender _testingLogAppender = new TestingLogAppender();
        _logger.addAppender((Appender)_testingLogAppender);
    }

    public String retrieveLoggerOutput(IncQueryEngine engine) {
        boolean _hasMoreElements;
        Logger logger = engine.getLogger();
        Enumeration appers = logger.getAllAppenders();
        boolean _while = _hasMoreElements = appers.hasMoreElements();
        while (_while) {
            boolean _hasMoreElements_1;
            Object apper = appers.nextElement();
            if (apper instanceof TestingLogAppender) {
                StringBuilder _output = ((TestingLogAppender)((Object)apper)).getOutput();
                return _output.toString();
            }
            _while = _hasMoreElements_1 = appers.hasMoreElements();
        }
        return "Logger output not recorded";
    }

    public String logDifference(Set<? extends Object> diff) {
        String _string;
        StringBuilder _stringBuilder;
        String _xblockexpression = null;
        StringBuilder stringBuilder = _stringBuilder = new StringBuilder();
        this.logDifference(diff, stringBuilder);
        _xblockexpression = _string = stringBuilder.toString();
        return _xblockexpression;
    }

    public String logDifference(Set<Object> diff, IncQueryEngine engine) {
        String _string;
        StringBuilder _stringBuilder;
        String _xblockexpression = null;
        StringBuilder stringBuilder = _stringBuilder = new StringBuilder();
        this.logDifference(diff, stringBuilder);
        String _retrieveLoggerOutput = this.retrieveLoggerOutput(engine);
        stringBuilder.append(_retrieveLoggerOutput);
        _xblockexpression = _string = stringBuilder.toString();
        return _xblockexpression;
    }

    private void logDifference(Set<? extends Object> diff, final StringBuilder stringBuilder) {
        Procedures.Procedure1<Object> _function = new Procedures.Procedure1<Object>(){

            public void apply(Object it) {
                String _plus = "\n" + it;
                stringBuilder.append(_plus);
            }
        };
        IterableExtensions.forEach(diff, (Procedures.Procedure1)_function);
    }
}

