/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.core.base;

import com.google.inject.Inject;
import java.util.HashSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.incquery.testing.core.ModelLoadHelper;
import org.eclipse.incquery.testing.core.SnapshotHelper;
import org.eclipse.incquery.testing.core.TestExecutor;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.junit.Assert;

public abstract class CommonStaticQueryTester {
    @Inject
    @Extension
    private ModelLoadHelper _modelLoadHelper;
    @Inject
    @Extension
    private TestExecutor _testExecutor;
    @Inject
    @Extension
    private SnapshotHelper _snapshotHelper;

    public void testQuery(String queryFQN) {
        try {
            IncQuerySnapshot sns = this.snapshot();
            Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
            IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
            PatternModel _queryInputXMI = this.queryInputXMI();
            IncQueryMatcher<? extends IPatternMatch> matcher = this._modelLoadHelper.initializeMatcherFromModel(_queryInputXMI, engine, queryFQN);
            MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, queryFQN);
            HashSet<String> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
            String _logDifference = this._testExecutor.logDifference(results);
            HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new Object[0]);
            Assert.assertArrayEquals((String)_logDifference, (Object[])((Object[])Conversions.unwrapArray((Object)_newHashSet, Object.class)), (Object[])((Object[])Conversions.unwrapArray(results, Object.class)));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void testQuery(IQuerySpecification queryMF) {
        IncQuerySnapshot sns = this.snapshot();
        Notifier _eMFRootForSnapshot = this._snapshotHelper.getEMFRootForSnapshot(sns);
        IncQueryEngine engine = this.getEngine(_eMFRootForSnapshot);
        this.testQuery(engine, sns, queryMF);
    }

    public void testQuery(IncQueryEngine engine, IncQuerySnapshot sns, IQuerySpecification queryMF) {
        try {
            IncQueryMatcher matcher = engine.getMatcher(queryMF);
            String _patternFullyQualifiedName = queryMF.getPatternFullyQualifiedName();
            MatchSetRecord _matchSetRecordForPattern = this._snapshotHelper.getMatchSetRecordForPattern(sns, _patternFullyQualifiedName);
            HashSet<String> results = this._testExecutor.compareResultSets(matcher, _matchSetRecordForPattern);
            String _logDifference = this._testExecutor.logDifference(results);
            HashSet _newHashSet = CollectionLiterals.newHashSet((Object[])new Object[0]);
            Assert.assertArrayEquals((String)_logDifference, (Object[])((Object[])Conversions.unwrapArray((Object)_newHashSet, Object.class)), (Object[])((Object[])Conversions.unwrapArray(results, Object.class)));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IncQueryEngine getEngine(Notifier root) {
        try {
            return IncQueryEngine.on((Notifier)root);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IncQuerySnapshot snapshot() {
        String _snapshotURI = this.snapshotURI();
        IncQuerySnapshot _loadExpectedResultsFromUri = this._modelLoadHelper.loadExpectedResultsFromUri(_snapshotURI);
        return _loadExpectedResultsFromUri;
    }

    public PatternModel queryInputXMI() {
        String _queryInputXMIURI = this.queryInputXMIURI();
        PatternModel _loadPatternModelFromUri = this._modelLoadHelper.loadPatternModelFromUri(_queryInputXMIURI);
        return _loadPatternModelFromUri;
    }

    public abstract String snapshotURI();

    public abstract String queryInputXMIURI();
}

