/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.IExtensions;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GenerateQuerySpecificationExtension {
  @Inject
  private IJvmModelAssociations associations;
  
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  public ArrayList<IPluginExtension> extensionContribution(final Pattern pattern, final ExtensionGenerator exGen) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    final Procedure1<IPluginExtension> _function = new Procedure1<IPluginExtension>() {
      public void apply(final IPluginExtension it) {
        final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
          public void apply(final IPluginElement it) {
            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
            exGen.contribAttribute(it, "id", _fullyQualifiedName);
            Set<EObject> _jvmElements = GenerateQuerySpecificationExtension.this.associations.getJvmElements(pattern);
            final Function1<EObject,Boolean> _function = new Function1<EObject,Boolean>() {
              public Boolean apply(final EObject it) {
                boolean _and = false;
                if (!(it instanceof JvmDeclaredType)) {
                  _and = false;
                } else {
                  String _simpleName = ((JvmDeclaredType) it).getSimpleName();
                  String _querySpecificationClassName = GenerateQuerySpecificationExtension.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
                  boolean _equals = _simpleName.equals(_querySpecificationClassName);
                  _and = ((it instanceof JvmDeclaredType) && _equals);
                }
                return Boolean.valueOf(_and);
              }
            };
            EObject _findFirst = IterableExtensions.<EObject>findFirst(_jvmElements, _function);
            final JvmDeclaredType querySpecificationClass = ((JvmDeclaredType) _findFirst);
            EList<JvmMember> _members = querySpecificationClass.getMembers();
            final Function1<JvmMember,Boolean> _function_1 = new Function1<JvmMember,Boolean>() {
              public Boolean apply(final JvmMember it) {
                boolean _and = false;
                if (!(it instanceof JvmType)) {
                  _and = false;
                } else {
                  String _simpleName = ((JvmType) it).getSimpleName();
                  String _querySpecificationProviderClassName = GenerateQuerySpecificationExtension.this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationProviderClassName(pattern);
                  boolean _equals = _simpleName.equals(_querySpecificationProviderClassName);
                  _and = ((it instanceof JvmType) && _equals);
                }
                return Boolean.valueOf(_and);
              }
            };
            JvmMember _findFirst_1 = IterableExtensions.<JvmMember>findFirst(_members, _function_1);
            final JvmIdentifiableElement providerClass = ((JvmIdentifiableElement) _findFirst_1);
            String _qualifiedName = providerClass.getQualifiedName();
            exGen.contribAttribute(it, "querySpecificationProvider", _qualifiedName);
          }
        };
        exGen.contribElement(it, "matcher", _function);
      }
    };
    IPluginExtension _contribExtension = exGen.contribExtension(_fullyQualifiedName, IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID, _function);
    ArrayList<IPluginExtension> _newArrayList = CollectionLiterals.<IPluginExtension>newArrayList(_contribExtension);
    return _newArrayList;
  }
  
  public static ArrayList<Pair<String,String>> getRemovableExtensionIdentifiers() {
    Pair<String,String> _of = Pair.<String, String>of("", IExtensions.QUERY_SPECIFICATION_EXTENSION_POINT_ID);
    ArrayList<Pair<String,String>> _newArrayList = CollectionLiterals.<Pair<String,String>>newArrayList(_of);
    return _newArrayList;
  }
}
