/**
 * Copyright (c) 2010-2012, Andras Okros, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Andras Okros - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator;

import com.google.inject.Inject;
import java.util.ArrayList;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.IExtensions;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

@SuppressWarnings("all")
public class GenerateXExpressionEvaluatorExtension {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  public ArrayList<IPluginExtension> extensionContribution(final Pattern pattern, final String expressionUniqueID, final String expressionUniqueNameInPattern, final ExtensionGenerator exGen) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    final Procedure1<IPluginExtension> _function = new Procedure1<IPluginExtension>() {
      public void apply(final IPluginExtension it) {
        final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
          public void apply(final IPluginElement it) {
            exGen.contribAttribute(it, "id", expressionUniqueID);
            String _utilPackageName = GenerateXExpressionEvaluatorExtension.this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
            String _plus = (_utilPackageName + ".");
            String _evaluatorClassName = GenerateXExpressionEvaluatorExtension.this._eMFPatternLanguageJvmModelInferrerUtil.evaluatorClassName(pattern);
            String _plus_1 = (_plus + _evaluatorClassName);
            String _plus_2 = (_plus_1 + expressionUniqueNameInPattern);
            exGen.contribAttribute(it, "evaluatorClass", _plus_2);
          }
        };
        exGen.contribElement(it, "evaluator", _function);
      }
    };
    IPluginExtension _contribExtension = exGen.contribExtension(_fullyQualifiedName, IExtensions.XEXPRESSIONEVALUATOR_EXTENSION_POINT_ID, _function);
    ArrayList<IPluginExtension> _newArrayList = CollectionLiterals.<IPluginExtension>newArrayList(_contribExtension);
    return _newArrayList;
  }
  
  public static ArrayList<Pair<String,String>> getRemovableExtensionIdentifiers() {
    Pair<String,String> _of = Pair.<String, String>of("", IExtensions.XEXPRESSIONEVALUATOR_EXTENSION_POINT_ID);
    ArrayList<Pair<String,String>> _newArrayList = CollectionLiterals.<Pair<String,String>>newArrayList(_of);
    return _newArrayList;
  }
}
