/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Mark Czotter, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi, Mark Czotter - initial API and implementation
 */
package org.eclipse.incquery.tooling.core.generator.builder.xmi;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil.Copier;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.EMFPatternLanguageFactory;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.XImportSection;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidationDiagnostics;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternSetValidator;
import org.eclipse.incquery.patternlanguage.emf.validation.PatternValidationStatus;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternURIHandler;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * @author Mark Czotter
 */
@SuppressWarnings("all")
public class XmiModelBuilder {
  @Inject
  private Logger logger;
  
  @Inject
  private PatternSetValidator validator;
  
  @Inject
  private IErrorFeedback feedback;
  
  /**
   * Builds one model file (XMI) from the input into the folder.
   */
  public void build(final ResourceSet resourceSet, final String fileFullPath) {
    try {
      final PatternModel xmiModelRoot = EMFPatternLanguageFactory.eINSTANCE.createPatternModel();
      XImportSection _createXImportSection = EMFPatternLanguageFactory.eINSTANCE.createXImportSection();
      xmiModelRoot.setImportPackages(_createXImportSection);
      URI _createPlatformResourceURI = URI.createPlatformResourceURI(fileFullPath, true);
      final Resource xmiResource = resourceSet.createResource(_createPlatformResourceURI);
      EList<EObject> _contents = xmiResource.getContents();
      _contents.add(xmiModelRoot);
      final HashSet<EPackage> importDeclarations = CollectionLiterals.<EPackage>newHashSet();
      EList<Resource> _resources = resourceSet.getResources();
      ArrayList<Resource> _arrayList = new ArrayList<Resource>(_resources);
      final ArrayList<Resource> resources = _arrayList;
      for (final Resource r : resources) {
        EList<EObject> _contents_1 = r.getContents();
        for (final EObject obj : _contents_1) {
          boolean _and = false;
          if (!(obj instanceof PatternModel)) {
            _and = false;
          } else {
            boolean _equals = obj.equals(xmiModelRoot);
            boolean _not = (!_equals);
            _and = ((obj instanceof PatternModel) && _not);
          }
          if (_and) {
            Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(((PatternModel) obj));
            for (final PackageImport importDecl : _packageImportsIterable) {
              {
                final EPackage ePackage = importDecl.getEPackage();
                boolean _and_1 = false;
                boolean _and_2 = false;
                boolean _notEquals = (!Objects.equal(ePackage, null));
                if (!_notEquals) {
                  _and_2 = false;
                } else {
                  boolean _eIsProxy = ePackage.eIsProxy();
                  boolean _not_1 = (!_eIsProxy);
                  _and_2 = (_notEquals && _not_1);
                }
                if (!_and_2) {
                  _and_1 = false;
                } else {
                  boolean _contains = importDeclarations.contains(ePackage);
                  boolean _not_2 = (!_contains);
                  _and_1 = (_and_2 && _not_2);
                }
                if (_and_1) {
                  importDeclarations.add(ePackage);
                }
              }
            }
          }
        }
      }
      XImportSection _importPackages = xmiModelRoot.getImportPackages();
      EList<PackageImport> _packageImport = null;
      if (_importPackages!=null) {
        _packageImport=_importPackages.getPackageImport();
      }
      final Function1<EPackage,PackageImport> _function = new Function1<EPackage,PackageImport>() {
        public PackageImport apply(final EPackage it) {
          final PackageImport imp = EMFPatternLanguageFactory.eINSTANCE.createPackageImport();
          imp.setEPackage(it);
          return imp;
        }
      };
      Iterable<PackageImport> _map = IterableExtensions.<EPackage, PackageImport>map(importDeclarations, _function);
      Iterables.<PackageImport>addAll(_packageImport, _map);
      ArrayList<JvmFormalParameter> _arrayList_1 = new ArrayList<JvmFormalParameter>();
      final ArrayList<JvmFormalParameter> newParameters = _arrayList_1;
      final Map<String,Pattern> fqnToPatternMap = CollectionLiterals.<String, Pattern>newHashMap();
      final Function1<Resource,Boolean> _function_1 = new Function1<Resource,Boolean>() {
        public Boolean apply(final Resource it) {
          boolean _notEquals = (!Objects.equal(it, xmiResource));
          return Boolean.valueOf(_notEquals);
        }
      };
      Iterable<Resource> _filter = IterableExtensions.<Resource>filter(resources, _function_1);
      final Function1<Resource,Iterable<Pattern>> _function_2 = new Function1<Resource,Iterable<Pattern>>() {
        public Iterable<Pattern> apply(final Resource r) {
          TreeIterator<EObject> _allContents = r.getAllContents();
          Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_allContents);
          Iterable<Pattern> _filter = Iterables.<Pattern>filter(_iterable, Pattern.class);
          return _filter;
        }
      };
      Iterable<Iterable<Pattern>> _map_1 = IterableExtensions.<Resource, Iterable<Pattern>>map(_filter, _function_2);
      Iterable<Pattern> _flatten = Iterables.<Pattern>concat(_map_1);
      for (final Pattern pattern : _flatten) {
        PatternSetValidationDiagnostics _validateTransitively = this.validator.validateTransitively(pattern);
        PatternValidationStatus _status = _validateTransitively.getStatus();
        boolean _notEquals = (!Objects.equal(_status, PatternValidationStatus.ERROR));
        if (_notEquals) {
          ArrayList<JvmFormalParameter> _copyPattern = this.copyPattern(pattern, fqnToPatternMap, xmiModelRoot);
          Iterables.<JvmFormalParameter>addAll(newParameters, _copyPattern);
        }
      }
      Resource _eResource = xmiModelRoot.eResource();
      EList<EObject> _contents_2 = _eResource.getContents();
      Iterables.<EObject>addAll(_contents_2, newParameters);
      TreeIterator<EObject> _eAllContents = xmiModelRoot.eAllContents();
      Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_eAllContents);
      Iterable<PatternCall> _filter_1 = Iterables.<PatternCall>filter(_iterable, PatternCall.class);
      for (final PatternCall call : _filter_1) {
        {
          Pattern _patternRef = call.getPatternRef();
          final String fqn = CorePatternLanguageHelper.getFullyQualifiedName(_patternRef);
          final Pattern p = fqnToPatternMap.get(fqn);
          boolean _equals_1 = Objects.equal(p, null);
          if (_equals_1) {
            String _plus = ("Pattern not found: " + fqn);
            this.logger.error(_plus);
          } else {
            call.setPatternRef(((Pattern) p));
          }
        }
      }
      EMFPatternURIHandler _eMFPatternURIHandler = new EMFPatternURIHandler(importDeclarations);
      Pair<String,EMFPatternURIHandler> _mappedTo = Pair.<String, EMFPatternURIHandler>of(XMLResource.OPTION_URI_HANDLER, _eMFPatternURIHandler);
      final HashMap<String,EMFPatternURIHandler> options = CollectionLiterals.<String, EMFPatternURIHandler>newHashMap(_mappedTo);
      xmiResource.save(options);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        this.logger.error("Exception during XMI build!", e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  public ArrayList<JvmFormalParameter> copyPattern(final Pattern pattern, final Map<String,Pattern> fqnToPatternMap, final PatternModel xmiModelRoot) {
    Copier _copier = new Copier();
    final Copier copier = _copier;
    EObject _copy = copier.copy(pattern);
    final Pattern p = ((Pattern) _copy);
    copier.copyReferences();
    final String fqn = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    p.setName(fqn);
    Resource _eResource = pattern.eResource();
    URI _uRI = _eResource.getURI();
    String _string = _uRI.toString();
    p.setFileName(_string);
    Pattern _get = fqnToPatternMap.get(fqn);
    boolean _notEquals = (!Objects.equal(_get, null));
    if (_notEquals) {
      String _plus = ("Pattern with qualified name " + fqn);
      String _plus_1 = (_plus + "is encountered multiple times - check project.");
      this.feedback.reportError(pattern, _plus_1, "org.eclipse.incquery.tooling.core.generator", Severity.WARNING, IErrorFeedback.JVMINFERENCE_ERROR_TYPE);
    } else {
      fqnToPatternMap.put(fqn, p);
      EList<Pattern> _patterns = xmiModelRoot.getPatterns();
      _patterns.add(p);
    }
    ArrayList<JvmFormalParameter> _arrayList = new ArrayList<JvmFormalParameter>();
    final ArrayList<JvmFormalParameter> newParameters = _arrayList;
    final TreeIterator<EObject> iterator = p.eAllContents();
    boolean _hasNext = iterator.hasNext();
    boolean _while = _hasNext;
    while (_while) {
      {
        final EObject next = iterator.next();
        if ((next instanceof XExpression)) {
          final XExpression expr = ((XExpression) next);
          TreeIterator<EObject> _eAllContents = expr.eAllContents();
          Iterable<EObject> _iterable = IteratorExtensions.<EObject>toIterable(_eAllContents);
          Iterable<XFeatureCall> _filter = Iterables.<XFeatureCall>filter(_iterable, XFeatureCall.class);
          for (final XFeatureCall expression : _filter) {
            {
              final JvmIdentifiableElement f = expression.getFeature();
              if ((f instanceof JvmFormalParameter)) {
                EObject _copy_1 = copier.copy(f);
                final JvmFormalParameter target = ((JvmFormalParameter) _copy_1);
                expression.setFeature(target);
                newParameters.add(target);
              }
            }
          }
          iterator.prune();
        }
      }
      boolean _hasNext_1 = iterator.hasNext();
      _while = _hasNext_1;
    }
    return newParameters;
  }
}
