/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.generator.model.scoping;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelPackage;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

public class GeneratorModelLinkingService
extends DefaultLinkingService {
    private static final Logger LOG = Logger.getLogger(GeneratorModelLinkingService.class);
    @Inject
    private IValueConverterService valueConverterService;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) {
        if (ref == GeneratorModelPackage.eINSTANCE.getGeneratorModelReference_Genmodel() && context instanceof GeneratorModelReference && node instanceof ILeafNode) {
            return this.getGenModel((GeneratorModelReference)context, (ILeafNode)node);
        }
        return super.getLinkedObjects(context, ref, node);
    }

    private List<EObject> getGenModel(GeneratorModelReference context, ILeafNode text) {
        String nsUri = this.getMetamodelNsURI(text);
        if (nsUri == null) {
            return Collections.emptyList();
        }
        GenModel pack = this.loadGenmodel(nsUri, context.eResource().getResourceSet());
        if (pack != null) {
            return Collections.singletonList(pack);
        }
        return Collections.emptyList();
    }

    private String getMetamodelNsURI(ILeafNode text) {
        try {
            return (String)this.valueConverterService.toValue(text.getText(), this.getLinkingHelper().getRuleNameFrom(text.getGrammarElement()), (INode)text);
        }
        catch (ValueConverterException e) {
            LOG.debug((Object)("Exception on leaf '" + text.getText() + "'"), (Throwable)e);
            return null;
        }
    }

    private GenModel loadGenmodel(String resourceOrNsURI, ResourceSet resourceSet) {
        URI uri = null;
        try {
            uri = URI.createURI((String)resourceOrNsURI);
            if (uri.fragment() == null) {
                Resource resource = resourceSet.getResource(uri, true);
                return (GenModel)resource.getContents().get(0);
            }
            return (GenModel)resourceSet.getEObject(uri, true);
        }
        catch (IllegalArgumentException ex) {
            LOG.trace((Object)("Invalid package URI: '" + resourceOrNsURI + "'"), (Throwable)ex);
            return null;
        }
        catch (RuntimeException ex) {
            if (uri != null && uri.isPlatformResource()) {
                String platformString = uri.toPlatformString(true);
                URI platformPluginURI = URI.createPlatformPluginURI((String)platformString, (boolean)true);
                return this.loadGenmodel(platformPluginURI.toString(), resourceSet);
            }
            LOG.trace((Object)("Cannot load package with URI '" + resourceOrNsURI + "'"), (Throwable)ex);
            return null;
        }
    }
}

