/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.generator.model.validation;

import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelPackage;
import org.eclipse.incquery.tooling.generator.model.generatorModel.GeneratorModelReference;
import org.eclipse.incquery.tooling.generator.model.validation.AbstractGeneratorModelJavaValidator;
import org.eclipse.xtext.validation.Check;

public class GeneratorModelJavaValidator
extends AbstractGeneratorModelJavaValidator {
    private static final String OVERRIDE_MESSAGE = "The genmodel import overrides the EPackage %s from the EMF EPackage registry. Be careful as this might cause issues with the interpretative tooling.";

    @Check
    public void checkPackageOverride(GeneratorModelReference reference) {
        if (reference.getGenmodel() == null || reference.getGenmodel().getGenPackages().isEmpty()) {
            return;
        }
        EPackage.Registry registry = EPackage.Registry.INSTANCE;
        for (GenPackage genPackage : reference.getGenmodel().getGenPackages()) {
            EPackage ePackage = genPackage.getEcorePackage();
            String nsURI = ePackage.getNsURI();
            if (!registry.containsKey((Object)nsURI)) continue;
            this.warning(String.format(OVERRIDE_MESSAGE, nsURI), (EStructuralFeature)GeneratorModelPackage.Literals.GENERATOR_MODEL_REFERENCE__GENMODEL, "eiqgen.package_override", new String[0]);
        }
    }
}

