/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.generator.sampleui;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class SampleUIGenerator
implements IGenerationFragment {
    @Inject
    @Extension
    private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
    private static final String ECLIPSE_UI_COMMANDS_EXTENSION_POINT = "org.eclipse.ui.commands";
    private static final String ECLIPSE_UI_HANDLERS_EXTENSION_POINT = "org.eclipse.ui.handlers";
    private static final String ECLIPSE_UI_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";
    public static final String UI_COMMANDS_PREFIX = "generated.incquery.command.";
    public static final String UI_HANDLERS_PREFIX = "generated.incquery.handler.";
    public static final String UI_MENUS_PREFIX = "generated.incquery.menu.";

    public void generateFiles(Pattern pattern, IFileSystemAccess fsa) {
        String _handlerClassJavaFile = this.handlerClassJavaFile(pattern);
        CharSequence _patternHandler = this.patternHandler(pattern);
        fsa.generateFile(_handlerClassJavaFile, _patternHandler);
    }

    public void cleanUp(Pattern pattern, IFileSystemAccess fsa) {
        String _handlerClassJavaFile = this.handlerClassJavaFile(pattern);
        fsa.deleteFile(_handlerClassJavaFile);
    }

    public Iterable<Pair<String, String>> removeExtension(Pattern pattern) {
        String _commandExtensionId = this.commandExtensionId(pattern);
        Pair _of = Pair.of((Object)_commandExtensionId, (Object)ECLIPSE_UI_COMMANDS_EXTENSION_POINT);
        String _handlerExtensionId = this.handlerExtensionId(pattern);
        Pair _of_1 = Pair.of((Object)_handlerExtensionId, (Object)ECLIPSE_UI_HANDLERS_EXTENSION_POINT);
        String _menuExtensionId = this.menuExtensionId(pattern);
        Pair _of_2 = Pair.of((Object)_menuExtensionId, (Object)ECLIPSE_UI_MENUS_EXTENSION_POINT);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Pair[]{_of, _of_1, _of_2});
        return _newArrayList;
    }

    public Collection<Pair<String, String>> getRemovableExtensions() {
        Pair _of = Pair.of((Object)UI_COMMANDS_PREFIX, (Object)ECLIPSE_UI_COMMANDS_EXTENSION_POINT);
        Pair _of_1 = Pair.of((Object)UI_HANDLERS_PREFIX, (Object)ECLIPSE_UI_HANDLERS_EXTENSION_POINT);
        Pair _of_2 = Pair.of((Object)UI_MENUS_PREFIX, (Object)ECLIPSE_UI_MENUS_EXTENSION_POINT);
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new Pair[]{_of, _of_1, _of_2});
        return _newArrayList;
    }

    public String[] getProjectDependencies() {
        ArrayList _newArrayList = CollectionLiterals.newArrayList((Object[])new String[]{"org.eclipse.core.runtime", "org.eclipse.ui", "org.eclipse.emf.ecore", "org.eclipse.pde.core", "org.eclipse.core.resources", "org.eclipse.incquery.runtime", "org.eclipse.incquery.tooling.ui"});
        return (String[])Conversions.unwrapArray((Object)_newArrayList, String.class);
    }

    public String getProjectPostfix() {
        return "ui";
    }

    public Iterable<IPluginExtension> extensionContribution(final Pattern pattern, final ExtensionGenerator exGen) {
        ArrayList _newArrayList;
        ArrayList _xblockexpression = null;
        IPluginExtension menuContribution = this.menuContribution(pattern, exGen);
        String _commandExtensionId = this.commandExtensionId(pattern);
        Procedures.Procedure1<IPluginExtension> _function = new Procedures.Procedure1<IPluginExtension>(){

            public void apply(IPluginExtension it) {
                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                    public void apply(IPluginElement it) {
                        String _commandId = SampleUIGenerator.this.commandId(pattern);
                        exGen.contribAttribute(it, "id", _commandId);
                        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
                        String _plus = "Get All Matches for " + _fullyQualifiedName;
                        exGen.contribAttribute(it, "name", _plus);
                        exGen.contribAttribute(it, "categoryId", "org.eclipse.incquery.tooling.category");
                    }
                };
                exGen.contribElement((IPluginObject)it, "command", (Procedures.Procedure1)_function);
            }
        };
        IPluginExtension _contribExtension = exGen.contribExtension(_commandExtensionId, ECLIPSE_UI_COMMANDS_EXTENSION_POINT, (Procedures.Procedure1)_function);
        String _handlerExtensionId = this.handlerExtensionId(pattern);
        Procedures.Procedure1<IPluginExtension> _function_1 = new Procedures.Procedure1<IPluginExtension>(){

            public void apply(IPluginExtension it) {
                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                    public void apply(IPluginElement it) {
                        String _commandId = SampleUIGenerator.this.commandId(pattern);
                        exGen.contribAttribute(it, "commandId", _commandId);
                        String _handlerClassName = SampleUIGenerator.this.handlerClassName(pattern);
                        exGen.contribAttribute(it, "class", _handlerClassName);
                    }
                };
                exGen.contribElement((IPluginObject)it, "handler", (Procedures.Procedure1)_function);
            }
        };
        IPluginExtension _contribExtension_1 = exGen.contribExtension(_handlerExtensionId, ECLIPSE_UI_HANDLERS_EXTENSION_POINT, (Procedures.Procedure1)_function_1);
        _xblockexpression = _newArrayList = CollectionLiterals.newArrayList((Object[])new IPluginExtension[]{_contribExtension, _contribExtension_1, menuContribution});
        return _xblockexpression;
    }

    public IPluginExtension menuContribution(final Pattern pattern, final ExtensionGenerator exGen) {
        IPluginExtension _contribExtension;
        IPluginExtension _xblockexpression = null;
        final String fileExtension = this.handlerFileExtension(pattern);
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)fileExtension);
        if (_isNullOrEmpty) {
            String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
            String _plus = "FileExtension must be defined for Handler annotation in pattern: " + _fullyQualifiedName;
            IllegalArgumentException _illegalArgumentException = new IllegalArgumentException(_plus);
            throw _illegalArgumentException;
        }
        String _menuExtensionId = this.menuExtensionId(pattern);
        Procedures.Procedure1<IPluginExtension> _function = new Procedures.Procedure1<IPluginExtension>(){

            public void apply(IPluginExtension it) {
                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                    public void apply(IPluginElement it) {
                        exGen.contribAttribute(it, "locationURI", "popup:org.eclipse.ui.popup.any");
                        Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                            public void apply(IPluginElement it) {
                                exGen.contribAttribute(it, "label", "EMF-IncQuery");
                                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                    public void apply(IPluginElement it) {
                                        String _commandId = SampleUIGenerator.this.commandId(pattern);
                                        exGen.contribAttribute(it, "commandId", _commandId);
                                        exGen.contribAttribute(it, "style", "push");
                                        Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                            public void apply(IPluginElement it) {
                                                exGen.contribAttribute(it, "checkEnabled", "false");
                                                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                                    public void apply(IPluginElement it) {
                                                        exGen.contribAttribute(it, "variable", "selection");
                                                        Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                                            public void apply(IPluginElement it) {
                                                                exGen.contribAttribute(it, "ifEmpty", "false");
                                                                Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                                                    public void apply(IPluginElement it) {
                                                                        exGen.contribAttribute(it, "type", "org.eclipse.core.resources.IFile");
                                                                        Procedures.Procedure1<IPluginElement> _function = new Procedures.Procedure1<IPluginElement>(){

                                                                            public void apply(IPluginElement it) {
                                                                                exGen.contribAttribute(it, "property", "org.eclipse.core.resources.name");
                                                                                String _format = String.format("*.%s", fileExtension);
                                                                                exGen.contribAttribute(it, "value", _format);
                                                                            }
                                                                        };
                                                                        exGen.contribElement((IPluginObject)it, "test", (Procedures.Procedure1)_function);
                                                                    }
                                                                };
                                                                exGen.contribElement((IPluginObject)it, "adapt", (Procedures.Procedure1)_function);
                                                            }
                                                        };
                                                        exGen.contribElement((IPluginObject)it, "iterate", (Procedures.Procedure1)_function);
                                                    }
                                                };
                                                exGen.contribElement((IPluginObject)it, "with", (Procedures.Procedure1)_function);
                                            }
                                        };
                                        exGen.contribElement((IPluginObject)it, "visibleWhen", (Procedures.Procedure1)_function);
                                    }
                                };
                                exGen.contribElement((IPluginObject)it, "command", (Procedures.Procedure1)_function);
                            }
                        };
                        exGen.contribElement((IPluginObject)it, "menu", (Procedures.Procedure1)_function);
                    }
                };
                exGen.contribElement((IPluginObject)it, "menuContribution", (Procedures.Procedure1)_function);
            }
        };
        _xblockexpression = _contribExtension = exGen.contribExtension(_menuExtensionId, ECLIPSE_UI_MENUS_EXTENSION_POINT, (Procedures.Procedure1)_function);
        return _xblockexpression;
    }

    public String handlerFileExtension(Pattern pattern) {
        EList _annotations = pattern.getAnnotations();
        for (Annotation annotation : _annotations) {
            String _name = annotation.getName();
            boolean _equals = "Handler".equals(_name);
            if (!_equals) continue;
            EList _parameters = annotation.getParameters();
            for (AnnotationParameter parameter : _parameters) {
                ValueReference _value;
                String _name_1 = parameter.getName();
                boolean _equals_1 = "fileExtension".equals(_name_1);
                if (!_equals_1 || !((_value = parameter.getValue()) instanceof StringValue)) continue;
                ValueReference _value_1 = parameter.getValue();
                return ((StringValue)_value_1).getValue();
            }
        }
        return null;
    }

    public String handlerClassName(Pattern pattern) {
        String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
        String _firstUpper = StringExtensions.toFirstUpper((String)_realPatternName);
        String _format = String.format("%s.handlers.%sHandler", _packageName, _firstUpper);
        return _format;
    }

    public String handlerClassPath(Pattern pattern) {
        String _packagePath = this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern);
        String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
        String _firstUpper = StringExtensions.toFirstUpper((String)_realPatternName);
        String _format = String.format("%s/handlers/%sHandler", _packagePath, _firstUpper);
        return _format;
    }

    public String handlerClassJavaFile(Pattern pattern) {
        String _handlerClassPath = this.handlerClassPath(pattern);
        String _plus = String.valueOf(_handlerClassPath) + ".java";
        return _plus;
    }

    public String handlerExtensionId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        String _plus = UI_HANDLERS_PREFIX + _fullyQualifiedName;
        String _plus_1 = String.valueOf(_plus) + "Handler";
        return _plus_1;
    }

    public String commandExtensionId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        String _plus = UI_COMMANDS_PREFIX + _fullyQualifiedName;
        String _plus_1 = String.valueOf(_plus) + "Command";
        return _plus_1;
    }

    public String menuExtensionId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        String _plus = UI_MENUS_PREFIX + _fullyQualifiedName;
        String _plus_1 = String.valueOf(_plus) + "MenuContribution";
        return _plus_1;
    }

    public String commandId(Pattern pattern) {
        String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName((Pattern)pattern);
        String _plus = String.valueOf(_fullyQualifiedName) + "CommandId";
        return _plus;
    }

    public CharSequence patternHandler(Pattern pattern) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        _builder.append((Object)_packageName, "");
        _builder.append((Object)".handlers;");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"import java.util.Collection;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.commands.AbstractHandler;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.commands.ExecutionEvent;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.commands.ExecutionException;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.ecore.resource.Resource;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.ecore.resource.ResourceSet;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.core.resources.IFile;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.common.notify.Notifier;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.emf.common.util.URI;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.jface.dialogs.MessageDialog;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.jface.viewers.IStructuredSelection;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.swt.widgets.Display;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.ui.handlers.HandlerUtil;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.tooling.ui.dialog.SampleUIDialogCreator;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.runtime.exception.IncQueryException;");
        _builder.newLine();
        _builder.append((Object)"import org.eclipse.incquery.runtime.api.IncQueryEngine;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"import ");
        String _packageName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _plus = String.valueOf(_packageName_1) + ".";
        String _matcherClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        String _plus_1 = String.valueOf(_plus) + _matcherClassName;
        _builder.append((Object)_plus_1, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"import ");
        String _packageName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
        String _plus_2 = String.valueOf(_packageName_2) + ".";
        String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
        String _plus_3 = String.valueOf(_plus_2) + _matchClassName;
        _builder.append((Object)_plus_3, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"public class ");
        String _name = pattern.getName();
        String _firstUpper = StringExtensions.toFirstUpper((String)_name);
        String _plus_4 = String.valueOf(_firstUpper) + "Handler";
        _builder.append((Object)_plus_4, "");
        _builder.append((Object)" extends AbstractHandler {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"@Override");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public Object execute(ExecutionEvent event) throws ExecutionException {");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//returns the selected element");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"IStructuredSelection selection = (IStructuredSelection) HandlerUtil.getCurrentSelection(event);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Object firstElement = selection.getFirstElement();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//the filter is set in the command declaration no need for type checking");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"IFile file = (IFile)firstElement;");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"//Loads the resource");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"ResourceSet resourceSet = new ResourceSetImpl();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"URI fileURI = URI.createPlatformResourceURI(file.getFullPath()");
        _builder.newLine();
        _builder.append((Object)"\t\t\t\t");
        _builder.append((Object)".toString(), false);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"Resource resource = resourceSet.getResource(fileURI, true);");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"\t\t");
        String _matcherClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        _builder.append((Object)_matcherClassName_1, "\t\t");
        _builder.append((Object)" matcher;");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"try{");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"matcher = ");
        String _matcherClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
        _builder.append((Object)_matcherClassName_2, "\t\t\t");
        _builder.append((Object)".querySpecification().getMatcher(resource /* or resourceSet */);");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"} catch (IncQueryException ex) {");
        _builder.newLine();
        _builder.append((Object)"\t\t\t");
        _builder.append((Object)"throw new ExecutionException(\"Error creating pattern matcher\", ex);");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"SampleUIDialogCreator.createDialog(matcher).open();");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return null;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        _builder.append((Object)"}\t");
        _builder.newLine();
        return _builder;
    }

    public IPath[] getAdditionalBinIncludes() {
        Path _path = new Path("plugin.xml");
        return (IPath[])Conversions.unwrapArray((Object)CollectionLiterals.newArrayList((Object[])new IPath[]{_path}), IPath.class);
    }
}

