/**
 * Copyright (c) 2010-2012, Zoltan Ujhelyi, Abel Hegedus, Tamas Szabo, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Zoltan Ujhelyi, Abel Hegedus, Tamas Szabo - initial API and implementation
 */
package org.eclipse.incquery.validation.tooling;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PackageImport;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.emf.helper.EMFPatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.tooling.core.generator.ExtensionGenerator;
import org.eclipse.incquery.tooling.core.generator.builder.IErrorFeedback;
import org.eclipse.incquery.tooling.core.generator.fragments.IGenerationFragment;
import org.eclipse.incquery.tooling.core.generator.genmodel.IEiqGenmodelProvider;
import org.eclipse.incquery.tooling.core.generator.util.EMFPatternLanguageJvmModelInferrerUtil;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class ValidationGenerator implements IGenerationFragment {
  @Inject
  @Extension
  private EMFPatternLanguageJvmModelInferrerUtil _eMFPatternLanguageJvmModelInferrerUtil;
  
  @Inject
  private IEiqGenmodelProvider eiqGenModelProvider;
  
  @Inject
  private IErrorFeedback feedback;
  
  private static String VALIDATIONEXTENSION_PREFIX = "validation.constraint.";
  
  private static String UI_VALIDATION_MENUS_PREFIX = "generated.incquery.validation.menu.";
  
  private static String VALIDATION_EXTENSION_POINT = "org.eclipse.incquery.validation.runtime.constraint";
  
  private static String ECLIPSE_MENUS_EXTENSION_POINT = "org.eclipse.ui.menus";
  
  private static String annotationLiteral = "Constraint";
  
  private static String VALIDATION_ERROR_CODE = "org.eclipse.incquery.validation.error";
  
  public void generateFiles(final Pattern pattern, final IFileSystemAccess fsa) {
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
        CharSequence _patternHandler = this.patternHandler(pattern, ann);
        fsa.generateFile(_constraintClassJavaFile, _patternHandler);
      }
    }
  }
  
  public void cleanUp(final Pattern pattern, final IFileSystemAccess fsa) {
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        String _constraintClassJavaFile = this.constraintClassJavaFile(pattern, ann);
        fsa.deleteFile(_constraintClassJavaFile);
      }
    }
  }
  
  public Iterable<Pair<String,String>> removeExtension(final Pattern pattern) {
    String _constraintContributionId = this.constraintContributionId(pattern);
    final Pair<String,String> p = Pair.<String, String>of(_constraintContributionId, ValidationGenerator.VALIDATION_EXTENSION_POINT);
    final ArrayList<Pair<String,String>> extensionList = CollectionLiterals.<Pair<String,String>>newArrayList(p);
    EObject _eContainer = pattern.eContainer();
    final PatternModel patternModel = ((PatternModel) _eContainer);
    Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(patternModel);
    for (final PackageImport imp : _packageImportsIterable) {
      {
        final EPackage pack = imp.getEPackage();
        final GenPackage genPackage = this.eiqGenModelProvider.findGenPackage(pattern, pack);
        boolean _notEquals = (!Objects.equal(genPackage, null));
        if (_notEquals) {
          String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
          final String editorId = (_qualifiedEditorClassName + "ID");
          boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(editorId);
          boolean _not = (!_isNullOrEmpty);
          if (_not) {
            String _menuContributionId = this.menuContributionId(editorId);
            Pair<String,String> _of = Pair.<String, String>of(_menuContributionId, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
            extensionList.add(_of);
          }
        }
      }
    }
    EList<Annotation> _annotations = pattern.getAnnotations();
    for (final Annotation ann : _annotations) {
      String _name = ann.getName();
      boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
      if (_equals) {
        final ArrayList<ValueReference> editorIds = this.getAnnotationParameterValue(ann, "targetEditorId");
        for (final ValueReference id : editorIds) {
          {
            final String editorId = ((StringValue) id).getValue();
            String _menuContributionId = this.menuContributionId(editorId);
            Pair<String,String> _of = Pair.<String, String>of(_menuContributionId, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
            extensionList.add(_of);
          }
        }
      }
    }
    return extensionList;
  }
  
  public Collection<Pair<String,String>> getRemovableExtensions() {
    Pair<String,String> _of = Pair.<String, String>of(ValidationGenerator.VALIDATIONEXTENSION_PREFIX, ValidationGenerator.VALIDATION_EXTENSION_POINT);
    Pair<String,String> _of_1 = Pair.<String, String>of(ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, ValidationGenerator.ECLIPSE_MENUS_EXTENSION_POINT);
    ArrayList<Pair<String,String>> _newArrayList = CollectionLiterals.<Pair<String,String>>newArrayList(_of, _of_1);
    return _newArrayList;
  }
  
  public String[] getProjectDependencies() {
    ArrayList<String> _newArrayList = CollectionLiterals.<String>newArrayList("org.eclipse.incquery.runtime", 
      "org.eclipse.incquery.validation.runtime");
    return ((String[])Conversions.unwrapArray(_newArrayList, String.class));
  }
  
  public String getProjectPostfix() {
    return "validation";
  }
  
  public Iterable<IPluginExtension> extensionContribution(final Pattern pattern, final ExtensionGenerator exGen) {
    String _constraintContributionId = this.constraintContributionId(pattern);
    final Procedure1<IPluginExtension> _function = new Procedure1<IPluginExtension>() {
      public void apply(final IPluginExtension it) {
        EList<Annotation> _annotations = pattern.getAnnotations();
        for (final Annotation ann : _annotations) {
          String _name = ann.getName();
          boolean _equals = Objects.equal(_name, ValidationGenerator.annotationLiteral);
          if (_equals) {
            final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
              public void apply(final IPluginElement it) {
                String _constraintClassName = ValidationGenerator.this.constraintClassName(pattern, ann);
                exGen.contribAttribute(it, "class", _constraintClassName);
                String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
                exGen.contribAttribute(it, "name", _fullyQualifiedName);
                final ArrayList<ValueReference> editorIds = ValidationGenerator.this.getAnnotationParameterValue(ann, "targetEditorId");
                for (final ValueReference id : editorIds) {
                  {
                    final String editorId = ((StringValue) id).getValue();
                    final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
                      public void apply(final IPluginElement it) {
                        exGen.contribAttribute(it, "editorId", editorId);
                      }
                    };
                    exGen.contribElement(it, "enabledForEditor", _function);
                  }
                }
                EObject _eContainer = pattern.eContainer();
                final PatternModel patternModel = ((PatternModel) _eContainer);
                Iterable<PackageImport> _packageImportsIterable = EMFPatternLanguageHelper.getPackageImportsIterable(patternModel);
                for (final PackageImport imp : _packageImportsIterable) {
                  {
                    final EPackage pack = imp.getEPackage();
                    final GenPackage genPackage = ValidationGenerator.this.eiqGenModelProvider.findGenPackage(pattern, pack);
                    boolean _notEquals = (!Objects.equal(genPackage, null));
                    if (_notEquals) {
                      String _qualifiedEditorClassName = genPackage.getQualifiedEditorClassName();
                      final String editorId = (_qualifiedEditorClassName + "ID");
                      final Procedure1<IPluginElement> _function = new Procedure1<IPluginElement>() {
                        public void apply(final IPluginElement it) {
                          exGen.contribAttribute(it, "editorId", editorId);
                        }
                      };
                      exGen.contribElement(it, "enabledForEditor", _function);
                    }
                  }
                }
              }
            };
            exGen.contribElement(it, "constraint", _function);
          }
        }
      }
    };
    IPluginExtension _contribExtension = exGen.contribExtension(_constraintContributionId, ValidationGenerator.VALIDATION_EXTENSION_POINT, _function);
    final ArrayList<IPluginExtension> extensionList = CollectionLiterals.<IPluginExtension>newArrayList(_contribExtension);
    return extensionList;
  }
  
  public String constraintClassName(final Pattern pattern, final Annotation annotation) {
    String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    EList<Annotation> _annotations = pattern.getAnnotations();
    int _indexOf = _annotations.indexOf(annotation);
    String _format = String.format("%s.%s%s%s", _packageName, _firstUpper, ValidationGenerator.annotationLiteral, Integer.valueOf(_indexOf));
    return _format;
  }
  
  public String constraintClassPath(final Pattern pattern, final Annotation annotation) {
    String _packagePath = this._eMFPatternLanguageJvmModelInferrerUtil.getPackagePath(pattern);
    String _realPatternName = this._eMFPatternLanguageJvmModelInferrerUtil.realPatternName(pattern);
    String _firstUpper = StringExtensions.toFirstUpper(_realPatternName);
    EList<Annotation> _annotations = pattern.getAnnotations();
    int _indexOf = _annotations.indexOf(annotation);
    String _format = String.format("%s/%s%s%s", _packagePath, _firstUpper, ValidationGenerator.annotationLiteral, Integer.valueOf(_indexOf));
    return _format;
  }
  
  public String constraintClassJavaFile(final Pattern pattern, final Annotation annotation) {
    String _constraintClassPath = this.constraintClassPath(pattern, annotation);
    String _plus = (_constraintClassPath + ".java");
    return _plus;
  }
  
  public String constraintContributionId(final Pattern pattern) {
    String _fullyQualifiedName = CorePatternLanguageHelper.getFullyQualifiedName(pattern);
    return (ValidationGenerator.VALIDATIONEXTENSION_PREFIX + _fullyQualifiedName);
  }
  
  public String menuContributionId(final String editorId) {
    return String.format("%s%s", ValidationGenerator.UI_VALIDATION_MENUS_PREFIX, editorId);
  }
  
  public String getElementOfConstraintAnnotation(final Annotation annotation, final String elementName) {
    final ValueReference ap = CorePatternLanguageHelper.getFirstAnnotationParameter(annotation, elementName);
    String _switchResult = null;
    boolean _matched = false;
    if (!_matched) {
      if (ap instanceof StringValue) {
        if (true) {
          _matched=true;
          String _value = ((StringValue)ap).getValue();
          _switchResult = _value;
        }
      }
    }
    if (!_matched) {
      if (ap instanceof VariableValue) {
        if (true) {
          _matched=true;
          VariableReference _value = ((VariableValue)ap).getValue();
          String _var = _value.getVar();
          _switchResult = _var;
        }
      }
    }
    if (!_matched) {
      _switchResult = null;
    }
    return _switchResult;
  }
  
  public ArrayList<ValueReference> getAnnotationParameterValue(final Annotation annotation, final String elementName) {
    final ArrayList<ValueReference> values = CollectionLiterals.<ValueReference>newArrayList();
    EList<AnnotationParameter> _parameters = annotation.getParameters();
    for (final AnnotationParameter ap : _parameters) {
      String _name = ap.getName();
      boolean _matches = _name.matches(elementName);
      if (_matches) {
        ValueReference _value = ap.getValue();
        values.add(_value);
      }
    }
    return values;
  }
  
  public CharSequence patternHandler(final Pattern pattern, final Annotation annotation) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("package ");
    String _packageName = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    _builder.append(_packageName, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("import org.eclipse.emf.ecore.EObject;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.validation.runtime.Constraint;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.validation.runtime.ValidationUtil;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.runtime.api.impl.BaseGeneratedQuerySpecification;");
    _builder.newLine();
    _builder.append("import org.eclipse.incquery.runtime.exception.IncQueryException;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("import ");
    String _packageName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _plus = (_packageName_1 + ".");
    String _matchClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
    String _plus_1 = (_plus + _matchClassName);
    _builder.append(_plus_1, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("import ");
    String _utilPackageName = this._eMFPatternLanguageJvmModelInferrerUtil.getUtilPackageName(pattern);
    String _plus_2 = (_utilPackageName + ".");
    String _querySpecificationClassName = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    String _plus_3 = (_plus_2 + _querySpecificationClassName);
    _builder.append(_plus_3, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.append("import ");
    String _packageName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.getPackageName(pattern);
    String _plus_4 = (_packageName_2 + ".");
    String _matcherClassName = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    String _plus_5 = (_plus_4 + _matcherClassName);
    _builder.append(_plus_5, "");
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("public class ");
    String _name = pattern.getName();
    String _firstUpper = StringExtensions.toFirstUpper(_name);
    _builder.append(_firstUpper, "");
    _builder.append(ValidationGenerator.annotationLiteral, "");
    EList<Annotation> _annotations = pattern.getAnnotations();
    int _indexOf = _annotations.indexOf(annotation);
    _builder.append(_indexOf, "");
    _builder.append(" extends ");
    _builder.append(ValidationGenerator.annotationLiteral, "");
    _builder.append("<");
    String _matchClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
    _builder.append(_matchClassName_1, "");
    _builder.append("> {");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("private ");
    String _querySpecificationClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    _builder.append(_querySpecificationClassName_1, "	");
    _builder.append(" querySpecification;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public ");
    String _name_1 = pattern.getName();
    String _firstUpper_1 = StringExtensions.toFirstUpper(_name_1);
    _builder.append(_firstUpper_1, "	");
    _builder.append(ValidationGenerator.annotationLiteral, "	");
    EList<Annotation> _annotations_1 = pattern.getAnnotations();
    int _indexOf_1 = _annotations_1.indexOf(annotation);
    _builder.append(_indexOf_1, "	");
    _builder.append("() throws IncQueryException {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("querySpecification = ");
    String _querySpecificationClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.querySpecificationClassName(pattern);
    _builder.append(_querySpecificationClassName_2, "		");
    _builder.append(".instance();");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public String getMessage() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return \"");
    String _elementOfConstraintAnnotation = this.getElementOfConstraintAnnotation(annotation, "message");
    String _convertToJavaString = Strings.convertToJavaString(_elementOfConstraintAnnotation);
    _builder.append(_convertToJavaString, "		");
    _builder.append("\";");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public EObject getLocationObject(");
    String _matchClassName_2 = this._eMFPatternLanguageJvmModelInferrerUtil.matchClassName(pattern);
    _builder.append(_matchClassName_2, "	");
    _builder.append(" signature) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("Object location = signature.get(\"");
    String _xblockexpression = null;
    {
      final String loc = this.getElementOfConstraintAnnotation(annotation, "location");
      Map<String,Integer> _parameterPositionsByName = CorePatternLanguageHelper.getParameterPositionsByName(pattern);
      boolean _containsKey = _parameterPositionsByName.containsKey(loc);
      boolean _not = (!_containsKey);
      if (_not) {
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Location \'");
        _builder_1.append(loc, "");
        _builder_1.append("\' is not a valid parameter name!");
        this.feedback.reportError(annotation, _builder_1.toString(), ValidationGenerator.VALIDATION_ERROR_CODE, Severity.ERROR, IErrorFeedback.FRAGMENT_ERROR_TYPE);
      }
      _xblockexpression = (loc);
    }
    _builder.append(_xblockexpression, "		");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("if(location instanceof EObject){");
    _builder.newLine();
    _builder.append("\t\t\t");
    _builder.append("return (EObject) location;");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return null;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public int getSeverity() {");
    _builder.newLine();
    _builder.append("\t\t");
    _builder.append("return ValidationUtil.getSeverity(\"");
    String _elementOfConstraintAnnotation_1 = this.getElementOfConstraintAnnotation(annotation, "severity");
    _builder.append(_elementOfConstraintAnnotation_1, "		");
    _builder.append("\");");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("@Override");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("public BaseGeneratedQuerySpecification<");
    String _matcherClassName_1 = this._eMFPatternLanguageJvmModelInferrerUtil.matcherClassName(pattern);
    _builder.append(_matcherClassName_1, "	");
    _builder.append("> getQuerySpecification() {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t");
    _builder.append("return querySpecification;");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("}");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder;
  }
  
  public IPath[] getAdditionalBinIncludes() {
    Path _path = new Path("plugin.xml");
    return ((IPath[])Conversions.unwrapArray(CollectionLiterals.<IPath>newArrayList(_path), IPath.class));
  }
}
