/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.xcore.validation;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.ClassType;
import org.eclipse.incquery.patternlanguage.patternLanguage.Type;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.xcore.XIncQueryDerivedFeature;
import org.eclipse.incquery.xcore.XcorePackage;
import org.eclipse.incquery.xcore.validation.AbstractIncQueryXcoreJavaValidator;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.validation.Check;

public class IncQueryXcoreJavaValidator
extends AbstractIncQueryXcoreJavaValidator {
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    @Check
    public void checkIncQueryDerivedFeature(XIncQueryDerivedFeature feature) {
        if (feature.getPattern() == null) {
            this.acceptError("The pattern reference must not be null!", (EObject)feature, (EStructuralFeature)XcorePackage.Literals.XINC_QUERY_DERIVED_FEATURE__PATTERN, -1, null, new String[0]);
        } else if (feature.getPattern().getParameters().size() != 2) {
            this.acceptError("The referenced pattern must have exactly two parameters!", (EObject)feature, (EStructuralFeature)XcorePackage.Literals.XINC_QUERY_DERIVED_FEATURE__PATTERN, -1, null, new String[0]);
        } else {
            Type p1Type = ((Variable)feature.getPattern().getParameters().get(0)).getType();
            Type p2Type = ((Variable)feature.getPattern().getParameters().get(1)).getType();
            QualifiedName p1TypeName = null;
            if (p1Type != null) {
                p1TypeName = p1Type instanceof ClassType ? this.qualifiedNameProvider.getFullyQualifiedName((EObject)((ClassType)p1Type).getClassname()) : this.qualifiedNameProvider.getFullyQualifiedName((EObject)p1Type);
            }
            QualifiedName p2TypeName = null;
            if (p2Type != null) {
                p2TypeName = p2Type instanceof ClassType ? this.qualifiedNameProvider.getFullyQualifiedName((EObject)((ClassType)p2Type).getClassname()) : this.qualifiedNameProvider.getFullyQualifiedName((EObject)p2Type);
            }
            QualifiedName featureTypeName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)feature.getType().getType());
            QualifiedName classTypeName = this.qualifiedNameProvider.getFullyQualifiedName(feature.eContainer());
            if (!p1TypeName.toString().equals(classTypeName.toString()) || p2TypeName != null && !p2TypeName.toString().equals(featureTypeName.toString())) {
                this.acceptError("A pattern with parameters (" + classTypeName.toString() + ", " + featureTypeName.toString() + ") can be used in this context!", (EObject)feature, (EStructuralFeature)XcorePackage.Literals.XINC_QUERY_DERIVED_FEATURE__PATTERN, -1, null, new String[0]);
            }
        }
    }
}

