/*******************************************************************************
 * Copyright (c) 2010-2014, Zoltan Ujhelyi, Istvan Rath and Daniel Varro
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   Zoltan Ujhelyi - initial API and implementation
 *******************************************************************************/
package org.eclipse.incquery.runtime.matchers.psystem.basicenumerables;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.incquery.runtime.matchers.psystem.ITypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.KeyedEnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.TypeJudgement;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

/**
 * Represents an enumerable type constraint that asserts that values substituted for the given tuple of variables 
 * 	form a tuple that belongs to an enumerable extensional relation identified by an {@link IInputKey}.
 *
 * <p> The InputKey must be enumerable!
 *
 * @author Zoltan Ujhelyi
 *
 */
public class TypeConstraint extends KeyedEnumerablePConstraint<IInputKey> implements ITypeConstraint {
    
	private TypeJudgement equivalentJudgement;
	
    public TypeConstraint(PBody pSystem, Tuple variablesTuple, IInputKey inputKey) {
        super(pSystem, variablesTuple, inputKey);
        this.equivalentJudgement = new TypeJudgement(inputKey, variablesTuple);
        
        if (! inputKey.isEnumerable())
        	throw new IllegalArgumentException(
        			this.getClass().getSimpleName() + 
        			" applicable for enumerable input keys only; received instead " + 
        					inputKey);
        if (variablesTuple.getSize() != inputKey.getArity())
        	throw new IllegalArgumentException(
        			this.getClass().getSimpleName() + 
        			" applied for variable tuple " + variablesTuple + " having wrong arity for input key " + 
        					inputKey);
    }

    @Override
    protected String keyToString() {
        return supplierKey.getPrettyPrintableName();
    }
    
    @Override
	public TypeJudgement getEquivalentJudgement() {
		return equivalentJudgement;
	}

	@Override
	public Set<TypeJudgement> getImpliedJudgements(IQueryMetaContext context) {
		return Collections.singleton(equivalentJudgement);
		//return equivalentJudgement.getDirectlyImpliedJudgements(context);
	}
	
	@Override
    public Map<Set<PVariable>, Set<PVariable>> getFunctionalDependencies(IQueryMetaContext context) {
		return TypeConstraintUtil.getFunctionalDependencies(context, supplierKey, variablesTuple);
    }


}