/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.rewriters;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.context.IInputKey;
import org.eclipse.incquery.runtime.matchers.psystem.EnumerablePConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExpressionEvaluation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Inequality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.NegativePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternCallBasedDeferred;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.PatternMatchCounter;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.TypeFilterConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.BinaryTransitiveClosure;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IConstraintFilter;
import org.eclipse.incquery.runtime.matchers.psystem.rewriters.IVariableRenamer;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;

public class PBodyCopier {
    protected PBody body;
    protected Map<PVariable, PVariable> variableMapping = Maps.newHashMap();

    public Map<PVariable, PVariable> getVariableMapping() {
        return this.variableMapping;
    }

    public PBodyCopier(PBody body) {
        this.body = new PBody(body.getPattern());
        this.mergeBody(body);
    }

    public PBodyCopier(PQuery query) {
        this.body = new PBody(query);
    }

    public void mergeBody(PBody sourceBody) {
        this.mergeBody(sourceBody, new IVariableRenamer.SameName(), new IConstraintFilter.AllowAllFilter());
    }

    public void mergeBody(PBody sourceBody, IVariableRenamer namingTool, IConstraintFilter filter) {
        Set<PVariable> allVariables = sourceBody.getAllVariables();
        for (PVariable pVariable : allVariables) {
            if (!pVariable.isUnique()) continue;
            this.copyVariable(pVariable, namingTool.createVariableName(pVariable, sourceBody.getPattern()));
        }
        this.body.setSymbolicParameters(Lists.transform(sourceBody.getSymbolicParameters(), (Function)new Function<ExportedParameter, ExportedParameter>(){

            public ExportedParameter apply(ExportedParameter input) {
                return PBodyCopier.this.copyExportedParameterConstraint(input);
            }
        }));
        Set<PConstraint> constraints = sourceBody.getConstraints();
        for (PConstraint pConstraint : constraints) {
            if (pConstraint instanceof ExportedParameter || filter.filter(pConstraint)) continue;
            this.copyConstraint(pConstraint);
        }
    }

    protected void copyVariable(PVariable variable, String newName) {
        PVariable newPVariable = this.body.getOrCreateVariableByName(newName);
        this.variableMapping.put(variable, newPVariable);
    }

    public PBody getCopiedBody() {
        return this.body;
    }

    protected void copyConstraint(PConstraint constraint) {
        if (constraint instanceof ExportedParameter) {
            this.copyExportedParameterConstraint((ExportedParameter)constraint);
        } else if (constraint instanceof Equality) {
            this.copyEqualityConstraint((Equality)constraint);
        } else if (constraint instanceof Inequality) {
            this.copyInequalityConstraint((Inequality)constraint);
        } else if (constraint instanceof TypeConstraint) {
            this.copyTypeConstraint((TypeConstraint)constraint);
        } else if (constraint instanceof TypeFilterConstraint) {
            this.copyTypeFilterConstraint((TypeFilterConstraint)constraint);
        } else if (constraint instanceof ConstantValue) {
            this.copyConstantValueConstraint((ConstantValue)constraint);
        } else if (constraint instanceof PositivePatternCall) {
            this.copyPositivePatternCallConstraint((PositivePatternCall)constraint);
        } else if (constraint instanceof NegativePatternCall) {
            this.copyNegativePatternCallConstraint((NegativePatternCall)constraint);
        } else if (constraint instanceof BinaryTransitiveClosure) {
            this.copyBinaryTransitiveClosureConstraint((BinaryTransitiveClosure)constraint);
        } else if (constraint instanceof PatternMatchCounter) {
            this.copyPatternMatchCounterConstraint((PatternMatchCounter)constraint);
        } else if (constraint instanceof ExpressionEvaluation) {
            this.copyExpressionEvaluationConstraint((ExpressionEvaluation)constraint);
        } else {
            throw new RuntimeException("Unknown PConstraint encountered while copying PBody: " + constraint.getClass().getName());
        }
    }

    protected ExportedParameter copyExportedParameterConstraint(ExportedParameter exportedParameter) {
        PVariable mappedPVariable = this.variableMapping.get(exportedParameter.getParameterVariable());
        ExportedParameter newExportedParameter = new ExportedParameter(this.body, mappedPVariable, exportedParameter.getParameterName());
        this.body.getSymbolicParameters().add(newExportedParameter);
        return newExportedParameter;
    }

    protected void copyEqualityConstraint(Equality equality) {
        PVariable who = equality.getWho();
        PVariable withWhom = equality.getWithWhom();
        new Equality(this.body, this.variableMapping.get(who), this.variableMapping.get(withWhom));
    }

    protected void copyInequalityConstraint(Inequality inequality) {
        PVariable who = inequality.getWho();
        PVariable withWhom = inequality.getWithWhom();
        new Inequality(this.body, this.variableMapping.get(who), this.variableMapping.get(withWhom));
    }

    protected void copyTypeConstraint(TypeConstraint typeConstraint) {
        Object[] mappedVariables = this.extractMappedVariables(typeConstraint);
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new TypeConstraint(this.body, (Tuple)variablesTuple, (IInputKey)typeConstraint.getSupplierKey());
    }

    protected void copyTypeFilterConstraint(TypeFilterConstraint typeConstraint) {
        Object[] mappedVariables = this.extractMappedVariables(typeConstraint);
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new TypeFilterConstraint(this.body, variablesTuple, typeConstraint.getInputKey());
    }

    protected void copyConstantValueConstraint(ConstantValue constantValue) {
        PVariable pVariable = (PVariable)constantValue.getVariablesTuple().getElements()[0];
        new ConstantValue(this.body, this.variableMapping.get(pVariable), constantValue.getSupplierKey());
    }

    protected void copyPositivePatternCallConstraint(PositivePatternCall positivePatternCall) {
        Object[] mappedVariables = this.extractMappedVariables(positivePatternCall);
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new PositivePatternCall(this.body, (Tuple)variablesTuple, positivePatternCall.getReferredQuery());
    }

    protected void copyNegativePatternCallConstraint(NegativePatternCall negativePatternCall) {
        Object[] mappedVariables = this.extractMappedVariables(negativePatternCall);
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new NegativePatternCall(this.body, variablesTuple, negativePatternCall.getReferredQuery());
    }

    protected void copyBinaryTransitiveClosureConstraint(BinaryTransitiveClosure binaryTransitiveClosure) {
        Object[] mappedVariables = this.extractMappedVariables(binaryTransitiveClosure);
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new BinaryTransitiveClosure(this.body, (Tuple)variablesTuple, binaryTransitiveClosure.getReferredQuery());
    }

    protected void copyPatternMatchCounterConstraint(PatternMatchCounter patternMatchCounter) {
        Object[] mappedVariables = this.extractMappedVariables(patternMatchCounter);
        PVariable mappedResultVariable = this.variableMapping.get(patternMatchCounter.getResultVariable());
        FlatTuple variablesTuple = new FlatTuple(mappedVariables);
        new PatternMatchCounter(this.body, (Tuple)variablesTuple, patternMatchCounter.getReferredQuery(), mappedResultVariable);
    }

    protected void copyExpressionEvaluationConstraint(ExpressionEvaluation expressionEvaluation) {
        PVariable mappedOutputVariable = this.variableMapping.get(expressionEvaluation.getOutputVariable());
        new ExpressionEvaluation(this.body, expressionEvaluation.getEvaluator(), mappedOutputVariable);
    }

    protected PVariable[] extractMappedVariables(EnumerablePConstraint enumerablePConstraint) {
        Object[] pVariables = enumerablePConstraint.getVariablesTuple().getElements();
        return this.mapVariableList(pVariables);
    }

    private PVariable[] extractMappedVariables(PatternCallBasedDeferred patternCallBasedDeferred) {
        Object[] pVariables = patternCallBasedDeferred.getActualParametersTuple().getElements();
        return this.mapVariableList(pVariables);
    }

    private PVariable[] extractMappedVariables(TypeFilterConstraint typeFilterConstraint) {
        Object[] pVariables = typeFilterConstraint.getVariablesTuple().getElements();
        return this.mapVariableList(pVariables);
    }

    private PVariable[] mapVariableList(Object[] pVariables) {
        ArrayList<PVariable> list = new ArrayList<PVariable>();
        int i = 0;
        while (i < pVariables.length) {
            PVariable mappedVariable = this.variableMapping.get(pVariables[i]);
            list.add(mappedVariable);
            ++i;
        }
        return list.toArray(new PVariable[0]);
    }
}

