/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.boundary;

import org.eclipse.incquery.runtime.matchers.context.IPatternMatcherRuntimeContext;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.rete.boundary.InputConnector;
import org.eclipse.incquery.runtime.rete.network.Direction;
import org.eclipse.incquery.runtime.rete.network.Network;
import org.eclipse.incquery.runtime.rete.network.Receiver;
import org.eclipse.incquery.runtime.rete.remote.Address;

public abstract class Feeder {
    protected Address<? extends Receiver> receiver;
    protected IPatternMatcherRuntimeContext context;
    protected Network network;
    protected InputConnector inputConnector;

    public Feeder(Address<? extends Receiver> receiver, InputConnector inputConnector) {
        this.receiver = receiver;
        this.inputConnector = inputConnector;
        this.network = inputConnector.getNetwork();
        this.context = inputConnector.getNetwork().getContext();
    }

    public abstract void feed();

    protected void emit(Tuple tuple) {
        this.network.sendConstructionUpdate(this.receiver, Direction.INSERT, tuple);
    }

    protected IPatternMatcherRuntimeContext.ModelElementCrawler unaryCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementCrawler(){

            public void crawl(Object element) {
                Feeder.this.emit((Tuple)new FlatTuple(new Object[]{Feeder.this.inputConnector.wrapElement(element)}));
            }
        };
    }

    protected IPatternMatcherRuntimeContext.ModelElementPairCrawler pairCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementPairCrawler(){

            public void crawl(Object first, Object second) {
                Feeder.this.emit((Tuple)new FlatTuple(new Object[]{Feeder.this.inputConnector.wrapElement(first), Feeder.this.inputConnector.wrapElement(second)}));
            }
        };
    }

    protected IPatternMatcherRuntimeContext.ModelElementCrawler ternaryCrawler() {
        return new IPatternMatcherRuntimeContext.ModelElementCrawler(){

            public void crawl(Object element) {
                Object relation = element;
                Object from = Feeder.this.context.ternaryEdgeSource(relation);
                Object to = Feeder.this.context.ternaryEdgeTarget(relation);
                Feeder.this.emit((Tuple)new FlatTuple(new Object[]{Feeder.this.inputConnector.wrapElement(relation), Feeder.this.inputConnector.wrapElement(from), Feeder.this.inputConnector.wrapElement(to)}));
            }
        };
    }
}

