/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.ui.wizards;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SelectIncQueryProjectPage
extends WizardPage {
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private IStructuredSelection selection;
    private TableViewer viewer;
    private Logger logger;

    public SelectIncQueryProjectPage(String title, IStructuredSelection selection, Logger logger) {
        super("wizardPage");
        this.selection = selection;
        this.logger = logger;
        this.setTitle(title);
        this.setDescription("Select an EMF-IncQuery project without an EMF-IncQuery Generator model");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new FillLayout(256));
        Table table = this.formToolkit.createTable(container, 0);
        this.formToolkit.paintBordersFor((Composite)table);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.viewer = new TableViewer(table);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        TableViewerColumn column = new TableViewerColumn(this.viewer, 16384);
        column.setLabelProvider((CellLabelProvider)new ProjectColumnLabelProvider(parent.getDisplay().getSystemColor(15)));
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IProject) {
                    try {
                        IProject project = (IProject)element;
                        return project.exists() && project.isOpen() && project.hasNature("org.eclipse.incquery.projectnature");
                    }
                    catch (CoreException e) {
                        SelectIncQueryProjectPage.this.logger.error((Object)"Error while filtering project list", (Throwable)e);
                    }
                }
                return false;
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectIncQueryProjectPage.this.getContainer().getCurrentPage() != null) {
                    SelectIncQueryProjectPage.this.getContainer().updateButtons();
                }
            }
        });
        this.viewer.setInput((Object)root.getProjects());
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        for (Object obj : this.selection) {
            IResource adaptedResource;
            if (obj instanceof IResource) {
                IProject containerProject = ((IResource)obj).getProject();
                this.setSelectedProject(this.viewer, containerProject);
                continue;
            }
            if (!(obj instanceof IAdaptable) || (adaptedResource = (IResource)((IAdaptable)obj).getAdapter(IResource.class)) == null) continue;
            this.setSelectedProject(this.viewer, adaptedResource.getProject());
        }
    }

    private void setSelectedProject(TableViewer viewer, IProject containerProject) {
        try {
            if (containerProject.hasNature("org.eclipse.incquery.projectnature")) {
                viewer.setSelection((ISelection)new StructuredSelection((Object)containerProject));
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)("Error while selecting project " + containerProject.getName()), (Throwable)e);
        }
    }

    public IProject getSelectedProject() {
        if (!this.viewer.getSelection().isEmpty()) {
            return (IProject)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        }
        return null;
    }

    public boolean isPageComplete() {
        return !this.viewer.getSelection().isEmpty() && this.getSelectedProject().findMember("generator.eiqgen") == null;
    }

    private static final class ProjectColumnLabelProvider
    extends ColumnLabelProvider {
        private Color disabledColor;

        public ProjectColumnLabelProvider(Color disabledColor) {
            this.disabledColor = disabledColor;
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return super.getText(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof IProject && ((IProject)element).findMember("generator.eiqgen") != null) {
                return this.disabledColor;
            }
            return super.getForeground(element);
        }

        public String getToolTipText(Object element) {
            if (element instanceof IProject && ((IProject)element).findMember("generator.eiqgen") != null) {
                return String.format("Project %s has already defined an EMF-IncQuery Generator model.", ((IProject)element).getName());
            }
            return super.getToolTipText(element);
        }
    }
}

