package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Arrays;
import java.util.List;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.impl.BasePatternMatch;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.util.ClassifierParentsQuerySpecification;
import org.eclipse.uml2.uml.Classifier;

/**
 * Pattern-specific match representation of the org.eclipse.incquery.uml.derivedfeatures.classifierParents pattern,
 * to be used in conjunction with {@link ClassifierParentsMatcher}.
 * 
 * <p>Class fields correspond to parameters of the pattern. Fields with value null are considered unassigned.
 * Each instance is a (possibly partial) substitution of pattern parameters,
 * usable to represent a match of the pattern in the result of a query,
 * or to specify the bound (fixed) input parameters when issuing a query.
 * 
 * @see ClassifierParentsMatcher
 * @see ClassifierParentsProcessor
 * 
 */
@SuppressWarnings("all")
public abstract class ClassifierParentsMatch extends BasePatternMatch {
  private Classifier fSelf;
  
  private Classifier fClassifier;
  
  private static List<String> parameterNames = makeImmutableList("self", "classifier");
  
  private ClassifierParentsMatch(final Classifier pSelf, final Classifier pClassifier) {
    this.fSelf = pSelf;
    this.fClassifier = pClassifier;
  }
  
  @Override
  public Object get(final String parameterName) {
    if ("self".equals(parameterName)) return this.fSelf;
    if ("classifier".equals(parameterName)) return this.fClassifier;
    return null;
  }
  
  public Classifier getSelf() {
    return this.fSelf;
  }
  
  public Classifier getClassifier() {
    return this.fClassifier;
  }
  
  @Override
  public boolean set(final String parameterName, final Object newValue) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    if ("self".equals(parameterName) ) {
    	this.fSelf = (org.eclipse.uml2.uml.Classifier) newValue;
    	return true;
    }
    if ("classifier".equals(parameterName) ) {
    	this.fClassifier = (org.eclipse.uml2.uml.Classifier) newValue;
    	return true;
    }
    return false;
  }
  
  public void setSelf(final Classifier pSelf) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fSelf = pSelf;
  }
  
  public void setClassifier(final Classifier pClassifier) {
    if (!isMutable()) throw new java.lang.UnsupportedOperationException();
    this.fClassifier = pClassifier;
  }
  
  @Override
  public String patternName() {
    return "org.eclipse.incquery.uml.derivedfeatures.classifierParents";
  }
  
  @Override
  public List<String> parameterNames() {
    return ClassifierParentsMatch.parameterNames;
  }
  
  @Override
  public Object[] toArray() {
    return new Object[]{fSelf, fClassifier};
  }
  
  @Override
  public ClassifierParentsMatch toImmutable() {
    return isMutable() ? newMatch(fSelf, fClassifier) : this;
  }
  
  @Override
  public String prettyPrint() {
    StringBuilder result = new StringBuilder();
    result.append("\"self\"=" + prettyPrintValue(fSelf) + ", ");
    
    result.append("\"classifier\"=" + prettyPrintValue(fClassifier)
    );
    return result.toString();
  }
  
  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((fSelf == null) ? 0 : fSelf.hashCode());
    result = prime * result + ((fClassifier == null) ? 0 : fClassifier.hashCode());
    return result;
  }
  
  @Override
  public boolean equals(final Object obj) {
    if (this == obj)
    	return true;
    if (!(obj instanceof ClassifierParentsMatch)) { // this should be infrequent
    	if (obj == null) {
    		return false;
    	}
    	if (!(obj instanceof IPatternMatch)) {
    		return false;
    	}
    	IPatternMatch otherSig  = (IPatternMatch) obj;
    	if (!specification().equals(otherSig.specification()))
    		return false;
    	return Arrays.deepEquals(toArray(), otherSig.toArray());
    }
    ClassifierParentsMatch other = (ClassifierParentsMatch) obj;
    if (fSelf == null) {if (other.fSelf != null) return false;}
    else if (!fSelf.equals(other.fSelf)) return false;
    if (fClassifier == null) {if (other.fClassifier != null) return false;}
    else if (!fClassifier.equals(other.fClassifier)) return false;
    return true;
  }
  
  @Override
  public ClassifierParentsQuerySpecification specification() {
    try {
    	return ClassifierParentsQuerySpecification.instance();
    } catch (IncQueryException ex) {
     	// This cannot happen, as the match object can only be instantiated if the query specification exists
     	throw new IllegalStateException (ex);
    }
  }
  
  /**
   * Returns an empty, mutable match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @return the empty match.
   * 
   */
  public static ClassifierParentsMatch newEmptyMatch() {
    return new Mutable(null, null);
  }
  
  /**
   * Returns a mutable (partial) match.
   * Fields of the mutable match can be filled to create a partial match, usable as matcher input.
   * 
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return the new, mutable (partial) match object.
   * 
   */
  public static ClassifierParentsMatch newMutableMatch(final Classifier pSelf, final Classifier pClassifier) {
    return new Mutable(pSelf, pClassifier);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pClassifier the fixed value of pattern parameter classifier, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public static ClassifierParentsMatch newMatch(final Classifier pSelf, final Classifier pClassifier) {
    return new Immutable(pSelf, pClassifier);
  }
  
  private static final class Mutable extends ClassifierParentsMatch {
    Mutable(final Classifier pSelf, final Classifier pClassifier) {
      super(pSelf, pClassifier);
    }
    
    @Override
    public boolean isMutable() {
      return true;
    }
  }
  
  private static final class Immutable extends ClassifierParentsMatch {
    Immutable(final Classifier pSelf, final Classifier pClassifier) {
      super(pSelf, pClassifier);
    }
    
    @Override
    public boolean isMutable() {
      return false;
    }
  }
}
