package org.eclipse.incquery.uml.derivedfeatures;

import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedPatternGroup;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.uml.derivedfeatures.ConnectorKindMatcher;
import org.eclipse.incquery.uml.derivedfeatures.MessageMessageKindMatcher;
import org.eclipse.incquery.uml.derivedfeatures.PackageNestedPackageMatcher;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedStereotypeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.PackageOwnedTypeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.PropertyIsCompositeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.StateIsCompositeMatcher;
import org.eclipse.incquery.uml.derivedfeatures.StateIsComposite_0Matcher;
import org.eclipse.incquery.uml.derivedfeatures.util.ConnectorKindQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.MessageMessageKindQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageNestedPackageQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageOwnedStereotypeQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PackageOwnedTypeQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.PropertyIsCompositeQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsCompositeQuerySpecification;
import org.eclipse.incquery.uml.derivedfeatures.util.StateIsComposite_0QuerySpecification;

/**
 * A pattern group formed of all patterns defined in Fixed.eiq.
 * 
 * <p>Use the static instance as any {@link org.eclipse.incquery.runtime.api.IPatternGroup}, to conveniently prepare
 * an EMF-IncQuery engine for matching all patterns originally defined in file Fixed.eiq,
 * in order to achieve better performance than one-by-one on-demand matcher initialization.
 * 
 * <p> From package org.eclipse.incquery.uml.derivedfeatures, the group contains the definition of the following patterns: <ul>
 * <li>connectorKind</li>
 * <li>connectorKindDelegation</li>
 * <li>connectorEndPartWithPort</li>
 * <li>messageMessageKind</li>
 * <li>messageSendEvent</li>
 * <li>messageReceiveEvent</li>
 * <li>packageNestedPackage</li>
 * <li>packageOwnedStereotype</li>
 * <li>packageOwnedType</li>
 * <li>propertyIsComposite</li>
 * <li>stateIsComposite</li>
 * <li>stateIsComposite_0</li>
 * </ul>
 * 
 * @see IPatternGroup
 * 
 */
@SuppressWarnings("all")
public final class Fixed extends BaseGeneratedPatternGroup {
  /**
   * Access the pattern group.
   * 
   * @return the singleton instance of the group
   * @throws IncQueryException if there was an error loading the generated code of pattern specifications
   * 
   */
  public static Fixed instance() throws IncQueryException {
    if (INSTANCE == null) {
    	INSTANCE = new Fixed();
    }
    return INSTANCE;
  }
  
  private static Fixed INSTANCE;
  
  private Fixed() throws IncQueryException {
    querySpecifications.add(ConnectorKindQuerySpecification.instance());
    querySpecifications.add(MessageMessageKindQuerySpecification.instance());
    querySpecifications.add(PackageNestedPackageQuerySpecification.instance());
    querySpecifications.add(PackageOwnedStereotypeQuerySpecification.instance());
    querySpecifications.add(PackageOwnedTypeQuerySpecification.instance());
    querySpecifications.add(PropertyIsCompositeQuerySpecification.instance());
    querySpecifications.add(StateIsCompositeQuerySpecification.instance());
    querySpecifications.add(StateIsComposite_0QuerySpecification.instance());
  }
  
  public ConnectorKindQuerySpecification getConnectorKind() throws IncQueryException {
    return ConnectorKindQuerySpecification.instance();
  }
  
  public ConnectorKindMatcher getConnectorKind(final IncQueryEngine engine) throws IncQueryException {
    return ConnectorKindMatcher.on(engine);
  }
  
  public MessageMessageKindQuerySpecification getMessageMessageKind() throws IncQueryException {
    return MessageMessageKindQuerySpecification.instance();
  }
  
  public MessageMessageKindMatcher getMessageMessageKind(final IncQueryEngine engine) throws IncQueryException {
    return MessageMessageKindMatcher.on(engine);
  }
  
  public PackageNestedPackageQuerySpecification getPackageNestedPackage() throws IncQueryException {
    return PackageNestedPackageQuerySpecification.instance();
  }
  
  public PackageNestedPackageMatcher getPackageNestedPackage(final IncQueryEngine engine) throws IncQueryException {
    return PackageNestedPackageMatcher.on(engine);
  }
  
  public PackageOwnedStereotypeQuerySpecification getPackageOwnedStereotype() throws IncQueryException {
    return PackageOwnedStereotypeQuerySpecification.instance();
  }
  
  public PackageOwnedStereotypeMatcher getPackageOwnedStereotype(final IncQueryEngine engine) throws IncQueryException {
    return PackageOwnedStereotypeMatcher.on(engine);
  }
  
  public PackageOwnedTypeQuerySpecification getPackageOwnedType() throws IncQueryException {
    return PackageOwnedTypeQuerySpecification.instance();
  }
  
  public PackageOwnedTypeMatcher getPackageOwnedType(final IncQueryEngine engine) throws IncQueryException {
    return PackageOwnedTypeMatcher.on(engine);
  }
  
  public PropertyIsCompositeQuerySpecification getPropertyIsComposite() throws IncQueryException {
    return PropertyIsCompositeQuerySpecification.instance();
  }
  
  public PropertyIsCompositeMatcher getPropertyIsComposite(final IncQueryEngine engine) throws IncQueryException {
    return PropertyIsCompositeMatcher.on(engine);
  }
  
  public StateIsCompositeQuerySpecification getStateIsComposite() throws IncQueryException {
    return StateIsCompositeQuerySpecification.instance();
  }
  
  public StateIsCompositeMatcher getStateIsComposite(final IncQueryEngine engine) throws IncQueryException {
    return StateIsCompositeMatcher.on(engine);
  }
  
  public StateIsComposite_0QuerySpecification getStateIsComposite_0() throws IncQueryException {
    return StateIsComposite_0QuerySpecification.instance();
  }
  
  public StateIsComposite_0Matcher getStateIsComposite_0(final IncQueryEngine engine) throws IncQueryException {
    return StateIsComposite_0Matcher.on(engine);
  }
}
