package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementNamespaceMatch;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.namedElementNamespace pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class NamedElementNamespaceProcessor implements IMatchProcessor<NamedElementNamespaceMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pNamedElement the value of pattern parameter namedElement in the currently processed match
   * @param pNamespace the value of pattern parameter namespace in the currently processed match
   * 
   */
  public abstract void process(final NamedElement pNamedElement, final Namespace pNamespace);
  
  @Override
  public void process(final NamedElementNamespaceMatch match) {
    process(match.getNamedElement(), match.getNamespace());
  }
}
