package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementNamespaceMatch;
import org.eclipse.incquery.uml.derivedfeatures.NamedElementNamespaceMatcher;

/**
 * A pattern-specific query specification that can instantiate NamedElementNamespaceMatcher in a type-safe way.
 * 
 * @see NamedElementNamespaceMatcher
 * @see NamedElementNamespaceMatch
 * 
 */
@SuppressWarnings("all")
public final class NamedElementNamespaceQuerySpecification extends BaseGeneratedEMFQuerySpecification<NamedElementNamespaceMatcher> {
  private NamedElementNamespaceQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static NamedElementNamespaceQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected NamedElementNamespaceMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return NamedElementNamespaceMatcher.on(engine);
  }
  
  @Override
  public NamedElementNamespaceMatch newEmptyMatch() {
    return NamedElementNamespaceMatch.newEmptyMatch();
  }
  
  @Override
  public NamedElementNamespaceMatch newMatch(final Object... parameters) {
    return NamedElementNamespaceMatch.newMatch((org.eclipse.uml2.uml.NamedElement) parameters[0], (org.eclipse.uml2.uml.Namespace) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static NamedElementNamespaceQuerySpecification INSTANCE = make();
    
    public static NamedElementNamespaceQuerySpecification make() {
      return new NamedElementNamespaceQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static NamedElementNamespaceQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.namedElementNamespace";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("namedElement","namespace");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("namedElement", "org.eclipse.uml2.uml.NamedElement"),new PParameter("namespace", "org.eclipse.uml2.uml.Namespace"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_namedElement = body.getOrCreateVariableByName("namedElement");
      	PVariable var_namespace = body.getOrCreateVariableByName("namespace");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_namedElement, "namedElement"),
      				
      		new ExportedParameter(body, var_namespace, "namespace")
      	));
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new TypeConstraint(body, new FlatTuple(var_namespace), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Namespace")));
      	new TypeConstraint(body, new FlatTuple(var_namedElement), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement")));
      	new TypeConstraint(body, new FlatTuple(var_namedElement, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "NamedElement", "namespace")));
      	new Equality(body, var__virtual_0_, var_namespace);
      	bodies.add(body);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
