package org.eclipse.incquery.uml.derivedfeatures.util;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFPQuery;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.incquery.runtime.emf.types.EStructuralFeatureInstancesKey;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.Equality;
import org.eclipse.incquery.runtime.matchers.psystem.basicdeferred.ExportedParameter;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.ConstantValue;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.incquery.runtime.matchers.psystem.basicenumerables.TypeConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;
import org.eclipse.incquery.runtime.matchers.tuple.FlatTuple;
import org.eclipse.incquery.uml.derivedfeatures.StructuredClassifierPartMatch;
import org.eclipse.incquery.uml.derivedfeatures.StructuredClassifierPartMatcher;
import org.eclipse.incquery.uml.derivedfeatures.util.PropertyIsCompositeQuerySpecification;

/**
 * A pattern-specific query specification that can instantiate StructuredClassifierPartMatcher in a type-safe way.
 * 
 * @see StructuredClassifierPartMatcher
 * @see StructuredClassifierPartMatch
 * 
 */
@SuppressWarnings("all")
public final class StructuredClassifierPartQuerySpecification extends BaseGeneratedEMFQuerySpecification<StructuredClassifierPartMatcher> {
  private StructuredClassifierPartQuerySpecification() {
    super(GeneratedPQuery.INSTANCE);
  }
  
  /**
   * @return the singleton instance of the query specification
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static StructuredClassifierPartQuerySpecification instance() throws IncQueryException {
    try{
    	return LazyHolder.INSTANCE;
    } catch (ExceptionInInitializerError err) {
    	throw processInitializerError(err);
    }
  }
  
  @Override
  protected StructuredClassifierPartMatcher instantiate(final IncQueryEngine engine) throws IncQueryException {
    return StructuredClassifierPartMatcher.on(engine);
  }
  
  @Override
  public StructuredClassifierPartMatch newEmptyMatch() {
    return StructuredClassifierPartMatch.newEmptyMatch();
  }
  
  @Override
  public StructuredClassifierPartMatch newMatch(final Object... parameters) {
    return StructuredClassifierPartMatch.newMatch((org.eclipse.uml2.uml.StructuredClassifier) parameters[0], (org.eclipse.uml2.uml.Property) parameters[1]);
  }
  
  private static class LazyHolder {
    private final static StructuredClassifierPartQuerySpecification INSTANCE = make();
    
    public static StructuredClassifierPartQuerySpecification make() {
      return new StructuredClassifierPartQuerySpecification();					
    }
  }
  
  private static class GeneratedPQuery extends BaseGeneratedEMFPQuery {
    private final static StructuredClassifierPartQuerySpecification.GeneratedPQuery INSTANCE = new GeneratedPQuery();
    
    @Override
    public String getFullyQualifiedName() {
      return "org.eclipse.incquery.uml.derivedfeatures.structuredClassifierPart";
    }
    
    @Override
    public List<String> getParameterNames() {
      return Arrays.asList("structuredClassifier","part");
    }
    
    @Override
    public List<PParameter> getParameters() {
      return Arrays.asList(new PParameter("structuredClassifier", "org.eclipse.uml2.uml.StructuredClassifier"),new PParameter("part", "org.eclipse.uml2.uml.Property"));
    }
    
    @Override
    public Set<PBody> doGetContainedBodies() throws QueryInitializationException {
      Set<PBody> bodies = Sets.newLinkedHashSet();
      try {
      {
      	PBody body = new PBody(this);
      	PVariable var_structuredClassifier = body.getOrCreateVariableByName("structuredClassifier");
      	PVariable var_part = body.getOrCreateVariableByName("part");
      	PVariable var__virtual_0_ = body.getOrCreateVariableByName(".virtual{0}");
      	PVariable var__virtual_1_ = body.getOrCreateVariableByName(".virtual{1}");
      	body.setExportedParameters(Arrays.<ExportedParameter>asList(
      		new ExportedParameter(body, var_structuredClassifier, "structuredClassifier"),
      				
      		new ExportedParameter(body, var_part, "part")
      	));
      	new TypeConstraint(body, new FlatTuple(var_structuredClassifier), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "StructuredClassifier")));
      	new TypeConstraint(body, new FlatTuple(var_part), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "Property")));
      	new TypeConstraint(body, new FlatTuple(var_structuredClassifier), new EClassTransitiveInstancesKey((EClass)getClassifierLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "StructuredClassifier")));
      	new TypeConstraint(body, new FlatTuple(var_structuredClassifier, var__virtual_0_), new EStructuralFeatureInstancesKey(getFeatureLiteral("http://www.eclipse.org/uml2/5.0.0/UML", "StructuredClassifier", "ownedAttribute")));
      	new Equality(body, var__virtual_0_, var_part);
      	new ConstantValue(body, var__virtual_1_, true);
      	new PositivePatternCall(body, new FlatTuple(var_part, var__virtual_1_), PropertyIsCompositeQuerySpecification.instance().getInternalQueryRepresentation());
      	bodies.add(body);
      }
      	{
      	PAnnotation annotation = new PAnnotation("Surrogate");
      	annotation.addAttribute("feature", "part");
      	addAnnotation(annotation);
      }
      	// to silence compiler error
      	if (false) throw new IncQueryException("Never", "happens");
      } catch (IncQueryException ex) {
      	throw processDependencyException(ex);
      }
      return bodies;
    }
  }
}
