package org.eclipse.incquery.uml.derivedfeatures.util;

import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.uml.derivedfeatures.RelationshipRelatedElementMatch;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Relationship;

/**
 * A match processor tailored for the org.eclipse.incquery.uml.derivedfeatures.relationshipRelatedElement pattern.
 * 
 * Clients should derive an (anonymous) class that implements the abstract process().
 * 
 */
@SuppressWarnings("all")
public abstract class RelationshipRelatedElementProcessor implements IMatchProcessor<RelationshipRelatedElementMatch> {
  /**
   * Defines the action that is to be executed on each match.
   * @param pSource the value of pattern parameter source in the currently processed match
   * @param pTarget the value of pattern parameter target in the currently processed match
   * 
   */
  public abstract void process(final Relationship pSource, final Element pTarget);
  
  @Override
  public void process(final RelationshipRelatedElementMatch match) {
    process(match.getSource(), match.getTarget());
  }
}
