package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.ConnectableElementEndMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.ConnectableElementEndQuerySpecification;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.ConnectorEnd;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.connectableElementEnd pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ConnectableElementEndMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * (inherit(parents()-{@literal >}collect(inheritableMembers(self))-{@literal >}asSet()))
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: parents
 * //{@literal @}Surrogate(feature = "inheritedMember")
 * //{@literal @}QueryExplorer(checked = false)
 * //pattern classifierInheritedMember(source: Classifier, target: NamedElement) {}
 * 
 * 
 * (let    ris : Set(Interface) = allRealizedInterfaces(),
 *         realizingClassifiers : Set(Classifier) =  self.realization.realizingClassifier-{@literal >}union(self.allParents()-{@literal >}collect(realization.realizingClassifier))-{@literal >}asSet(),
 *         allRealizingClassifiers : Set(Classifier) = realizingClassifiers-{@literal >}union(realizingClassifiers.allParents())-{@literal >}asSet(),
 *         realizingClassifierInterfaces : Set(Interface) = allRealizingClassifiers-{@literal >}iterate(c; rci : Set(Interface) = Set{} | rci-{@literal >}union(c.allRealizedInterfaces())),
 *         ports : Set(Port) = self.ownedPort-{@literal >}union(allParents()-{@literal >}collect(ownedPort))-{@literal >}asSet(),
 *         providedByPorts : Set(Interface) = ports.provided-{@literal >}asSet()
 * in     ris-{@literal >}union(realizingClassifierInterfaces) -{@literal >}union(providedByPorts)-{@literal >}asSet())
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: allRealizedInterfaces
 * //{@literal @}Surrogate(feature = "provided")
 * //{@literal @}QueryExplorer(checked = false)
 * //pattern componentProvided(source: Component, target: Interface) {}
 * 
 * 
 * (let    uis : Set(Interface) = allUsedInterfaces(),
 *         realizingClassifiers : Set(Classifier) = self.realization.realizingClassifier-{@literal >}union(self.allParents()-{@literal >}collect(realization.realizingClassifier))-{@literal >}asSet(),
 *         allRealizingClassifiers : Set(Classifier) = realizingClassifiers-{@literal >}union(realizingClassifiers.allParents())-{@literal >}asSet(),
 *         realizingClassifierInterfaces : Set(Interface) = allRealizingClassifiers-{@literal >}iterate(c; rci : Set(Interface) = Set{} | rci-{@literal >}union(c.allUsedInterfaces())),
 *         ports : Set(Port) = self.ownedPort-{@literal >}union(allParents()-{@literal >}collect(ownedPort))-{@literal >}asSet(),
 *         usedByPorts : Set(Interface) = ports.required-{@literal >}asSet()
 * in      uis-{@literal >}union(realizingClassifierInterfaces)-{@literal >}union(usedByPorts)-{@literal >}asSet()
 * )
 * 
 * // Can't compile OCL to IncQuery because of java.lang.UnsupportedOperationException: allUsedInterfaces
 * //{@literal @}Surrogate(feature = "required")
 * //{@literal @}QueryExplorer(checked = false)
 * //pattern componentRequired(source: Component, target: Interface) {}
 * 
 * 
 * (ConnectorEnd.allInstances()-{@literal >}select(role = self))
 * 
 * {@literal @}Surrogate(feature = "end")
 * {@literal @}QueryExplorer(checked = false)
 * pattern connectableElementEnd(
 *     self : ConnectableElement,
 *     temp1 : ConnectorEnd
 * ) {
 *     ConnectorEnd.role(temp1, connectableElement);
 *     connectableElement == self;
 *     ConnectorEnd(connectorEnd);
 *     temp1 == connectorEnd;
 * }
 * </pre></code>
 * 
 * @see ConnectableElementEndMatch
 * @see ConnectableElementEndProcessor
 * @see ConnectableElementEndQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ConnectableElementEndMatcher extends BaseMatcher<ConnectableElementEndMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ConnectableElementEndMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    ConnectableElementEndMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new ConnectableElementEndMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SELF = 0;
  
  private final static int POSITION_TEMP1 = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(ConnectableElementEndMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public ConnectableElementEndMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public ConnectableElementEndMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return matches represented as a ConnectableElementEndMatch object.
   * 
   */
  public Collection<ConnectableElementEndMatch> getAllMatches(final ConnectableElement pSelf, final ConnectorEnd pTemp1) {
    return rawGetAllMatches(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return a match represented as a ConnectableElementEndMatch object, or null if no match is found.
   * 
   */
  public ConnectableElementEndMatch getOneArbitraryMatch(final ConnectableElement pSelf, final ConnectorEnd pTemp1) {
    return rawGetOneArbitraryMatch(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final ConnectableElement pSelf, final ConnectorEnd pTemp1) {
    return rawHasMatch(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final ConnectableElement pSelf, final ConnectorEnd pTemp1) {
    return rawCountMatches(new Object[]{pSelf, pTemp1});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final ConnectableElement pSelf, final ConnectorEnd pTemp1, final IMatchProcessor<? super ConnectableElementEndMatch> processor) {
    rawForEachMatch(new Object[]{pSelf, pTemp1}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final ConnectableElement pSelf, final ConnectorEnd pTemp1, final IMatchProcessor<? super ConnectableElementEndMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSelf, pTemp1}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSelf the fixed value of pattern parameter self, or null if not bound.
   * @param pTemp1 the fixed value of pattern parameter temp1, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ConnectableElementEndMatch newMatch(final ConnectableElement pSelf, final ConnectorEnd pTemp1) {
    return ConnectableElementEndMatch.newMatch(pSelf, pTemp1);
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ConnectableElement> rawAccumulateAllValuesOfself(final Object[] parameters) {
    Set<ConnectableElement> results = new HashSet<ConnectableElement>();
    rawAccumulateAllValues(POSITION_SELF, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectableElement> getAllValuesOfself() {
    return rawAccumulateAllValuesOfself(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectableElement> getAllValuesOfself(final ConnectableElementEndMatch partialMatch) {
    return rawAccumulateAllValuesOfself(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for self.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectableElement> getAllValuesOfself(final ConnectorEnd pTemp1) {
    return rawAccumulateAllValuesOfself(new Object[]{
    null, 
    pTemp1
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<ConnectorEnd> rawAccumulateAllValuesOftemp1(final Object[] parameters) {
    Set<ConnectorEnd> results = new HashSet<ConnectorEnd>();
    rawAccumulateAllValues(POSITION_TEMP1, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorEnd> getAllValuesOftemp1() {
    return rawAccumulateAllValuesOftemp1(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorEnd> getAllValuesOftemp1(final ConnectableElementEndMatch partialMatch) {
    return rawAccumulateAllValuesOftemp1(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for temp1.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<ConnectorEnd> getAllValuesOftemp1(final ConnectableElement pSelf) {
    return rawAccumulateAllValuesOftemp1(new Object[]{
    pSelf, 
    null
    });
  }
  
  @Override
  protected ConnectableElementEndMatch tupleToMatch(final Tuple t) {
    try {
    	return ConnectableElementEndMatch.newMatch((ConnectableElement) t.get(POSITION_SELF), (ConnectorEnd) t.get(POSITION_TEMP1));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ConnectableElementEndMatch arrayToMatch(final Object[] match) {
    try {
    	return ConnectableElementEndMatch.newMatch((ConnectableElement) match[POSITION_SELF], (ConnectorEnd) match[POSITION_TEMP1]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ConnectableElementEndMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ConnectableElementEndMatch.newMutableMatch((ConnectableElement) match[POSITION_SELF], (ConnectorEnd) match[POSITION_TEMP1]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ConnectableElementEndMatcher> querySpecification() throws IncQueryException {
    return ConnectableElementEndQuerySpecification.instance();
  }
}
