package org.eclipse.incquery.uml.derivedfeatures;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.impl.BaseMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.tuple.Tuple;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.uml.derivedfeatures.ElementOwnedElementMatch;
import org.eclipse.incquery.uml.derivedfeatures.util.ElementOwnedElementQuerySpecification;
import org.eclipse.uml2.uml.Element;

/**
 * Generated pattern matcher API of the org.eclipse.incquery.uml.derivedfeatures.elementOwnedElement pattern,
 * providing pattern-specific query methods.
 * 
 * <p>Use the pattern matcher on a given model via {@link #on(IncQueryEngine)},
 * e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}.
 * 
 * <p>Matches of the pattern will be represented as {@link ElementOwnedElementMatch}.
 * 
 * <p>Original source:
 * <code><pre>
 * {@literal @}Surrogate(feature = "ownedElement")
 * {@literal @}QueryExplorer(checked = false)
 * pattern elementOwnedElement(source: Element, target: Element)
 * { Abstraction.mapping(source, target); } or 
 * { AcceptEventAction.trigger(source, target); } or 
 * { find actionInput(source, target); } or 
 * { Action.localPostcondition(source, target); } or 
 * { Action.localPrecondition(source, target); } or 
 * { find actionOutput(source, target); } or 
 * { ActionInputPin.fromAction(source, target); } or 
 * { Activity.edge(source, target); } or 
 * { find activityGroup(source, target); } or 
 * { find activityNode(source, target); } or 
 * { ActivityEdge.guard(source, target); } or 
 * { ActivityEdge.weight(source, target); } or 
 * { find activityGroupSubgroup(source, target); } or 
 * { Artifact.manifestation(source, target); } or 
 * { BehavioredClassifier.interfaceRealization(source, target); } or 
 * { ChangeEvent.changeExpression(source, target); } or 
 * { Classifier.collaborationUse(source, target); } or 
 * { Classifier.generalization(source, target); } or 
 * { Classifier.substitution(source, target); } or 
 * { CollaborationUse.roleBinding(source, target); } or 
 * { CombinedFragment.cfragmentGate(source, target); } or 
 * { CombinedFragment.operand(source, target); } or 
 * { Component.realization(source, target); } or 
 * { ConditionalNode.clause(source, target); } or 
 * { Connector.end(source, target); } or 
 * { Constraint.specification(source, target); } or 
 * { Deployment.configuration(source, target); } or 
 * { DeploymentTarget.deployment(source, target); } or 
 * { Duration.expr(source, target); } or 
 * { Element.ownedComment(source, target); } or 
 * { ExecutableNode.handler(source, target); } or 
 * { Expression.operand(source, target); } or 
 * { Extend.condition(source, target); } or 
 * { InstanceSpecification.slot(source, target); } or 
 * { InstanceSpecification.specification(source, target); } or 
 * { Interaction.action(source, target); } or 
 * { InteractionConstraint.maxint(source, target); } or 
 * { InteractionConstraint.minint(source, target); } or 
 * { InteractionFragment.generalOrdering(source, target); } or 
 * { InteractionOperand.guard(source, target); } or 
 * { InteractionUse.actualGate(source, target); } or 
 * { InteractionUse.argument(source, target); } or 
 * { InteractionUse.returnValue(source, target); } or 
 * { JoinNode.joinSpec(source, target); } or 
 * { Lifeline.selector(source, target); } or 
 * { LinkAction.endData(source, target); } or 
 * { LinkEndData.qualifier(source, target); } or 
 * { LoopNode.loopVariable(source, target); } or 
 * { Message.argument(source, target); } or 
 * { MultiplicityElement.lowerValue(source, target); } or 
 * { MultiplicityElement.upperValue(source, target); } or 
 * { NamedElement.nameExpression(source, target); } or 
 * { Namespace.elementImport(source, target); } or 
 * { find namespaceOwnedMember(source, target); } or 
 * { Namespace.packageImport(source, target); } or 
 * { ObjectNode.upperBound(source, target); } or 
 * { Package.packageMerge(source, target); } or 
 * { Package.profileApplication(source, target); } or 
 * { Parameter.defaultValue(source, target); } or 
 * { ParameterSet.condition(source, target); } or 
 * { Property.defaultValue(source, target); } or 
 * { Property.qualifier(source, target); } or 
 * { ProtocolStateMachine.conformance(source, target); } or 
 * { Slot.value(source, target); } or 
 * { State.deferrableTrigger(source, target); } or 
 * { State.doActivity(source, target); } or 
 * { State.entry(source, target); } or 
 * { State.exit(source, target); } or 
 * { StateInvariant.invariant(source, target); } or 
 * { Stereotype.icon(source, target); } or 
 * { StringExpression.subExpression(source, target); } or 
 * { StructuredActivityNode.edge(source, target); } or 
 * { StructuredActivityNode.node(source, target); } or 
 * { TemplateBinding.parameterSubstitution(source, target); } or 
 * { TemplateParameter.ownedDefault(source, target); } or 
 * { TemplateParameter.ownedParameteredElement(source, target); } or 
 * { TemplateParameterSubstitution.ownedActual(source, target); } or 
 * { TemplateSignature.ownedParameter(source, target); } or 
 * { TemplateableElement.ownedTemplateSignature(source, target); } or 
 * { TemplateableElement.templateBinding(source, target); } or 
 * { TimeEvent.when(source, target); } or 
 * { TimeExpression.expr(source, target); } or 
 * { Transition.effect(source, target); } or 
 * { Transition.trigger(source, target); } or 
 * { ValuePin.value(source, target); } or 
 * { ValueSpecificationAction.value(source, target); }
 * </pre></code>
 * 
 * @see ElementOwnedElementMatch
 * @see ElementOwnedElementProcessor
 * @see ElementOwnedElementQuerySpecification
 * 
 */
@SuppressWarnings("all")
public class ElementOwnedElementMatcher extends BaseMatcher<ElementOwnedElementMatch> {
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * 
   */
  public static ElementOwnedElementMatcher on(final IncQueryEngine engine) throws IncQueryException {
    // check if matcher already exists
    ElementOwnedElementMatcher matcher = engine.getExistingMatcher(querySpecification());
    if (matcher == null) {
    	matcher = new ElementOwnedElementMatcher(engine);
    	// do not have to "put" it into engine.matchers, reportMatcherInitialized() will take care of it
    }
    return matcher;
  }
  
  private final static int POSITION_SOURCE = 0;
  
  private final static int POSITION_TARGET = 1;
  
  private final static Logger LOGGER = IncQueryLoggingUtil.getLogger(ElementOwnedElementMatcher.class);
  
  /**
   * Initializes the pattern matcher over a given EMF model root (recommended: Resource or ResourceSet).
   * If a pattern matcher is already constructed with the same root, only a light-weight reference is returned.
   * The scope of pattern matching will be the given EMF model root and below (see FAQ for more precise definition).
   * The match set will be incrementally refreshed upon updates from this scope.
   * <p>The matcher will be created within the managed {@link IncQueryEngine} belonging to the EMF model root, so
   * multiple matchers will reuse the same engine and benefit from increased performance and reduced memory footprint.
   * @param emfRoot the root of the EMF containment hierarchy where the pattern matcher will operate. Recommended: Resource or ResourceSet.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead, e.g. in conjunction with {@link IncQueryEngine#on(Notifier)}
   * 
   */
  @Deprecated
  public ElementOwnedElementMatcher(final Notifier emfRoot) throws IncQueryException {
    this(IncQueryEngine.on(emfRoot));
  }
  
  /**
   * Initializes the pattern matcher within an existing EMF-IncQuery engine.
   * If the pattern matcher is already constructed in the engine, only a light-weight reference is returned.
   * The match set will be incrementally refreshed upon updates.
   * @param engine the existing EMF-IncQuery engine in which this matcher will be created.
   * @throws IncQueryException if an error occurs during pattern matcher creation
   * @deprecated use {@link #on(IncQueryEngine)} instead
   * 
   */
  @Deprecated
  public ElementOwnedElementMatcher(final IncQueryEngine engine) throws IncQueryException {
    super(engine, querySpecification());
  }
  
  /**
   * Returns the set of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @return matches represented as a ElementOwnedElementMatch object.
   * 
   */
  public Collection<ElementOwnedElementMatch> getAllMatches(final Element pSource, final Element pTarget) {
    return rawGetAllMatches(new Object[]{pSource, pTarget});
  }
  
  /**
   * Returns an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @return a match represented as a ElementOwnedElementMatch object, or null if no match is found.
   * 
   */
  public ElementOwnedElementMatch getOneArbitraryMatch(final Element pSource, final Element pTarget) {
    return rawGetOneArbitraryMatch(new Object[]{pSource, pTarget});
  }
  
  /**
   * Indicates whether the given combination of specified pattern parameters constitute a valid pattern match,
   * under any possible substitution of the unspecified parameters (if any).
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @return true if the input is a valid (partial) match of the pattern.
   * 
   */
  public boolean hasMatch(final Element pSource, final Element pTarget) {
    return rawHasMatch(new Object[]{pSource, pTarget});
  }
  
  /**
   * Returns the number of all matches of the pattern that conform to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @return the number of pattern matches found.
   * 
   */
  public int countMatches(final Element pSource, final Element pTarget) {
    return rawCountMatches(new Object[]{pSource, pTarget});
  }
  
  /**
   * Executes the given processor on each match of the pattern that conforms to the given fixed values of some parameters.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param processor the action that will process each pattern match.
   * 
   */
  public void forEachMatch(final Element pSource, final Element pTarget, final IMatchProcessor<? super ElementOwnedElementMatch> processor) {
    rawForEachMatch(new Object[]{pSource, pTarget}, processor);
  }
  
  /**
   * Executes the given processor on an arbitrarily chosen match of the pattern that conforms to the given fixed values of some parameters.
   * Neither determinism nor randomness of selection is guaranteed.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @param processor the action that will process the selected match.
   * @return true if the pattern has at least one match with the given parameter values, false if the processor was not invoked
   * 
   */
  public boolean forOneArbitraryMatch(final Element pSource, final Element pTarget, final IMatchProcessor<? super ElementOwnedElementMatch> processor) {
    return rawForOneArbitraryMatch(new Object[]{pSource, pTarget}, processor);
  }
  
  /**
   * Returns a new (partial) match.
   * This can be used e.g. to call the matcher with a partial match.
   * <p>The returned match will be immutable. Use {@link #newEmptyMatch()} to obtain a mutable match object.
   * @param pSource the fixed value of pattern parameter source, or null if not bound.
   * @param pTarget the fixed value of pattern parameter target, or null if not bound.
   * @return the (partial) match object.
   * 
   */
  public ElementOwnedElementMatch newMatch(final Element pSource, final Element pTarget) {
    return ElementOwnedElementMatch.newMatch(pSource, pTarget);
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Element> rawAccumulateAllValuesOfsource(final Object[] parameters) {
    Set<Element> results = new HashSet<Element>();
    rawAccumulateAllValues(POSITION_SOURCE, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOfsource() {
    return rawAccumulateAllValuesOfsource(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOfsource(final ElementOwnedElementMatch partialMatch) {
    return rawAccumulateAllValuesOfsource(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for source.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOfsource(final Element pTarget) {
    return rawAccumulateAllValuesOfsource(new Object[]{
    null, 
    pTarget
    });
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  protected Set<Element> rawAccumulateAllValuesOftarget(final Object[] parameters) {
    Set<Element> results = new HashSet<Element>();
    rawAccumulateAllValues(POSITION_TARGET, parameters, results);
    return results;
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOftarget() {
    return rawAccumulateAllValuesOftarget(emptyArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOftarget(final ElementOwnedElementMatch partialMatch) {
    return rawAccumulateAllValuesOftarget(partialMatch.toArray());
  }
  
  /**
   * Retrieve the set of values that occur in matches for target.
   * @return the Set of all values, null if no parameter with the given name exists, empty set if there are no matches
   * 
   */
  public Set<Element> getAllValuesOftarget(final Element pSource) {
    return rawAccumulateAllValuesOftarget(new Object[]{
    pSource, 
    null
    });
  }
  
  @Override
  protected ElementOwnedElementMatch tupleToMatch(final Tuple t) {
    try {
    	return ElementOwnedElementMatch.newMatch((Element) t.get(POSITION_SOURCE), (Element) t.get(POSITION_TARGET));
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in tuple not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ElementOwnedElementMatch arrayToMatch(final Object[] match) {
    try {
    	return ElementOwnedElementMatch.newMatch((Element) match[POSITION_SOURCE], (Element) match[POSITION_TARGET]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  @Override
  protected ElementOwnedElementMatch arrayToMatchMutable(final Object[] match) {
    try {
    	return ElementOwnedElementMatch.newMutableMatch((Element) match[POSITION_SOURCE], (Element) match[POSITION_TARGET]);
    } catch(ClassCastException e) {
    	LOGGER.error("Element(s) in array not properly typed!",e);
    	return null;
    }
  }
  
  /**
   * @return the singleton instance of the query specification of this pattern
   * @throws IncQueryException if the pattern definition could not be loaded
   * 
   */
  public static IQuerySpecification<ElementOwnedElementMatcher> querySpecification() throws IncQueryException {
    return ElementOwnedElementQuerySpecification.instance();
  }
}
