/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.core;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.evm.api.ActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.api.ExecutionSchema;
import org.eclipse.incquery.runtime.evm.api.Job;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.Scheduler;
import org.eclipse.incquery.runtime.evm.specific.ExecutionSchemas;
import org.eclipse.incquery.runtime.evm.specific.Jobs;
import org.eclipse.incquery.runtime.evm.specific.Rules;
import org.eclipse.incquery.runtime.evm.specific.Schedulers;
import org.eclipse.incquery.runtime.evm.specific.event.IncQueryActivationStateEnum;
import org.eclipse.incquery.runtime.evm.specific.lifecycle.DefaultActivationLifeCycle;
import org.eclipse.incquery.runtime.evm.specific.scheduler.UpdateCompleteBasedScheduler;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.validation.core.Constraint;
import org.eclipse.incquery.validation.core.MatchAppearanceJob;
import org.eclipse.incquery.validation.core.MatchDisappearanceJob;
import org.eclipse.incquery.validation.core.MatchUpdateJob;
import org.eclipse.incquery.validation.core.api.IConstraint;
import org.eclipse.incquery.validation.core.api.IConstraintSpecification;
import org.eclipse.incquery.validation.core.api.IValidationEngine;
import org.eclipse.incquery.validation.core.listeners.ValidationEngineListener;

public class ValidationEngine
implements IValidationEngine {
    private Logger logger;
    private IncQueryEngine incQueryEngine;
    private ExecutionSchema executionSchema;
    private Map<IConstraintSpecification, Constraint> constraintMap;
    private Set<ValidationEngineListener> listeners;

    protected IncQueryEngine getIncQueryEngine() {
        return this.incQueryEngine;
    }

    protected ExecutionSchema getExecutionSchema() {
        return this.executionSchema;
    }

    public ValidationEngine(Notifier notifier, Logger logger) {
        this.logger = logger;
        this.constraintMap = new HashMap<IConstraintSpecification, Constraint>();
        this.listeners = new HashSet<ValidationEngineListener>();
        try {
            this.incQueryEngine = IncQueryEngine.on((IncQueryScope)new EMFScope(notifier));
            UpdateCompleteBasedScheduler.UpdateCompleteBasedSchedulerFactory schedulerFactory = Schedulers.getIQEngineSchedulerFactory((IncQueryEngine)this.incQueryEngine);
            this.executionSchema = ExecutionSchemas.createIncQueryExecutionSchema((IncQueryEngine)this.incQueryEngine, (Scheduler.ISchedulerFactory)schedulerFactory);
        }
        catch (IncQueryException e) {
            IncQueryLoggingUtil.getDefaultLogger().error((Object)String.format("Exception occured when creating engine for validation: %s", e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void initialize() {
        this.executionSchema.startUnscheduledExecution();
    }

    @Override
    public void dispose() {
        this.executionSchema.dispose();
        this.constraintMap.clear();
        this.listeners.clear();
    }

    public Set<IConstraint> getConstraints() {
        return ImmutableSet.copyOf(this.constraintMap.values());
    }

    @Override
    public IConstraint addConstraintSpecification(IConstraintSpecification constraintSpecification) {
        Constraint constraint = new Constraint(constraintSpecification, this, this.logger);
        if (this.constraintMap.put(constraintSpecification, constraint) == null) {
            this.notifyListenersConstraintRegistered(constraint);
        }
        return constraint;
    }

    @Override
    public IConstraint removeConstraintSpecification(IConstraintSpecification constraintSpecification) {
        Constraint constraint = this.constraintMap.get(constraintSpecification);
        this.removeRuleSpecificationFromExecutionSchema(constraint);
        if (this.constraintMap.remove(constraintSpecification) != null) {
            this.notifyListenersConstraintDeregistered(constraint);
        }
        return constraint;
    }

    protected boolean addRuleSpecificationToExecutionSchema(Constraint constraint) {
        ImmutableSet jobs = ImmutableSet.of((Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.APPEARED, (IMatchProcessor)new MatchAppearanceJob(constraint, this.logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.DISAPPEARED, (IMatchProcessor)new MatchDisappearanceJob(constraint, this.logger))), (Object)Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((IncQueryActivationStateEnum)IncQueryActivationStateEnum.UPDATED, (IMatchProcessor)new MatchUpdateJob(constraint, this.logger))));
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification = constraint.getSpecification().getQuerySpecification();
        RuleSpecification rule = Rules.newMatcherRuleSpecification(querySpecification, (ActivationLifeCycle)DefaultActivationLifeCycle.DEFAULT, (Set)jobs);
        constraint.setRuleSpecification((RuleSpecification<IPatternMatch>)rule);
        boolean added = this.executionSchema.addRule(rule);
        this.executionSchema.startUnscheduledExecution();
        return added;
    }

    protected boolean removeRuleSpecificationFromExecutionSchema(Constraint constraint) {
        RuleSpecification<IPatternMatch> ruleSpecification = constraint.getRuleSpecification();
        if (ruleSpecification != null) {
            constraint.setRuleSpecification(null);
            return this.executionSchema.removeRule(ruleSpecification);
        }
        return false;
    }

    public Set<ValidationEngineListener> getListeners() {
        return ImmutableSet.copyOf(this.listeners);
    }

    @Override
    public boolean addListener(ValidationEngineListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(ValidationEngineListener listener) {
        return this.listeners.remove(listener);
    }

    protected void notifyListenersConstraintRegistered(Constraint constraint) {
        for (ValidationEngineListener listener : this.listeners) {
            listener.constraintRegistered(constraint);
        }
    }

    protected void notifyListenersConstraintDeregistered(Constraint constraint) {
        for (ValidationEngineListener listener : this.listeners) {
            listener.constraintDeregistered(constraint);
        }
    }
}

