/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.runtime;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.validation.core.ValidationEngine;
import org.eclipse.incquery.validation.core.api.IConstraintSpecification;
import org.eclipse.incquery.validation.core.api.IValidationEngine;

public final class ValidationManager {
    private static final String CONSTRAINT_ATTRIBUTE_NAME = "constraint";
    private static final String VALIDATION_RUNTIME_CONSTRAINT_EXTENSION_ID = "org.eclipse.incquery.validation.runtime.constraint";
    private static final String EDITOR_ID_ATTRIBUTE_NAME = "editorId";
    private static final String ENABLED_FOR_EDITOR_ATTRIBUTE_NAME = "enabledForEditor";
    private static final String CLASS_ATTRIBUTE_NAME = "class";
    private static Logger logger = Logger.getLogger(ValidationManager.class);
    private static Set<String> genericEditorIds = Sets.newHashSet((Object[])new String[]{"org.eclipse.emf.ecore.presentation.XMLReflectiveEditorID", "org.eclipse.emf.ecore.presentation.ReflectiveEditorID", "org.eclipse.emf.genericEditor"});
    private static Multimap<String, IConstraintSpecification> editorConstraintSpecificationMap;

    private ValidationManager() {
    }

    public static synchronized Multimap<String, IConstraintSpecification> getEditorConstraintSpecificationMap() {
        if (editorConstraintSpecificationMap == null) {
            editorConstraintSpecificationMap = ValidationManager.loadConstraintSpecificationsFromExtensions();
        }
        return editorConstraintSpecificationMap;
    }

    public static synchronized boolean isConstraintSpecificationsRegisteredForEditorId(String editorId) {
        return ValidationManager.getEditorConstraintSpecificationMap().containsKey((Object)editorId);
    }

    public static synchronized Set<IConstraintSpecification> getConstraintSpecificationsForEditorId(String editorId) {
        if (genericEditorIds.contains(editorId)) {
            return ImmutableSet.copyOf((Collection)ValidationManager.getEditorConstraintSpecificationMap().values());
        }
        HashSet<IConstraintSpecification> set = new HashSet<IConstraintSpecification>(ValidationManager.getEditorConstraintSpecificationMap().get((Object)editorId));
        set.addAll(ValidationManager.getEditorConstraintSpecificationMap().get((Object)"*"));
        return set;
    }

    private static synchronized Multimap<String, IConstraintSpecification> loadConstraintSpecificationsFromExtensions() {
        HashMultimap result = HashMultimap.create();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(VALIDATION_RUNTIME_CONSTRAINT_EXTENSION_ID);
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals(CONSTRAINT_ATTRIBUTE_NAME)) {
                    ValidationManager.processConstraintSpecificationConfigurationElement((Multimap<String, IConstraintSpecification>)result, ce);
                }
                ++n4;
            }
            ++n2;
        }
        return result;
    }

    private static void processConstraintSpecificationConfigurationElement(Multimap<String, IConstraintSpecification> result, IConfigurationElement ce) {
        try {
            ArrayList<String> ids = new ArrayList<String>();
            IConfigurationElement[] iConfigurationElementArray = ce.getChildren();
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IConfigurationElement child = iConfigurationElementArray[n2];
                if (child.getName().equals(ENABLED_FOR_EDITOR_ATTRIBUTE_NAME) && (id = child.getAttribute(EDITOR_ID_ATTRIBUTE_NAME)) != null && !id.equals("")) {
                    ids.add(id);
                }
                ++n2;
            }
            Object o = ce.createExecutableExtension(CLASS_ATTRIBUTE_NAME);
            if (o instanceof IConstraintSpecification) {
                if (ids.isEmpty()) {
                    ids.add("*");
                }
                for (String id : ids) {
                    result.put((Object)id, (Object)((IConstraintSpecification)o));
                }
            }
        }
        catch (CoreException e) {
            logger.error((Object)"Error loading EMF-IncQuery Validation ConstraintSpecification", (Throwable)e);
        }
    }

    public static IValidationEngine initializeValidationEngine(Notifier notifier, String editorId) {
        ValidationEngine validationEngine = new ValidationEngine(notifier, logger);
        for (IConstraintSpecification constraintSpecification : ValidationManager.getConstraintSpecificationsForEditorId(editorId)) {
            validationEngine.addConstraintSpecification(constraintSpecification);
        }
        validationEngine.initialize();
        return validationEngine;
    }
}

