/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.runtime.model;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.scope.IncQueryScope;
import org.eclipse.incquery.runtime.emf.EMFScope;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.viewers.runtime.model.NotationFactory;
import org.eclipse.incquery.viewers.runtime.model.NotationModel;
import org.eclipse.incquery.viewmodel.core.ViewModelManager;

public abstract class ViewerDataModel {
    private final String NOTATION_RESOURCE = "org.eclipse.incquery.viewers.notation.NotationResource";
    protected NotationModel model;
    protected IncQueryEngine engine;
    protected ResourceSet resourceSet;

    public ViewerDataModel(ResourceSet notifier) throws IncQueryException {
        this(IncQueryEngine.on((IncQueryScope)new EMFScope((Notifier)notifier)));
    }

    public ViewerDataModel(IncQueryEngine engine) {
        if (!(engine.getScope() instanceof EMFScope)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only EMFScope is supported currently for IncQueryEngine");
            return;
        }
        if (!(((EMFScope)engine.getScope()).getScopeRoot() instanceof ResourceSet)) {
            IncQueryLoggingUtil.getLogger(ViewModelManager.class).error((Object)"Only ResourceSet is supported currently for EMFScope");
            return;
        }
        this.model = NotationFactory.eINSTANCE.createNotationModel();
        this.engine = engine;
        this.prepareBaseNotifier();
    }

    private void prepareBaseNotifier() {
        ResourceSet resourceSet = (ResourceSet)((EMFScope)this.engine.getScope()).getScopeRoot();
        Resource resource = null;
        for (Resource r : resourceSet.getResources()) {
            if (!r.getURI().toString().equals(this.getNotationResourceId())) continue;
            resource = r;
            break;
        }
        if (resource == null) {
            resource = resourceSet.createResource(URI.createURI((String)this.getNotationResourceId()));
        }
        resource.getContents().add((Object)this.model);
    }

    private String getNotationResourceId() {
        return "org.eclipse.incquery.viewers.notation.NotationResource";
    }

    public NotationModel getNotationModel() {
        return this.model;
    }

    public IncQueryEngine getEngine() {
        return this.engine;
    }

    public void dispose() {
        EcoreUtil.delete((EObject)this.model);
    }

    public abstract Collection<IQuerySpecification<?>> getPatterns();
}

