/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.viewers.tooling.ui.views;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.viewers.runtime.ViewersRuntimePlugin;
import org.eclipse.incquery.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.incquery.viewers.runtime.model.ViewersRuntimeModelUtil;
import org.eclipse.incquery.viewers.tooling.ui.views.ViewersMultiSandboxViewComponent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ViewersMultiSandoxViewComponentSettings {
    private CheckboxTreeViewer activatedPatternsViewer;
    private ViewersMultiSandboxViewComponent owner;
    private Map<IQuerySpecification<?>, Boolean> checkedPatterns = Maps.newHashMap();
    private ViewersComponentConfiguration currentConfiguration;

    public ViewersMultiSandoxViewComponentSettings(ViewersMultiSandboxViewComponent c) {
        this.owner = c;
    }

    public void initialConfigurationChanged(ViewersComponentConfiguration c) {
        this.currentConfiguration = c.newCopy();
        this.checkedPatterns.clear();
        for (IQuerySpecification p : this.currentConfiguration.getPatterns()) {
            this.checkedPatterns.put(p, true);
        }
        this.activatedPatternsViewer.setInput(this.checkedPatterns.keySet());
    }

    private void applyConfiguration() {
        this.owner.applyConfiguration(this.currentConfiguration);
    }

    public void createUI() {
        CTabItem settingsTab = new CTabItem(this.owner.folder, 0);
        settingsTab.setText("Settings");
        Composite sTabComposite = new Composite((Composite)this.owner.folder, 0);
        settingsTab.setControl((Control)sTabComposite);
        sTabComposite.setLayout((Layout)new GridLayout(1, false));
        Group patternListGroup = new Group(sTabComposite, 2048);
        patternListGroup.setLayout((Layout)new FillLayout());
        patternListGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        patternListGroup.setText("Activated queries");
        this.activatedPatternsViewer = new CheckboxTreeViewer((Composite)patternListGroup, 2080);
        this.activatedPatternsViewer.setLabelProvider((IBaseLabelProvider)new PatternListLabelProvider());
        this.activatedPatternsViewer.setContentProvider((IContentProvider)new PatternListContentProvider());
        this.activatedPatternsViewer.addCheckStateListener((ICheckStateListener)new PatternListCheckStateListener());
        this.activatedPatternsViewer.setCheckStateProvider((ICheckStateProvider)new PatternListCheckStateProvider());
        this.activatedPatternsViewer.setComparator((ViewerComparator)new PatternListComparator());
        Button applyButton = new Button(sTabComposite, 8);
        applyButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        applyButton.setBounds(0, 0, 94, 28);
        applyButton.setText("Apply");
        applyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ViewersMultiSandoxViewComponentSettings.this.applyConfiguration();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ViewersMultiSandoxViewComponentSettings.this.applyConfiguration();
            }
        });
    }

    class PatternListCheckStateListener
    implements ICheckStateListener {
        PatternListCheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            ViewersMultiSandoxViewComponentSettings.this.checkedPatterns.put((IQuerySpecification)event.getElement(), event.getChecked());
            if (event.getChecked()) {
                ViewersMultiSandoxViewComponentSettings.this.currentConfiguration.getPatterns().add((IQuerySpecification)event.getElement());
            } else {
                ViewersMultiSandoxViewComponentSettings.this.currentConfiguration.getPatterns().remove(event.getElement());
            }
        }
    }

    class PatternListCheckStateProvider
    implements ICheckStateProvider {
        PatternListCheckStateProvider() {
        }

        public boolean isChecked(Object element) {
            return (Boolean)ViewersMultiSandoxViewComponentSettings.this.checkedPatterns.get(element);
        }

        public boolean isGrayed(Object element) {
            return false;
        }
    }

    class PatternListComparator
    extends ViewerComparator {
        PatternListComparator() {
        }

        public int category(Object element) {
            if (element instanceof IQuerySpecification) {
                IQuerySpecification qs = (IQuerySpecification)element;
                if (ViewersRuntimeModelUtil.isItemQuerySpecification((IQuerySpecification)qs)) {
                    return 0;
                }
                if (ViewersRuntimeModelUtil.isEdgeQuerySpecification((IQuerySpecification)qs)) {
                    return 1;
                }
                if (ViewersRuntimeModelUtil.isContainmentQuerySpecification((IQuerySpecification)qs)) {
                    return 2;
                }
            }
            return super.category(element);
        }
    }

    class PatternListContentProvider
    implements ITreeContentProvider {
        PatternListContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Collection)inputElement).toArray();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    }

    class PatternListLabelProvider
    extends LabelProvider {
        private Image itemIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/item.gif").createImage();
        private Image edgeIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/edge.gif").createImage();
        private Image contIcon = ViewersRuntimePlugin.imageDescriptorFromPlugin((String)"org.eclipse.incquery.viewers.runtime", (String)"icons/containment.gif").createImage();

        PatternListLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IQuerySpecification) {
                IQuerySpecification qs = (IQuerySpecification)element;
                if (ViewersRuntimeModelUtil.isItemQuerySpecification((IQuerySpecification)qs)) {
                    return "Item : " + qs.getFullyQualifiedName();
                }
                if (ViewersRuntimeModelUtil.isEdgeQuerySpecification((IQuerySpecification)qs)) {
                    return "Edge : " + qs.getFullyQualifiedName();
                }
                if (ViewersRuntimeModelUtil.isContainmentQuerySpecification((IQuerySpecification)qs)) {
                    return "Containment : " + qs.getFullyQualifiedName();
                }
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IQuerySpecification) {
                IQuerySpecification qs = (IQuerySpecification)element;
                if (ViewersRuntimeModelUtil.isItemQuerySpecification((IQuerySpecification)qs)) {
                    return this.itemIcon;
                }
                if (ViewersRuntimeModelUtil.isEdgeQuerySpecification((IQuerySpecification)qs)) {
                    return this.edgeIcon;
                }
                if (ViewersRuntimeModelUtil.isContainmentQuerySpecification((IQuerySpecification)qs)) {
                    return this.contIcon;
                }
            }
            return super.getImage(element);
        }

        public void dispose() {
            this.itemIcon.dispose();
            this.edgeIcon.dispose();
            this.contIcon.dispose();
            super.dispose();
        }
    }
}

